/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.CraftingRecipe;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.item.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class ShapelessRecipe
implements CraftingRecipe {
    private String recipeId;
    private final Item output;
    private long least;
    private long most;
    private final List<Item> ingredients;
    private final List<Item> ingredientsAggregate;
    private final int priority;

    public ShapelessRecipe(Item result, Collection<Item> ingredients) {
        this(null, 10, result, ingredients);
    }

    public ShapelessRecipe(String recipeId, int priority, Item result, Collection<Item> ingredients) {
        this.recipeId = recipeId;
        this.priority = priority;
        this.output = result.clone();
        if (ingredients.size() > 9) {
            throw new IllegalArgumentException("Shapeless recipes cannot have more than 9 ingredients");
        }
        this.ingredients = new ArrayList<Item>();
        this.ingredientsAggregate = new ArrayList<Item>();
        for (Item item : ingredients) {
            if (item.getCount() < 1) {
                throw new IllegalArgumentException("Recipe '" + recipeId + "' Ingredient amount was not 1 (value: " + item.getCount() + ")");
            }
            boolean found = false;
            for (Item existingIngredient : this.ingredientsAggregate) {
                if (!existingIngredient.equals(item, item.hasMeta(), item.hasCompoundTag())) continue;
                existingIngredient.setCount(existingIngredient.getCount() + item.getCount());
                found = true;
                break;
            }
            if (!found) {
                this.ingredientsAggregate.add(item.clone());
            }
            this.ingredients.add(item.clone());
        }
        this.ingredientsAggregate.sort(CraftingManager.recipeComparator);
    }

    @Override
    public Item getResult() {
        return this.output.clone();
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public UUID getId() {
        return new UUID(this.least, this.most);
    }

    @Override
    public void setId(UUID uuid) {
        this.least = uuid.getLeastSignificantBits();
        this.most = uuid.getMostSignificantBits();
        if (this.recipeId == null) {
            this.recipeId = this.getId().toString();
        }
    }

    public List<Item> getIngredientList() {
        ArrayList<Item> ingredients = new ArrayList<Item>();
        for (Item ingredient : this.ingredients) {
            ingredients.add(ingredient.clone());
        }
        return ingredients;
    }

    public int getIngredientCount() {
        return this.ingredients.size();
    }

    @Override
    public void registerToCraftingManager(CraftingManager manager) {
        manager.registerShapelessRecipe(this);
    }

    @Override
    public RecipeType getType() {
        return RecipeType.SHAPELESS;
    }

    @Override
    public boolean requiresCraftingTable() {
        return this.ingredients.size() > 4;
    }

    @Override
    public List<Item> getExtraResults() {
        return new ArrayList<Item>();
    }

    @Override
    public List<Item> getAllResults() {
        return null;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean matchItems(List<Item> inputList, List<Item> extraOutputList, int multiplier) {
        ArrayList<Item> haveInputs = new ArrayList<Item>();
        for (Item item : inputList) {
            if (item.isNull()) continue;
            haveInputs.add(item.clone());
        }
        ArrayList<Item> needInputs = new ArrayList<Item>();
        if (multiplier != 1) {
            for (Item item : this.ingredientsAggregate) {
                if (item.isNull()) continue;
                Item itemClone = item.clone();
                itemClone.setCount(itemClone.getCount() * multiplier);
                needInputs.add(itemClone);
            }
        } else {
            for (Item item : this.ingredientsAggregate) {
                if (item.isNull()) continue;
                needInputs.add(item.clone());
            }
        }
        if (!Recipe.matchItemList(haveInputs, needInputs)) {
            return false;
        }
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (Item item : extraOutputList) {
            if (item.isNull()) continue;
            arrayList.add(item.clone());
        }
        arrayList.sort(CraftingManager.recipeComparator);
        ArrayList<Item> arrayList2 = new ArrayList<Item>();
        if (multiplier != 1) {
            for (Item item : this.getExtraResults()) {
                if (item.isNull()) continue;
                Item itemClone = item.clone();
                itemClone.setCount(itemClone.getCount() * multiplier);
                arrayList2.add(itemClone);
            }
        } else {
            for (Item item : this.getExtraResults()) {
                if (item.isNull()) continue;
                arrayList2.add(item.clone());
            }
        }
        arrayList2.sort(CraftingManager.recipeComparator);
        return Recipe.matchItemList(arrayList, arrayList2);
    }

    @Override
    public boolean matchItems(List<Item> inputList, List<Item> extraOutputList) {
        return this.matchItems(inputList, extraOutputList, 1);
    }

    @Override
    public List<Item> getIngredientsAggregate() {
        return this.ingredientsAggregate;
    }
}

