/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.event.inventory.GrindstoneEvent;
import cn.nukkit.inventory.GrindstoneInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.GrindstoneItemAction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.item.Item;
import java.util.List;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class GrindstoneTransaction
extends InventoryTransaction {
    private Item firstItem;
    private Item secondItem;
    private Item outputItem;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public GrindstoneTransaction(Player source, List<InventoryAction> actions) {
        super(source, actions);
    }

    @Override
    public void addAction(InventoryAction action) {
        super.addAction(action);
        if (action instanceof GrindstoneItemAction) {
            switch (((GrindstoneItemAction)action).getType()) {
                case -10: {
                    this.firstItem = action.getTargetItem();
                    break;
                }
                case -12: {
                    this.outputItem = action.getSourceItem();
                    break;
                }
                case -11: {
                    this.secondItem = action.getTargetItem();
                }
            }
        }
    }

    @Override
    public boolean canExecute() {
        Inventory inventory = this.getSource().getWindowById(Player.GRINDSTONE_WINDOW_ID);
        if (inventory == null) {
            return false;
        }
        GrindstoneInventory grindstoneInventory = (GrindstoneInventory)inventory;
        if (this.outputItem == null || this.outputItem.isNull() || (this.firstItem == null || this.firstItem.isNull()) && (this.secondItem == null || this.secondItem.isNull())) {
            return false;
        }
        Item air = Item.get(0);
        Item first = this.firstItem != null ? this.firstItem : air;
        Item second = this.secondItem != null ? this.secondItem : air;
        return first.equals(grindstoneInventory.getFirstItem(), true, true) && second.equals(grindstoneInventory.getSecondItem(), true, true) && this.outputItem.equals(grindstoneInventory.getResult(), true, true);
    }

    @Override
    public boolean execute() {
        if (this.hasExecuted() || !this.canExecute()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return false;
        }
        GrindstoneInventory inventory = (GrindstoneInventory)this.getSource().getWindowById(Player.GRINDSTONE_WINDOW_ID);
        int exp = inventory.getResultExperience();
        Item air = Item.get(0);
        Item first = this.firstItem != null ? this.firstItem : air;
        Item second = this.secondItem != null ? this.secondItem : air;
        GrindstoneEvent event = new GrindstoneEvent(inventory, first, this.outputItem, second, exp, this.source);
        this.source.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            this.source.removeAllWindows(false);
            this.sendInventories();
            return true;
        }
        for (InventoryAction action : this.actions) {
            if (action.execute(this.source)) {
                action.onExecuteSuccess(this.source);
                continue;
            }
            action.onExecuteFail(this.source);
        }
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getFirstItem() {
        return this.firstItem == null ? null : this.firstItem.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getSecondItem() {
        return this.secondItem == null ? null : this.secondItem.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getOutputItem() {
        return this.outputItem == null ? null : this.outputItem.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static boolean checkForItemPart(List<InventoryAction> actions) {
        return actions.stream().anyMatch(it -> it instanceof GrindstoneItemAction);
    }
}

