/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.item.RuntimeItemMapping;
import cn.nukkit.utils.BinaryStream;
import com.google.common.base.Verify;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Since(value="1.4.0.0-PN")
public final class RuntimeItems {
    private static final Logger log = LogManager.getLogger(RuntimeItems.class);
    private static final Gson GSON = new Gson();
    private static final Type ENTRY_TYPE = new TypeToken<ArrayList<Entry>>(){}.getType();
    private static final RuntimeItemMapping itemPalette;

    @Since(value="1.4.0.0-PN")
    public static RuntimeItemMapping getRuntimeMapping() {
        return itemPalette;
    }

    @Since(value="1.4.0.0-PN")
    public static int getId(int fullId) {
        return (short)(fullId >> 16);
    }

    @Since(value="1.4.0.0-PN")
    public static int getData(int fullId) {
        return fullId >> 1 & Short.MAX_VALUE;
    }

    @Since(value="1.4.0.0-PN")
    public static int getFullId(int id, int data) {
        return (short)id << 16 | (data & Short.MAX_VALUE) << 1;
    }

    @Since(value="1.4.0.0-PN")
    public static int getNetworkId(int networkFullId) {
        return networkFullId >> 1;
    }

    @Since(value="1.4.0.0-PN")
    public static boolean hasData(int id) {
        return (id & 1) != 0;
    }

    private RuntimeItems() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        log.debug("Loading runtime items...");
        InputStream stream = Server.class.getClassLoader().getResourceAsStream("runtime_item_ids.json");
        if (stream == null) {
            throw new AssertionError((Object)"Unable to load runtime_item_ids.json");
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        Collection entries = (Collection)GSON.fromJson((Reader)reader, ENTRY_TYPE);
        BinaryStream paletteBuffer = new BinaryStream();
        paletteBuffer.putUnsignedVarInt(entries.size());
        Int2IntOpenHashMap legacyNetworkMap = new Int2IntOpenHashMap();
        Int2IntOpenHashMap networkLegacyMap = new Int2IntOpenHashMap();
        LinkedHashMap<String, Integer> namespaceNetworkMap = new LinkedHashMap<String, Integer>();
        Int2ObjectOpenHashMap networkNamespaceMap = new Int2ObjectOpenHashMap();
        for (Entry entry : entries) {
            paletteBuffer.putString(entry.name);
            paletteBuffer.putLShort(entry.id);
            paletteBuffer.putBoolean(false);
            namespaceNetworkMap.put(entry.name, entry.id);
            networkNamespaceMap.put(entry.id, (Object)entry.name);
            if (entry.oldId == null) continue;
            boolean hasData = entry.oldData != null;
            int fullId = RuntimeItems.getFullId(entry.oldId, hasData ? entry.oldData : 0);
            if (entry.deprecated != Boolean.TRUE) {
                Verify.verify((legacyNetworkMap.put(fullId, entry.id << 1 | (hasData ? 1 : 0)) == 0 ? 1 : 0) != 0, (String)"Conflict while registering an item runtime id!", (Object[])new Object[0]);
            }
            Verify.verify((networkLegacyMap.put(entry.id, fullId | (hasData ? 1 : 0)) == 0 ? 1 : 0) != 0, (String)"Conflict while registering an item runtime id!", (Object[])new Object[0]);
        }
        byte[] itemDataPalette = paletteBuffer.getBuffer();
        itemPalette = new RuntimeItemMapping(itemDataPalette, (Int2IntMap)legacyNetworkMap, (Int2IntMap)networkLegacyMap, namespaceNetworkMap, (Int2ObjectMap<String>)networkNamespaceMap);
    }

    static class Entry {
        String name;
        int id;
        Integer oldId;
        Integer oldData;
        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        Boolean deprecated;

        public String toString() {
            return "RuntimeItems.Entry(name=" + this.name + ", id=" + this.id + ", oldId=" + this.oldId + ", oldData=" + this.oldData + ", deprecated=" + this.deprecated + ")";
        }
    }
}

