/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.level.GameRule;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BinaryStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public class GameRules {
    private final EnumMap<GameRule, Value> gameRules = new EnumMap(GameRule.class);
    private boolean stale;

    private GameRules() {
    }

    public static GameRules getDefault() {
        GameRules gameRules = new GameRules();
        gameRules.gameRules.put(GameRule.COMMAND_BLOCK_OUTPUT, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.DO_DAYLIGHT_CYCLE, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.DO_ENTITY_DROPS, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.DO_FIRE_TICK, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.DO_IMMEDIATE_RESPAWN, new Value<Boolean>(Type.BOOLEAN, false));
        gameRules.gameRules.put(GameRule.DO_MOB_LOOT, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.DO_MOB_SPAWNING, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.DO_TILE_DROPS, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.DO_WEATHER_CYCLE, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.DROWNING_DAMAGE, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.FALL_DAMAGE, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.FIRE_DAMAGE, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.KEEP_INVENTORY, new Value<Boolean>(Type.BOOLEAN, false));
        gameRules.gameRules.put(GameRule.MOB_GRIEFING, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.NATURAL_REGENERATION, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.PVP, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.RANDOM_TICK_SPEED, new Value<Integer>(Type.INTEGER, 3));
        gameRules.gameRules.put(GameRule.SEND_COMMAND_FEEDBACK, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.SHOW_COORDINATES, new Value<Boolean>(Type.BOOLEAN, false));
        gameRules.gameRules.put(GameRule.TNT_EXPLODES, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.SHOW_DEATH_MESSAGE, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.EXPERIMENTAL_GAMEPLAY, new Value<Boolean>(Type.BOOLEAN, false));
        gameRules.gameRules.put(GameRule.MAX_COMMAND_CHAIN_LENGTH, new Value<Integer>(Type.INTEGER, 131070));
        gameRules.gameRules.put(GameRule.DO_INSOMNIA, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.COMMAND_BLOCKS_ENABLED, new Value<Boolean>(Type.BOOLEAN, true));
        gameRules.gameRules.put(GameRule.FUNCTION_COMMAND_LIMIT, new Value<Integer>(Type.INTEGER, 20000));
        gameRules.gameRules.put(GameRule.SPAWN_RADIUS, new Value<Integer>(Type.INTEGER, 5));
        gameRules.gameRules.put(GameRule.SHOW_TAGS, new Value<Boolean>(Type.BOOLEAN, true));
        return gameRules;
    }

    public Map<GameRule, Value> getGameRules() {
        return ImmutableMap.copyOf(this.gameRules);
    }

    public boolean isStale() {
        return this.stale;
    }

    public void refresh() {
        this.stale = false;
    }

    public void setGameRule(GameRule gameRule, boolean value) {
        if (!this.gameRules.containsKey((Object)gameRule)) {
            throw new IllegalArgumentException("Gamerule does not exist");
        }
        this.gameRules.get((Object)gameRule).setValue(value, Type.BOOLEAN);
        this.stale = true;
    }

    public void setGameRule(GameRule gameRule, int value) {
        if (!this.gameRules.containsKey((Object)gameRule)) {
            throw new IllegalArgumentException("Gamerule does not exist");
        }
        this.gameRules.get((Object)gameRule).setValue(value, Type.INTEGER);
        this.stale = true;
    }

    public void setGameRule(GameRule gameRule, float value) {
        if (!this.gameRules.containsKey((Object)gameRule)) {
            throw new IllegalArgumentException("Gamerule does not exist");
        }
        this.gameRules.get((Object)gameRule).setValue(Float.valueOf(value), Type.FLOAT);
        this.stale = true;
    }

    public void setGameRules(GameRule gameRule, String value) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)((Object)gameRule), (Object)"gameRule");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        switch (this.getGameRuleType(gameRule)) {
            case BOOLEAN: {
                if (value.equalsIgnoreCase("true")) {
                    this.setGameRule(gameRule, true);
                    break;
                }
                if (value.equalsIgnoreCase("false")) {
                    this.setGameRule(gameRule, false);
                    break;
                }
                throw new IllegalArgumentException("Was not a boolean");
            }
            case INTEGER: {
                this.setGameRule(gameRule, Integer.parseInt(value));
                break;
            }
            case FLOAT: {
                this.setGameRule(gameRule, Float.parseFloat(value));
            }
        }
    }

    public boolean getBoolean(GameRule gameRule) {
        return this.gameRules.get((Object)gameRule).getValueAsBoolean();
    }

    public int getInteger(GameRule gameRule) {
        Preconditions.checkNotNull((Object)((Object)gameRule), (Object)"gameRule");
        return this.gameRules.get((Object)gameRule).getValueAsInteger();
    }

    public float getFloat(GameRule gameRule) {
        Preconditions.checkNotNull((Object)((Object)gameRule), (Object)"gameRule");
        return this.gameRules.get((Object)gameRule).getValueAsFloat();
    }

    public String getString(GameRule gameRule) {
        Preconditions.checkNotNull((Object)((Object)gameRule), (Object)"gameRule");
        return this.gameRules.get((Object)gameRule).value.toString();
    }

    public Type getGameRuleType(GameRule gameRule) {
        Preconditions.checkNotNull((Object)((Object)gameRule), (Object)"gameRule");
        return this.gameRules.get((Object)gameRule).getType();
    }

    public boolean hasRule(GameRule gameRule) {
        return this.gameRules.containsKey((Object)gameRule);
    }

    public GameRule[] getRules() {
        return this.gameRules.keySet().toArray(GameRule.EMPTY_ARRAY);
    }

    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<GameRule, Value> entry : this.gameRules.entrySet()) {
            nbt.putString(entry.getKey().getName(), entry.getValue().value.toString());
        }
        return nbt;
    }

    public void readNBT(CompoundTag nbt) {
        Preconditions.checkNotNull((Object)nbt);
        for (String key : nbt.getTags().keySet()) {
            Optional<GameRule> gameRule = GameRule.parseString(key);
            if (!gameRule.isPresent()) continue;
            this.setGameRules(gameRule.get(), nbt.getString(key));
        }
    }

    public static class Value<T> {
        private final Type type;
        private T value;

        public Value(Type type, T value) {
            this.type = type;
            this.value = value;
        }

        private void setValue(T value, Type type) {
            if (this.type != type) {
                throw new UnsupportedOperationException("Rule not of type " + type.name().toLowerCase());
            }
            this.value = value;
        }

        public Type getType() {
            return this.type;
        }

        private boolean getValueAsBoolean() {
            if (this.type != Type.BOOLEAN) {
                throw new UnsupportedOperationException("Rule not of type boolean");
            }
            return (Boolean)this.value;
        }

        private int getValueAsInteger() {
            if (this.type != Type.INTEGER) {
                throw new UnsupportedOperationException("Rule not of type integer");
            }
            return (Integer)this.value;
        }

        private float getValueAsFloat() {
            if (this.type != Type.FLOAT) {
                throw new UnsupportedOperationException("Rule not of type float");
            }
            return ((Float)this.value).floatValue();
        }

        public void write(BinaryStream pk) {
            pk.putUnsignedVarInt(this.type.ordinal());
            this.type.write(pk, this);
        }
    }

    public static enum Type {
        UNKNOWN{

            @Override
            void write(BinaryStream pk, Value value) {
            }
        }
        ,
        BOOLEAN{

            @Override
            void write(BinaryStream pk, Value value) {
                pk.putBoolean(value.getValueAsBoolean());
            }
        }
        ,
        INTEGER{

            @Override
            void write(BinaryStream pk, Value value) {
                pk.putUnsignedVarInt(value.getValueAsInteger());
            }
        }
        ,
        FLOAT{

            @Override
            void write(BinaryStream pk, Value value) {
                pk.putLFloat(value.getValueAsFloat());
            }
        };


        abstract void write(BinaryStream var1, Value var2);
    }
}

