/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.impl.mesa;

import cn.nukkit.api.NewRakNetOnly;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.biome.type.CoveredBiome;
import cn.nukkit.level.generator.noise.nukkit.f.SimplexF;
import cn.nukkit.level.generator.populator.impl.PopulatorCactus;
import cn.nukkit.level.generator.populator.impl.PopulatorDeadBush;
import cn.nukkit.math.NukkitRandom;
import java.util.Arrays;
import java.util.Random;

public class MesaBiome
extends CoveredBiome {
    private static final BlockState STATE_TERRACOTTA = BlockState.of(172);
    private static final BlockState STATE_RED_SAND = BlockState.of(12, 1);
    private static final BlockState STATE_RED_SANDSTONE = BlockState.of(179);
    private static final BlockState[] STATE_STAINED_TERRACOTTA = new BlockState[16];
    static final int[] colorLayer = new int[64];
    static final SimplexF redSandNoise = new SimplexF(new NukkitRandom(937478913L), 2.0f, 0.25f, 0.25f);
    static final SimplexF colorNoise = new SimplexF(new NukkitRandom(193759875L), 2.0f, 0.25f, 0.03125f);
    private SimplexF moundNoise = new SimplexF(new NukkitRandom(347228794L), 2.0f, 0.25f, this.getMoundFrequency());
    protected int moundHeight;

    private static void setRandomLayerColor(Random random, int sliceCount, int color) {
        for (int i = 0; i < random.nextInt(4) + sliceCount; ++i) {
            int j = random.nextInt(colorLayer.length);
            for (int k = 0; k < random.nextInt(2) + 1 && j < colorLayer.length; ++k) {
                MesaBiome.colorLayer[j++] = color;
            }
        }
    }

    public MesaBiome() {
        PopulatorCactus cactus = new PopulatorCactus();
        cactus.setBaseAmount(1);
        cactus.setRandomAmount(1);
        this.addPopulator(cactus);
        PopulatorDeadBush deadBush = new PopulatorDeadBush();
        deadBush.setBaseAmount(3);
        deadBush.setRandomAmount(2);
        this.addPopulator(deadBush);
        this.setMoundHeight(17);
    }

    public void setMoundHeight(int height) {
        this.moundHeight = height;
    }

    @Override
    @NewRakNetOnly
    public int getSurfaceDepth(int x, int y, int z) {
        return y < 71 + Math.round((redSandNoise.noise2D(x, z, true) + 1.0f) * 1.5f) ? 3 : y - 66;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockState getSurfaceState(int x, int y, int z) {
        if (y < 71 + Math.round((redSandNoise.noise2D(x, z, true) + 1.0f) * 1.5f)) {
            return STATE_RED_SAND;
        }
        int meta = colorLayer[y + Math.round((colorNoise.noise2D(x, z, true) + 1.0f) * 1.5f) & 0x3F];
        return meta == -1 ? STATE_TERRACOTTA : STATE_STAINED_TERRACOTTA[Math.max(0, meta)];
    }

    @Override
    @NewRakNetOnly
    public int getGroundDepth(int x, int y, int z) {
        return y < 71 + Math.round((redSandNoise.noise2D(x, z, true) + 1.0f) * 1.5f) ? 2 : 0;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockState getGroundState(int x, int y, int z) {
        return STATE_RED_SANDSTONE;
    }

    @Override
    public String getName() {
        return "Mesa";
    }

    protected float getMoundFrequency() {
        return 0.0078125f;
    }

    @Override
    public int getHeightOffset(int x, int z) {
        float a;
        float n = this.moundNoise.noise2D(x, z, true);
        return n > (a = this.minHill()) && n < a + 0.2f ? (int)((n - a) * 5.0f * (float)this.moundHeight) : (n < a + 0.1f ? 0 : this.moundHeight);
    }

    protected float minHill() {
        return -0.1f;
    }

    @Override
    public boolean canRain() {
        return false;
    }

    static {
        for (int i = 0; i < STATE_STAINED_TERRACOTTA.length; ++i) {
            MesaBiome.STATE_STAINED_TERRACOTTA[i] = BlockState.of(159, i);
        }
        Random random = new Random(29864L);
        Arrays.fill(colorLayer, -1);
        MesaBiome.setRandomLayerColor(random, 14, 1);
        MesaBiome.setRandomLayerColor(random, 8, 4);
        MesaBiome.setRandomLayerColor(random, 7, 12);
        MesaBiome.setRandomLayerColor(random, 10, 14);
        int j = 0;
        for (int i = 0; i < random.nextInt(3) + 3 && (j += random.nextInt(6) + 4) < colorLayer.length - 3; ++i) {
            if (random.nextInt(2) == 0 || j < colorLayer.length - 1 && random.nextInt(2) == 0) {
                MesaBiome.colorLayer[j - 1] = 8;
                continue;
            }
            MesaBiome.colorLayer[j] = 0;
        }
    }
}

