/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.format.anvil.LayerStorage;
import cn.nukkit.level.format.anvil.SingleLayerStorage;
import cn.nukkit.level.format.anvil.util.BlockStorage;
import cn.nukkit.level.format.anvil.util.ImmutableBlockStorage;
import cn.nukkit.utils.BinaryStream;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public final class MultiLayerStorage
extends LayerStorage {
    private BlockStorage[] storages;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public MultiLayerStorage() {
        this.storages = BlockStorage.EMPTY_ARRAY;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public MultiLayerStorage(BlockStorage ... storages) {
        this.storages = storages;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void compress(Consumer<LayerStorage> setLayerStorage) {
        int newSize = this.storages.length;
        for (int i = this.storages.length - 1; i >= 0; --i) {
            BlockStorage storage = this.storages[i];
            if (storage == null || storage == ImmutableBlockStorage.EMPTY) {
                --newSize;
                continue;
            }
            if (storage.hasBlockIds()) {
                storage.recheckBlocks();
                if (storage.hasBlockIds()) break;
                --newSize;
                continue;
            }
            --newSize;
        }
        if (newSize == 0) {
            setLayerStorage.accept(EMPTY);
        } else if (newSize == 1) {
            setLayerStorage.accept(new SingleLayerStorage(this.storages[0]));
        } else if (newSize != this.storages.length) {
            this.storages = Arrays.copyOf(this.storages, newSize);
        }
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int size() {
        return this.storages.length;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void writeTo(BinaryStream stream) {
        stream.putByte((byte)8);
        stream.putByte((byte)this.storages.length);
        for (BlockStorage blockStorage : this.storages) {
            blockStorage.writeTo(stream);
        }
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void delayPaletteUpdates() {
        for (BlockStorage storage : this.storages) {
            storage.delayPaletteUpdates();
        }
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockStorage getOrSetStorage(@Nullable Consumer<LayerStorage> setLayerStorage, IntSupplier contentVersion, int layer) {
        int oldLen = this.storages.length;
        if (layer >= oldLen) {
            BlockStorage storage;
            if (layer > 1) {
                throw new IndexOutOfBoundsException("Only layer 0 and 1 are supported. Attempted: " + layer);
            }
            this.storages = Arrays.copyOf(this.storages, layer + 1);
            Arrays.fill(this.storages, oldLen, layer, ImmutableBlockStorage.EMPTY);
            this.storages[layer] = storage = this.createBlockStorage(contentVersion.getAsInt());
            return storage;
        }
        if (layer < 0) {
            throw new IndexOutOfBoundsException("Only layer 0 and 1 are supported. Attempted: " + layer);
        }
        BlockStorage storage = this.storages[layer];
        if (storage != ImmutableBlockStorage.EMPTY) {
            return storage;
        }
        this.storages[layer] = storage = this.createBlockStorage(contentVersion.getAsInt());
        return storage;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockStorage getStorageOrEmpty(int layer) {
        return layer < this.storages.length ? this.storages[layer] : ImmutableBlockStorage.EMPTY;
    }

    @Override
    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockStorage getStorageOrNull(int layer) {
        if (layer >= this.storages.length) {
            return null;
        }
        BlockStorage storage = this.storages[layer];
        return storage == ImmutableBlockStorage.EMPTY ? null : storage;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean hasBlocks() {
        for (BlockStorage storage : this.storages) {
            if (!storage.hasBlockIds()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public MultiLayerStorage clone() {
        MultiLayerStorage clone = (MultiLayerStorage)super.clone();
        clone.storages = (BlockStorage[])clone.storages.clone();
        for (int i = 0; i < clone.storages.length; ++i) {
            clone.storages[i] = clone.storages[i].copy();
        }
        return clone;
    }
}

