/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.biome.type.CoveredBiome;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.NukkitRandom;
import java.util.Random;

public class PopulatorCaves
extends Populator {
    protected int checkAreaSize = 8;
    private Random random;
    public static int caveRarity = 7;
    public static int caveFrequency = 40;
    public static int caveMinAltitude = 8;
    public static int caveMaxAltitude = 67;
    public static int individualCaveRarity = 25;
    public static int caveSystemFrequency = 1;
    public static int caveSystemPocketChance = 0;
    public static int caveSystemPocketMinSize = 0;
    public static int caveSystemPocketMaxSize = 4;
    public static boolean evenCaveDistribution = false;
    public int worldHeightCap = 128;

    @Override
    public void populate(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        this.random = new Random();
        this.random.setSeed(level.getSeed());
        long worldLong1 = this.random.nextLong();
        long worldLong2 = this.random.nextLong();
        int size = this.checkAreaSize;
        for (int x = chunkX - size; x <= chunkX + size; ++x) {
            for (int z = chunkZ - size; z <= chunkZ + size; ++z) {
                long randomX = (long)x * worldLong1;
                long randomZ = (long)z * worldLong2;
                this.random.setSeed(randomX ^ randomZ ^ level.getSeed());
                this.generateChunk(x, z, chunk);
            }
        }
    }

    protected void generateLargeCaveNode(long seed, FullChunk chunk, double x, double y, double z) {
        this.generateCaveNode(seed, chunk, x, y, z, 1.0f + this.random.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCaveNode(long seed, FullChunk chunk, double x, double y, double z, float radius, float angelOffset, float angel, int angle, int maxAngle, double scale) {
        boolean bigAngel;
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        double realX = chunkX * 16 + 8;
        double realZ = chunkZ * 16 + 8;
        float f1 = 0.0f;
        float f2 = 0.0f;
        Random localRandom = new Random(seed);
        if (maxAngle <= 0) {
            int checkAreaSize = this.checkAreaSize * 16 - 16;
            maxAngle = checkAreaSize - localRandom.nextInt(checkAreaSize / 4);
        }
        boolean isLargeCave = false;
        if (angle == -1) {
            angle = maxAngle / 2;
            isLargeCave = true;
        }
        int randomAngel = localRandom.nextInt(maxAngle / 2) + maxAngle / 4;
        boolean bl = bigAngel = localRandom.nextInt(6) == 0;
        while (angle < maxAngle) {
            double offsetXZ = 1.5 + (double)(MathHelper.sin((float)angle * 3.141593f / (float)maxAngle) * radius * 1.0f);
            double offsetY = offsetXZ * scale;
            float cos = MathHelper.cos(angel);
            float sin = MathHelper.sin(angel);
            x += (double)(MathHelper.cos(angelOffset) * cos);
            y += (double)sin;
            z += (double)(MathHelper.sin(angelOffset) * cos);
            angel = bigAngel ? (angel *= 0.92f) : (angel *= 0.7f);
            angel += f2 * 0.1f;
            angelOffset += f1 * 0.1f;
            f2 *= 0.9f;
            f1 *= 0.75f;
            f2 += (localRandom.nextFloat() - localRandom.nextFloat()) * localRandom.nextFloat() * 2.0f;
            f1 += (localRandom.nextFloat() - localRandom.nextFloat()) * localRandom.nextFloat() * 4.0f;
            if (!isLargeCave && angle == randomAngel && radius > 1.0f && maxAngle > 0) {
                this.generateCaveNode(localRandom.nextLong(), chunk, x, y, z, localRandom.nextFloat() * 0.5f + 0.5f, angelOffset - 1.570796f, angel / 3.0f, angle, maxAngle, 1.0);
                this.generateCaveNode(localRandom.nextLong(), chunk, x, y, z, localRandom.nextFloat() * 0.5f + 0.5f, angelOffset + 1.570796f, angel / 3.0f, angle, maxAngle, 1.0);
                return;
            }
            if (isLargeCave || localRandom.nextInt(4) != 0) {
                double distanceX = x - realX;
                double distanceZ = z - realZ;
                double angelDiff = maxAngle - angle;
                double newRadius = radius + 2.0f + 16.0f;
                if (distanceX * distanceX + distanceZ * distanceZ - angelDiff * angelDiff > newRadius * newRadius) {
                    return;
                }
                if (!(x < realX - 16.0 - offsetXZ * 2.0 || z < realZ - 16.0 - offsetXZ * 2.0 || x > realX + 16.0 + offsetXZ * 2.0 || z > realZ + 16.0 + offsetXZ * 2.0)) {
                    int xx;
                    int xFrom = MathHelper.floor(x - offsetXZ) - chunkX * 16 - 1;
                    int xTo = MathHelper.floor(x + offsetXZ) - chunkX * 16 + 1;
                    int yFrom = MathHelper.floor(y - offsetY) - 1;
                    int yTo = MathHelper.floor(y + offsetY) + 1;
                    int zFrom = MathHelper.floor(z - offsetXZ) - chunkZ * 16 - 1;
                    int zTo = MathHelper.floor(z + offsetXZ) - chunkZ * 16 + 1;
                    if (xFrom < 0) {
                        xFrom = 0;
                    }
                    if (xTo > 16) {
                        xTo = 16;
                    }
                    if (yFrom < 1) {
                        yFrom = 1;
                    }
                    if (yTo > this.worldHeightCap - 8) {
                        yTo = this.worldHeightCap - 8;
                    }
                    if (zFrom < 0) {
                        zFrom = 0;
                    }
                    if (zTo > 16) {
                        zTo = 16;
                    }
                    boolean waterFound = false;
                    for (xx = xFrom; !waterFound && xx < xTo; ++xx) {
                        for (int zz = zFrom; !waterFound && zz < zTo; ++zz) {
                            for (int yy = yTo + 1; !waterFound && yy >= yFrom - 1; --yy) {
                                if (yy < 0 || yy >= this.worldHeightCap) continue;
                                int block = chunk.getBlockId(xx, yy, zz);
                                if (block == 8 || block == 9) {
                                    waterFound = true;
                                }
                                if (yy == yFrom - 1 || xx == xFrom || xx == xTo - 1 || zz == zFrom || zz == zTo - 1) continue;
                                yy = yFrom;
                            }
                        }
                    }
                    if (!waterFound) {
                        for (xx = xFrom; xx < xTo; ++xx) {
                            double modX = ((double)(xx + chunkX * 16) + 0.5 - x) / offsetXZ;
                            for (int zz = zFrom; zz < zTo; ++zz) {
                                double modZ = ((double)(zz + chunkZ * 16) + 0.5 - z) / offsetXZ;
                                boolean grassFound = false;
                                if (!(modX * modX + modZ * modZ < 1.0)) continue;
                                for (int yy = yTo; yy > yFrom; --yy) {
                                    Biome biome;
                                    double modY = ((double)(yy - 1) + 0.5 - y) / offsetY;
                                    if (!(modY > -0.7) || !(modX * modX + modY * modY + modZ * modZ < 1.0) || !((biome = EnumBiome.getBiome(chunk.getBiomeId(xx, zz))) instanceof CoveredBiome)) continue;
                                    int material = chunk.getBlockId(xx, yy, zz);
                                    int materialAbove = chunk.getBlockId(xx, yy + 1, zz);
                                    if (material == 2 || material == 110) {
                                        grassFound = true;
                                    }
                                    if (yy - 1 < 10) {
                                        chunk.setBlock(xx, yy, zz, 10);
                                        continue;
                                    }
                                    chunk.setBlock(xx, yy, zz, 0);
                                    if (!grassFound || chunk.getBlockId(xx, yy - 1, zz) != 3) continue;
                                    chunk.setFullBlockId(xx, yy - 1, zz, ((CoveredBiome)biome).getSurfaceId(xx, yy - 1, zz));
                                }
                            }
                        }
                        if (isLargeCave) break;
                    }
                }
            }
            ++angle;
        }
    }

    protected void generateChunk(int chunkX, int chunkZ, FullChunk generatingChunkBuffer) {
        int i = this.random.nextInt(this.random.nextInt(this.random.nextInt(caveFrequency) + 1) + 1);
        if (evenCaveDistribution) {
            i = caveFrequency;
        }
        if (this.random.nextInt(100) >= caveRarity) {
            i = 0;
        }
        for (int j = 0; j < i; ++j) {
            double x = chunkX * 16 + this.random.nextInt(16);
            double y = evenCaveDistribution ? (double)PopulatorCaves.numberInRange(this.random, caveMinAltitude, caveMaxAltitude) : (double)(this.random.nextInt(this.random.nextInt(caveMaxAltitude - caveMinAltitude + 1) + 1) + caveMinAltitude);
            double z = chunkZ * 16 + this.random.nextInt(16);
            int count = caveSystemFrequency;
            boolean largeCaveSpawned = false;
            if (this.random.nextInt(100) <= individualCaveRarity) {
                this.generateLargeCaveNode(this.random.nextLong(), generatingChunkBuffer, x, y, z);
                largeCaveSpawned = true;
            }
            if (largeCaveSpawned || this.random.nextInt(100) <= caveSystemPocketChance - 1) {
                count += PopulatorCaves.numberInRange(this.random, caveSystemPocketMinSize, caveSystemPocketMaxSize);
            }
            while (count > 0) {
                --count;
                float f1 = this.random.nextFloat() * 3.141593f * 2.0f;
                float f2 = (this.random.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f3 = this.random.nextFloat() * 2.0f + this.random.nextFloat();
                this.generateCaveNode(this.random.nextLong(), generatingChunkBuffer, x, y, z, f3, f1, f2, 0, 0, 1.0);
            }
        }
    }

    public static int numberInRange(Random random, int min, int max) {
        return min + random.nextInt(max - min + 1);
    }
}

