/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.util;

import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.util.BitArray;
import cn.nukkit.level.util.BitArrayVersion;
import cn.nukkit.utils.BinaryStream;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

public class PalettedBlockStorage {
    private static final int SIZE = 4096;
    private final IntList palette;
    private BitArray bitArray;

    public PalettedBlockStorage() {
        this(BitArrayVersion.V2);
    }

    public PalettedBlockStorage(BitArrayVersion version) {
        this.bitArray = version.createPalette(4096);
        this.palette = new IntArrayList(16);
        this.palette.add(GlobalBlockPalette.getOrCreateRuntimeId(0));
    }

    private PalettedBlockStorage(BitArray bitArray, IntList palette) {
        this.palette = palette;
        this.bitArray = bitArray;
    }

    private int getPaletteHeader(BitArrayVersion version, boolean runtime) {
        return version.getId() << 1 | (runtime ? 1 : 0);
    }

    public void setBlock(int index, int runtimeId) {
        try {
            int id = this.idFor(runtimeId);
            this.bitArray.set(index, id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to set block runtime ID: " + runtimeId + ", palette: " + this.palette, e);
        }
    }

    public void writeTo(BinaryStream stream) {
        stream.putByte((byte)this.getPaletteHeader(this.bitArray.getVersion(), true));
        for (int word : this.bitArray.getWords()) {
            stream.putLInt(word);
        }
        stream.putVarInt(this.palette.size());
        this.palette.forEach(stream::putVarInt);
    }

    private void onResize(BitArrayVersion version) {
        BitArray newBitArray = version.createPalette(4096);
        for (int i = 0; i < 4096; ++i) {
            newBitArray.set(i, this.bitArray.get(i));
        }
        this.bitArray = newBitArray;
    }

    private int idFor(int runtimeId) {
        BitArrayVersion next;
        BitArrayVersion version;
        int index = this.palette.indexOf(runtimeId);
        if (index != -1) {
            return index;
        }
        index = this.palette.size();
        if (index > (version = this.bitArray.getVersion()).getMaxEntryValue() && (next = version.next()) != null) {
            this.onResize(next);
        }
        this.palette.add(runtimeId);
        return index;
    }

    public boolean isEmpty() {
        if (this.palette.size() == 1) {
            return true;
        }
        for (int word : this.bitArray.getWords()) {
            if (Integer.toUnsignedLong(word) == 0L) continue;
            return false;
        }
        return true;
    }

    public PalettedBlockStorage copy() {
        return new PalettedBlockStorage(this.bitArray.copy(), (IntList)new IntArrayList(this.palette));
    }
}

