/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;

@Since(value="1.3.0.0-PN")
public class EmoteListPacket
extends DataPacket {
    public static final byte NETWORK_ID = -104;
    @Since(value="1.3.0.0-PN")
    public long runtimeId;
    @Since(value="1.3.0.0-PN")
    public final List<UUID> pieceIds = new ObjectArrayList();

    @Override
    public byte pid() {
        return -104;
    }

    @Override
    public void decode() {
        this.runtimeId = this.getEntityRuntimeId();
        int size = (int)this.getUnsignedVarInt();
        for (int i = 0; i < size; ++i) {
            UUID id = this.getUUID();
            this.pieceIds.add(id);
        }
    }

    @Override
    public void encode() {
        this.reset();
        this.putEntityRuntimeId(this.runtimeId);
        this.putUnsignedVarInt(this.pieceIds.size());
        for (UUID id : this.pieceIds) {
            this.putUUID(id);
        }
    }

    public String toString() {
        return "EmoteListPacket(runtimeId=" + this.runtimeId + ", pieceIds=" + this.pieceIds + ")";
    }
}

