/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.Since;
import cn.nukkit.entity.Attribute;
import cn.nukkit.network.protocol.DataPacket;
import java.util.Arrays;

public class UpdateAttributesPacket
extends DataPacket {
    public static final byte NETWORK_ID = 29;
    public Attribute[] entries;
    public long entityId;
    @Since(value="1.4.0.0-PN")
    public long frame;

    @Override
    public byte pid() {
        return 29;
    }

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        this.putEntityRuntimeId(this.entityId);
        if (this.entries == null) {
            this.putUnsignedVarInt(0L);
        } else {
            this.putUnsignedVarInt(this.entries.length);
            for (Attribute entry : this.entries) {
                this.putLFloat(entry.getMinValue());
                this.putLFloat(entry.getMaxValue());
                this.putLFloat(entry.getValue());
                this.putLFloat(entry.getDefaultValue());
                this.putString(entry.getName());
            }
        }
        this.putUnsignedVarInt(this.frame);
    }

    public String toString() {
        return "UpdateAttributesPacket(entries=" + Arrays.deepToString(this.entries) + ", entityId=" + this.entityId + ", frame=" + this.frame + ")";
    }
}

