/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockLever;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.blockentity.BlockEntityBed;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockExplosionPrimeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBed;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Explosion;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.TextFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockBed
extends BlockTransparentMeta
implements Faceable,
BlockEntityHolder<BlockEntityBed> {
    private static final Logger log = LogManager.getLogger(BlockBed.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty HEAD_PIECE = new BooleanBlockProperty("head_piece_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty OCCUPIED = new BooleanBlockProperty("occupied_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, OCCUPIED, HEAD_PIECE);

    public BlockBed() {
        this(0);
    }

    public BlockBed(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 26;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityBed> getBlockEntityClass() {
        return BlockEntityBed.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Bed";
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getResistance() {
        return 1.0;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public String getName() {
        return this.getDyeColor().getName() + " Bed Block";
    }

    @Override
    public double getMaxY() {
        return this.y + 0.5625;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean onActivate(@Nonnull Item item) {
        return this.onActivate(item, null);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        boolean isNight;
        Block head;
        boolean willExplode;
        BlockFace dir = this.getBlockFace();
        boolean shouldExplode = this.level.getDimension() != 0;
        boolean bl = willExplode = shouldExplode && this.level.getGameRules().getBoolean(GameRule.TNT_EXPLODES);
        if (this.isHeadPiece()) {
            head = this;
        } else {
            head = this.getSide(dir);
            if (head.getId() != this.getId() || !((BlockBed)head).isHeadPiece() || !((BlockBed)head).getBlockFace().equals((Object)dir)) {
                if (player != null && !willExplode) {
                    player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.notValid"));
                }
                if (!shouldExplode) {
                    return true;
                }
            }
        }
        BlockFace footPart = dir.getOpposite();
        if (shouldExplode) {
            if (!willExplode) {
                return true;
            }
            BlockExplosionPrimeEvent event = new BlockExplosionPrimeEvent(this, 5.0);
            event.setIncendiary(true);
            if (event.isCancelled()) {
                return true;
            }
            this.level.setBlock((Vector3)this, BlockBed.get(0), false, false);
            this.onBreak(Item.getBlock(0));
            this.level.updateAround(this);
            Explosion explosion = new Explosion((Position)this, event.getForce(), this);
            explosion.setFireChance(event.getFireChance());
            if (event.isBlockBreaking()) {
                explosion.explodeA();
            }
            explosion.explodeB();
            return true;
        }
        if (player == null || !player.hasEffect(26) && this.getLevelBlockAtLayer(1) instanceof BlockWater) {
            return true;
        }
        AxisAlignedBB accessArea = new SimpleAxisAlignedBB(head.x - 2.0, head.y - 5.5, head.z - 2.0, head.x + 3.0, head.y + 2.5, head.z + 3.0).addCoord(footPart.getXOffset(), 0.0, footPart.getZOffset());
        if (!accessArea.isVectorInside(player)) {
            player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.tooFar"));
            return true;
        }
        Location spawn = Location.fromObject(head.add(0.5, 0.5, 0.5), player.getLevel(), player.getYaw(), player.getPitch());
        if (!player.getSpawn().equals(spawn)) {
            player.setSpawn(spawn);
        }
        player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.respawnSet"));
        int time = this.getLevel().getTime() % 24000;
        boolean bl2 = isNight = time >= 14000 && time < 23000;
        if (!isNight) {
            player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.noSleep"));
            return true;
        }
        if (!player.isCreative()) {
            AxisAlignedBB checkMonsterArea = new SimpleAxisAlignedBB(head.x - 8.0, head.y - 6.5, head.z - 8.0, head.x + 9.0, head.y + 5.5, head.z + 9.0).addCoord(footPart.getXOffset(), 0.0, footPart.getZOffset());
            for (Entity entity : this.level.getCollidingEntities(checkMonsterArea)) {
                if (entity.isClosed() || !entity.isPreventingSleep(player)) continue;
                player.sendTranslation((Object)((Object)TextFormat.GRAY) + "%tile.bed.notSafe");
                return true;
            }
        }
        if (!player.sleepOn(head)) {
            player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.occupied"));
        }
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        Block down = this.down();
        if (!BlockLever.isSupportValid(down, BlockFace.UP) && !(down instanceof BlockCauldron)) {
            return false;
        }
        BlockFace direction = player == null ? BlockFace.NORTH : player.getDirection();
        Block next = this.getSide(direction);
        Block downNext = next.down();
        if (!next.canBeReplaced() || !BlockLever.isSupportValid(downNext, BlockFace.UP) && !(downNext instanceof BlockCauldron)) {
            return false;
        }
        Block thisLayer0 = this.level.getBlock((Vector3)this, 0);
        Block thisLayer1 = this.level.getBlock((Vector3)this, 1);
        Block nextLayer0 = this.level.getBlock((Vector3)next, 0);
        Block nextLayer1 = this.level.getBlock((Vector3)next, 1);
        this.setBlockFace(direction);
        this.level.setBlock((Vector3)block, this, true, true);
        if (next instanceof BlockLiquid && ((BlockLiquid)next).usesWaterLogging()) {
            this.level.setBlock(next, 1, next, true, false);
        }
        BlockBed head = this.clone();
        head.setHeadPiece(true);
        this.level.setBlock((Vector3)next, head, true, true);
        BlockEntityBed thisBed = null;
        try {
            thisBed = (BlockEntityBed)this.createBlockEntity(new CompoundTag().putByte("color", item.getDamage()), new Object[0]);
            BlockEntityHolder nextBlock = (BlockEntityHolder)((Object)next.getLevelBlock());
            nextBlock.createBlockEntity(new CompoundTag().putByte("color", item.getDamage()), new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to create the block entity {} at {} and {}", (Object)this.getBlockEntityType(), (Object)this.getLocation(), (Object)next.getLocation(), (Object)e);
            if (thisBed != null) {
                thisBed.close();
            }
            this.level.setBlock((Vector3)thisLayer0, 0, thisLayer0, true);
            this.level.setBlock((Vector3)thisLayer1, 1, thisLayer1, true);
            this.level.setBlock((Vector3)nextLayer0, 0, nextLayer0, true);
            this.level.setBlock((Vector3)nextLayer1, 1, nextLayer1, true);
            return false;
        }
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        BlockFace direction = this.getBlockFace();
        if (this.isHeadPiece()) {
            Block other = this.getSide(direction.getOpposite());
            if (other.getId() == this.getId() && !((BlockBed)other).isHeadPiece() && direction.equals((Object)((BlockBed)other).getBlockFace())) {
                this.getLevel().setBlock((Vector3)other, Block.get(0), true, true);
            }
        } else {
            Block other = this.getSide(direction);
            if (other.getId() == this.getId() && ((BlockBed)other).isHeadPiece() && direction.equals((Object)((BlockBed)other).getBlockFace())) {
                this.getLevel().setBlock((Vector3)other, Block.get(0), true, true);
            }
        }
        this.getLevel().setBlock((Vector3)this, Block.get(0), true, false);
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBed((Integer)this.getDyeColor().getWoolData());
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        BlockEntityBed blockEntity;
        if (this.level != null && (blockEntity = (BlockEntityBed)this.getBlockEntity()) != null) {
            return blockEntity.getDyeColor();
        }
        return DyeColor.WHITE;
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.DIRECTION);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.DIRECTION, face);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isHeadPiece() {
        return this.getBooleanValue(HEAD_PIECE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setHeadPiece(boolean headPiece) {
        this.setBooleanValue(HEAD_PIECE, headPiece);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isOccupied() {
        return this.getBooleanValue(OCCUPIED);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setOccupied(boolean occupied) {
        this.setBooleanValue(OCCUPIED, occupied);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }

    @Override
    @PowerNukkitOnly(value="In Cloudburst Nukkit, the clone returns Object, which is a different signature!")
    @Since(value="1.4.0.0-PN")
    public BlockBed clone() {
        return (BlockBed)super.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isBedValid() {
        Block foot;
        Block head;
        BlockFace dir = this.getBlockFace();
        if (this.isHeadPiece()) {
            head = this;
            foot = this.getSide(dir.getOpposite());
        } else {
            head = this.getSide(dir);
            foot = this;
        }
        return head.getId() == foot.getId() && ((BlockBed)head).isHeadPiece() && ((BlockBed)head).getBlockFace().equals((Object)dir) && !((BlockBed)foot).isHeadPiece() && ((BlockBed)foot).getBlockFace().equals((Object)dir);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockBed getHeadPart() {
        if (this.isHeadPiece()) {
            return this;
        }
        BlockFace dir = this.getBlockFace();
        Block head = this.getSide(dir);
        if (head.getId() == this.getId() && ((BlockBed)head).isHeadPiece() && ((BlockBed)head).getBlockFace().equals((Object)dir)) {
            return (BlockBed)head;
        }
        return null;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockBed getFootPart() {
        if (!this.isHeadPiece()) {
            return this;
        }
        BlockFace dir = this.getBlockFace();
        Block foot = this.getSide(dir.getOpposite());
        if (foot.getId() == this.getId() && !((BlockBed)foot).isHeadPiece() && ((BlockBed)foot).getBlockFace().equals((Object)dir)) {
            return (BlockBed)foot;
        }
        return null;
    }
}

