/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockCrops;
import cn.nukkit.item.Item;
import java.util.concurrent.ThreadLocalRandom;

public class BlockCarrot
extends BlockCrops {
    public BlockCarrot(int meta) {
        super(meta);
    }

    public BlockCarrot() {
        this(0);
    }

    @Override
    public String getName() {
        return "Carrot Block";
    }

    @Override
    public int getId() {
        return 141;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (!this.isFullyGrown()) {
            return new Item[]{Item.get(391)};
        }
        int drops = 2;
        int attempts = 3 + Math.min(0, item.getEnchantmentLevel(18));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < attempts; ++i) {
            if (random.nextInt(7) >= 4) continue;
            ++drops;
        }
        return new Item[]{Item.get(391, 0, drops)};
    }

    @Override
    public Item toItem() {
        return Item.get(391);
    }
}

