/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.event.block.ComposterEmptyEvent;
import cn.nukkit.event.block.ComposterFillEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemDye;
import cn.nukkit.item.ItemID;
import cn.nukkit.item.MinecraftItemID;
import cn.nukkit.level.Sound;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.DyeColor;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
public class BlockComposter
extends BlockSolidMeta
implements ItemID {
    private static Int2IntOpenHashMap compostableItems = new Int2IntOpenHashMap();
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final IntBlockProperty COMPOSTER_FILL_LEVEL = new IntBlockProperty("composter_fill_level", false, 8);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(COMPOSTER_FILL_LEVEL);

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @PowerNukkitOnly
    public BlockComposter() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockComposter(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 468;
    }

    @Override
    public String getName() {
        return "Composter";
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 0.6;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.getPropertyValue(COMPOSTER_FILL_LEVEL);
    }

    @PowerNukkitOnly
    public boolean incrementLevel() {
        int fillLevel = this.getPropertyValue(COMPOSTER_FILL_LEVEL) + 1;
        this.setPropertyValue(COMPOSTER_FILL_LEVEL, fillLevel);
        this.level.setBlock((Vector3)this, this, true, true);
        return fillLevel == 8;
    }

    @PowerNukkitOnly
    public boolean isFull() {
        return this.getPropertyValue(COMPOSTER_FILL_LEVEL) == 8;
    }

    @PowerNukkitOnly
    public boolean isEmpty() {
        return this.getPropertyValue(COMPOSTER_FILL_LEVEL) == 0;
    }

    @Override
    @PowerNukkitDifference(info="Player is null when is called from BlockEntityHopper")
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.getCount() <= 0 || item.getId() == 0) {
            return false;
        }
        if (this.isFull()) {
            ComposterEmptyEvent event = new ComposterEmptyEvent(this, player, item, MinecraftItemID.BONE_MEAL.get(1), 0);
            this.level.getServer().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.setDamage(event.getNewLevel());
                this.level.setBlock((Vector3)this, this, true, true);
                this.level.dropItem(this.add(0.5, 0.85, 0.5), event.getDrop(), event.getMotion(), false, 10);
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_EMPTY);
            }
            return true;
        }
        int chance = BlockComposter.getChance(item);
        if (chance <= 0) {
            return false;
        }
        boolean success = new Random().nextInt(100) < chance;
        ComposterFillEvent event = new ComposterFillEvent(this, player, item, chance, success);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return true;
        }
        if (player != null && !player.isCreative()) {
            item.setCount(item.getCount() - 1);
        }
        if (event.isSuccess()) {
            if (this.incrementLevel()) {
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_READY);
            } else {
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_FILL_SUCCESS);
            }
        } else {
            this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_FILL);
        }
        return true;
    }

    @PowerNukkitOnly
    public Item empty() {
        return this.empty(null, null);
    }

    @PowerNukkitOnly
    public Item empty(@Nullable Item item, @Nullable Player player) {
        ComposterEmptyEvent event = new ComposterEmptyEvent(this, player, item, new ItemDye(DyeColor.WHITE), 0);
        this.level.getServer().getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.setPropertyValue(COMPOSTER_FILL_LEVEL, event.getNewLevel());
            this.level.setBlock((Vector3)this, this, true, true);
            if (item != null) {
                this.level.dropItem(this.add(0.5, 0.85, 0.5), event.getDrop(), event.getMotion(), false, 10);
            }
            this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_COMPOSTER_EMPTY);
            return event.getDrop();
        }
        return null;
    }

    @PowerNukkitOnly
    public static void registerItem(int chance, int itemId) {
        BlockComposter.registerItem(chance, itemId, 0);
    }

    @PowerNukkitOnly
    public static void registerItem(int chance, int itemId, int meta) {
        compostableItems.put(itemId << 6 | meta & 0x3F, chance);
    }

    @PowerNukkitOnly
    public static void registerItems(int chance, int ... itemIds) {
        for (int itemId : itemIds) {
            BlockComposter.registerItem(chance, itemId, 0);
        }
    }

    @PowerNukkitOnly
    public static void registerBlocks(int chance, int ... blockIds) {
        for (int blockId : blockIds) {
            BlockComposter.registerBlock(chance, blockId, 0);
        }
    }

    @PowerNukkitOnly
    public static void registerBlock(int chance, int blockId) {
        BlockComposter.registerBlock(chance, blockId, 0);
    }

    @PowerNukkitOnly
    public static void registerBlock(int chance, int blockId, int meta) {
        if (blockId > 255) {
            blockId = 255 - blockId;
        }
        BlockComposter.registerItem(chance, blockId, meta);
    }

    @PowerNukkitOnly
    public static void register(int chance, Item item) {
        BlockComposter.registerItem(chance, item.getId(), item.getDamage());
    }

    @PowerNukkitOnly
    public static int getChance(Item item) {
        int chance = compostableItems.get(item.getId() << 6 | item.getDamage());
        if (chance == 0) {
            chance = compostableItems.get(item.getId() << 6);
        }
        return chance;
    }

    private static void registerDefaults() {
        BlockComposter.registerItems(30, 335, 458, 464, 362, 361, 477, 295);
        BlockComposter.registerItems(50, 360, 338, 760);
        BlockComposter.registerItems(65, 260, 457, 391, 127, 392, 296);
        BlockComposter.registerItems(85, 393, 297, 357);
        BlockComposter.registerItems(100, 354, 400);
        BlockComposter.registerBlocks(30, 393, 18, 161, 6, 385, 462);
        BlockComposter.registerBlocks(50, 2, 81, 394, 106, 493, 542, 486);
        BlockComposter.registerBlocks(65, 37, 38, 175, 471, 111, 103, 86, 410, 411, 39, 40, 479, 478, 485);
        BlockComposter.registerBlocks(85, 170, 99, 100, 282);
        BlockComposter.registerBlocks(100, 92);
        BlockComposter.registerBlock(50, 31, 0);
        BlockComposter.registerBlock(50, 31, 1);
        BlockComposter.registerBlock(65, 31, 2);
        BlockComposter.registerBlock(65, 31, 3);
    }

    static {
        BlockComposter.registerDefaults();
    }
}

