/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.item.Item;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public abstract class BlockDoubleSlabBase
extends BlockSolidMeta {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockDoubleSlabBase(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Double " + this.getSlabName() + " Slab";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return BlockSlab.SIMPLE_SLAB_PROPERTIES;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract String getSlabName();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract int getSingleSlabId();

    @Override
    public Item toItem() {
        return this.getCurrentState().forItem().withBlockId(this.getSingleSlabId()).asItemBlock();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean isCorrectTool(Item item) {
        return this.canHarvestWithHand() || this.canHarvest(item);
    }

    @Override
    public Item[] getDrops(Item item) {
        if (this.isCorrectTool(item)) {
            Item slab = this.toItem();
            slab.setCount(2);
            return new Item[]{slab};
        }
        return Item.EMPTY_ARRAY;
    }
}

