/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntityHopper;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemHopper;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit"), @PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")})
public class BlockHopper
extends BlockTransparentMeta
implements RedstoneComponent,
Faceable,
BlockEntityHolder<BlockEntityHopper> {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.FACING_DIRECTION, CommonBlockProperties.TOGGLE);

    public BlockHopper() {
        this(0);
    }

    public BlockHopper(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 154;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityHopper> getBlockEntityClass() {
        return BlockEntityHopper.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Hopper";
    }

    @Override
    public String getName() {
        return "Hopper Block";
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 24.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    @PowerNukkitDifference(info="Using new method for checking if powered", since="1.4.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        CompoundTag nbt;
        boolean powered;
        BlockFace facing = face.getOpposite();
        if (facing == BlockFace.UP) {
            facing = BlockFace.DOWN;
        }
        this.setBlockFace(facing);
        if (this.level.getServer().isRedstoneEnabled() && (powered = this.isGettingPower()) == this.isEnabled()) {
            this.setEnabled(!powered);
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt = new CompoundTag().putList(new ListTag("Items")), new Object[0]) != null;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (player == null) {
            return false;
        }
        BlockEntityHopper blockEntity = (BlockEntityHopper)this.getOrCreateBlockEntity();
        return player.addWindow(blockEntity.getInventory()) != -1;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntityHopper blockEntity = (BlockEntityHopper)this.getBlockEntity();
        if (blockEntity != null) {
            return ContainerInventory.calculateRedstone(blockEntity.getInventory());
        }
        return super.getComparatorInputOverride();
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", replaceWith="getBlockFace()", reason="Duplicated")
    public BlockFace getFacing() {
        return this.getBlockFace();
    }

    public boolean isEnabled() {
        return !this.getBooleanValue(CommonBlockProperties.TOGGLE);
    }

    public void setEnabled(boolean enabled) {
        this.setBooleanValue(CommonBlockProperties.TOGGLE, !enabled);
    }

    @Override
    public int onUpdate(int type) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        if (type == 1 || type == 6) {
            boolean disabled = this.level.isBlockPowered(this.getLocation());
            if (disabled == this.isEnabled()) {
                this.setEnabled(!disabled);
                this.level.setBlock((Vector3)this, this, false, true);
                BlockEntityHopper be = (BlockEntityHopper)this.getBlockEntity();
                if (be != null) {
                    be.setDisabled(disabled);
                    if (!disabled) {
                        be.scheduleUpdate();
                    }
                }
            }
            return type;
        }
        return 0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public Item toItem() {
        return new ItemHopper();
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.FACING_DIRECTION, face);
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.FACING_DIRECTION);
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return side == BlockFace.UP;
    }
}

