/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;

public class BlockIce
extends BlockTransparent {
    @Override
    public int getId() {
        return 79;
    }

    @Override
    public String getName() {
        return "Ice";
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getFrictionFactor() {
        return 0.98;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will not create water when it is above air")
    public boolean onBreak(Item item) {
        if (this.level.getDimension() == 1 || item.getEnchantmentLevel(16) > 0 || this.down().getId() == 0) {
            return super.onBreak(item);
        }
        return this.level.setBlock((Vector3)this, Block.get(8), true);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2 && this.level.getBlockLightAt((int)this.x, (int)this.y, (int)this.z) >= 12) {
            BlockFadeEvent event = new BlockFadeEvent(this, this.level.getDimension() == 1 ? BlockIce.get(0) : BlockIce.get(8));
            this.level.getServer().getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                this.level.setBlock((Vector3)this, event.getNewState(), true);
            }
            return 2;
        }
        return 0;
    }

    @Override
    public Item[] getDrops(Item item) {
        return Item.EMPTY_ARRAY;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.ICE_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getLightFilter() {
        return 2;
    }
}

