/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.redstone.RedstoneUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.PluginManager;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(info="Implements RedstoneComponent and uses methods from it.", since="1.4.0.0-PN")
public class BlockObserver
extends BlockSolidMeta
implements RedstoneComponent,
Faceable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.FACING_DIRECTION, CommonBlockProperties.POWERED);

    public BlockObserver() {
        this(0);
    }

    public BlockObserver(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Observer";
    }

    @Override
    public int getId() {
        return 251;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (player != null) {
            if (Math.abs((double)player.getFloorX() - this.x) <= 1.0 && Math.abs((double)player.getFloorZ() - this.z) <= 1.0) {
                double y = player.y + (double)player.getEyeHeight();
                if (y - this.y > 2.0) {
                    this.setBlockFace(BlockFace.DOWN);
                } else if (this.y - y > 0.0) {
                    this.setBlockFace(BlockFace.UP);
                } else {
                    this.setBlockFace(player.getHorizontalFacing());
                }
            } else {
                this.setBlockFace(player.getHorizontalFacing());
            }
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Implemented")
    public boolean isPowerSource() {
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Implemented")
    public int getStrongPower(BlockFace side) {
        return this.isPowered() && side == this.getBlockFace() ? 15 : 0;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Implemented")
    public int getWeakPower(BlockFace face) {
        return this.getStrongPower(face);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Implemented")
    public int onUpdate(int type) {
        if (type == 3) {
            RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
            PluginManager pluginManager = this.level.getServer().getPluginManager();
            pluginManager.callEvent(ev);
            if (ev.isCancelled()) {
                return 0;
            }
            if (!this.isPowered()) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
                this.setPowered(true);
                if (this.level.setBlock(this, this)) {
                    this.getSide(this.getBlockFace().getOpposite()).onUpdate(6);
                    RedstoneComponent.updateAroundRedstone((Position)this.getSide(this.getBlockFace().getOpposite()), new BlockFace[0]);
                    this.level.scheduleUpdate(this, 2);
                }
            } else {
                pluginManager.callEvent(new BlockRedstoneEvent(this, 15, 0));
                this.setPowered(false);
                this.level.setBlock(this, this);
                this.getSide(this.getBlockFace().getOpposite()).onUpdate(6);
                RedstoneComponent.updateAroundRedstone((Position)this.getSide(this.getBlockFace().getOpposite()), new BlockFace[0]);
            }
            return 3;
        }
        if (type == Level.BLOCK_UPDATE_MOVED) {
            this.onNeighborChange(this.getBlockFace());
            return type;
        }
        return 0;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void onNeighborChange(@Nonnull BlockFace side) {
        Server server = this.level.getServer();
        BlockFace blockFace = this.getBlockFace();
        if (!server.isRedstoneEnabled() || this.isPowered() || side != blockFace || this.level.isUpdateScheduled(this, this)) {
            return;
        }
        RedstoneUpdateEvent ev = new RedstoneUpdateEvent(this);
        server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        this.level.scheduleUpdate(this, 5);
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public double getHardness() {
        return 3.5;
    }

    @Override
    public double getResistance() {
        return 17.5;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isPowered() {
        return this.getBooleanValue(CommonBlockProperties.POWERED);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPowered(boolean powered) {
        this.setBooleanValue(CommonBlockProperties.POWERED, powered);
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.FACING_DIRECTION);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.FACING_DIRECTION, face);
    }
}

