/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockRail;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityMinecartAbstract;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.utils.OptionalBoolean;
import javax.annotation.Nonnull;

public class BlockRailDetector
extends BlockRail {
    public BlockRailDetector() {
        this(0);
        this.canBePowered = true;
    }

    public BlockRailDetector(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 28;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return ACTIVABLE_PROPERTIES;
    }

    @Override
    public String getName() {
        return "Detector Rail";
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.isActive() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return this.isActive() ? 0 : (side == BlockFace.UP ? 15 : 0);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            this.updateState();
            return type;
        }
        return super.onUpdate(type);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        this.updateState();
    }

    protected void updateState() {
        boolean wasPowered = this.isActive();
        boolean isPowered = false;
        for (Entity entity : this.level.getNearbyEntities(new SimpleAxisAlignedBB((double)this.getFloorX() + 0.125, this.getFloorY(), (double)this.getFloorZ() + 0.125, (double)this.getFloorX() + 0.875, (double)this.getFloorY() + 0.525, (double)this.getFloorZ() + 0.875))) {
            if (!(entity instanceof EntityMinecartAbstract)) continue;
            isPowered = true;
            break;
        }
        if (isPowered && !wasPowered) {
            this.setActive(true);
            this.level.scheduleUpdate(this, this, 0);
            this.level.scheduleUpdate(this, this.down(), 0);
        }
        if (!isPowered && wasPowered) {
            this.setActive(false);
            this.level.scheduleUpdate(this, this, 0);
            this.level.scheduleUpdate(this, this.down(), 0);
        }
        this.level.updateComparatorOutputLevel(this);
    }

    @Override
    public boolean isActive() {
        return this.getBooleanValue(ACTIVE);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public OptionalBoolean isRailActive() {
        return OptionalBoolean.of(this.getBooleanValue(ACTIVE));
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setRailActive(boolean active) {
        this.setBooleanValue(ACTIVE, active);
    }
}

