/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockRedstoneDiode;
import cn.nukkit.blockentity.BlockEntityComparator;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemRedstoneComparator;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit"), @PowerNukkitDifference(info="Implements RedstoneComponent and uses methods from it.", since="1.4.0.0-PN")})
public abstract class BlockRedstoneComparator
extends BlockRedstoneDiode
implements RedstoneComponent,
BlockEntityHolder<BlockEntityComparator> {
    private static final Logger log = LogManager.getLogger(BlockRedstoneComparator.class);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BooleanBlockProperty OUTPUT_LIT = new BooleanBlockProperty("output_lit_bit", false);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BooleanBlockProperty OUTPUT_SUBTRACT = new BooleanBlockProperty("output_subtract_bit", false);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, OUTPUT_SUBTRACT, OUTPUT_LIT);

    public BlockRedstoneComparator() {
        this(0);
    }

    public BlockRedstoneComparator(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityComparator> getBlockEntityClass() {
        return BlockEntityComparator.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Comparator";
    }

    @Override
    protected int getDelay() {
        return 2;
    }

    @Override
    public BlockFace getFacing() {
        return BlockFace.fromHorizontalIndex(this.getDamage());
    }

    public Mode getMode() {
        return (this.getDamage() & 4) > 0 ? Mode.SUBTRACT : Mode.COMPARE;
    }

    @Override
    protected BlockRedstoneComparator getUnpowered() {
        return (BlockRedstoneComparator)Block.get(149, this.getDamage());
    }

    @Override
    protected BlockRedstoneComparator getPowered() {
        return (BlockRedstoneComparator)Block.get(150, this.getDamage());
    }

    @Override
    protected int getRedstoneSignal() {
        BlockEntityComparator comparator = (BlockEntityComparator)this.getBlockEntity();
        return comparator == null ? 0 : comparator.getOutputSignal();
    }

    @Override
    public void updateState() {
        int power;
        int output;
        if (!(this.level.isBlockTickPending(this, this) || (output = this.calculateOutput()) == (power = this.getRedstoneSignal()) && this.isPowered() == this.shouldBePowered())) {
            this.level.scheduleUpdate(this, this, 2);
        }
    }

    @Override
    protected int calculateInputStrength() {
        int power = super.calculateInputStrength();
        BlockFace face = this.getFacing();
        Block block = this.getSide(face);
        if (block.hasComparatorInputOverride()) {
            power = block.getComparatorInputOverride();
        } else if (power < 15 && block.isNormalBlock() && (block = block.getSide(face)).hasComparatorInputOverride()) {
            power = block.getComparatorInputOverride();
        }
        return power;
    }

    @Override
    protected boolean shouldBePowered() {
        int input = this.calculateInputStrength();
        if (input >= 15) {
            return true;
        }
        if (input == 0) {
            return false;
        }
        int sidePower = this.getPowerOnSides();
        return sidePower == 0 || input >= sidePower;
    }

    private int calculateOutput() {
        return this.getMode() == Mode.SUBTRACT ? Math.max(this.calculateInputStrength() - this.getPowerOnSides(), 0) : this.calculateInputStrength();
    }

    @Override
    @PowerNukkitDifference(info="Trigger observer.", since="1.4.0.0-PN")
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (this.getMode() == Mode.SUBTRACT) {
            this.setDamage(this.getDamage() - 4);
        } else {
            this.setDamage(this.getDamage() + 4);
        }
        this.level.addLevelEvent(this.add(0.5, 0.5, 0.5), 3500, this.getMode() == Mode.SUBTRACT ? 500 : 550);
        this.level.setBlock((Vector3)this, this, true, false);
        this.level.updateComparatorOutputLevelSelective(this, true);
        this.onChange();
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            this.onChange();
            return type;
        }
        return super.onUpdate(type);
    }

    @PowerNukkitDifference(info="Trigger observer.", since="1.4.0.0-PN")
    private void onChange() {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return;
        }
        int output = this.calculateOutput();
        BlockEntityComparator blockEntityComparator = (BlockEntityComparator)this.getBlockEntity();
        if (blockEntityComparator == null) {
            return;
        }
        int currentOutput = blockEntityComparator.getOutputSignal();
        blockEntityComparator.setOutputSignal(output);
        if (currentOutput != output || this.getMode() == Mode.COMPARE) {
            boolean shouldBePowered = this.shouldBePowered();
            boolean isPowered = this.isPowered();
            if (isPowered && !shouldBePowered) {
                this.level.setBlock((Vector3)this, this.getUnpowered(), true, false);
                this.level.updateComparatorOutputLevelSelective(this, true);
            } else if (!isPowered && shouldBePowered) {
                this.level.setBlock((Vector3)this, this.getPowered(), true, false);
                this.level.updateComparatorOutputLevelSelective(this, true);
            }
            Block side = this.getSide(this.getFacing().getOpposite());
            side.onUpdate(6);
            RedstoneComponent.updateAroundRedstone((Position)side, new BlockFace[0]);
        }
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        Block layer0 = this.level.getBlock((Vector3)this, 0);
        Block layer1 = this.level.getBlock((Vector3)this, 1);
        if (!super.place(item, block, target, face, fx, fy, fz, player)) {
            return false;
        }
        try {
            this.createBlockEntity(new CompoundTag().putList(new ListTag("Items")), new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to create the block entity {} at {}", (Object)this.getBlockEntityType(), (Object)this.getLocation(), (Object)e);
            this.level.setBlock((Vector3)layer0, 0, layer0, true);
            this.level.setBlock((Vector3)layer1, 1, layer1, true);
            return false;
        }
        this.onUpdate(6);
        return true;
    }

    @Override
    public boolean isPowered() {
        return this.isPowered || (this.getDamage() & 8) > 0;
    }

    @Override
    public Item toItem() {
        return new ItemRedstoneComparator();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    public static enum Mode {
        COMPARE,
        SUBTRACT;

    }
}

