/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallableMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.event.block.BlockFadeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(info="Extends BlockFallableMeta instead of BlockFallable")
public class BlockSnowLayer
extends BlockFallableMeta {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final IntBlockProperty SNOW_HEIGHT = new IntBlockProperty("height", true, 7);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty COVERED = new BooleanBlockProperty("covered_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(SNOW_HEIGHT, COVERED);

    public BlockSnowLayer() {
    }

    public BlockSnowLayer(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Top Snow";
    }

    @Override
    public int getId() {
        return 78;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getSnowHeight() {
        return this.getIntValue(SNOW_HEIGHT);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setSnowHeight(int snowHeight) {
        this.setIntValue(SNOW_HEIGHT, snowHeight);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isCovered() {
        return this.getBooleanValue(COVERED);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setCovered(boolean covered) {
        this.setBooleanValue(COVERED, covered);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Returns the max Y based on the snow height")
    public double getMaxY() {
        return this.y + (double)(Math.min(16, this.getSnowHeight() + 1) * 2) / 16.0;
    }

    @Override
    @Nullable
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Renders a bounding box that the entities stands on top")
    protected AxisAlignedBB recalculateBoundingBox() {
        int snowHeight = this.getSnowHeight();
        if (snowHeight < 3) {
            return null;
        }
        if (snowHeight == 3 || snowHeight == SNOW_HEIGHT.getMaxValue()) {
            return this;
        }
        return new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 0.5, this.z + 1.0);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Renders a bounding box with the actual snow_layer height")
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return this;
    }

    @Override
    public double getHardness() {
        return 0.1;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="0.1 instead of 0.5")
    public double getResistance() {
        return 0.1;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Returns false if it has all the 8 layers")
    public boolean canBeReplaced() {
        return this.getSnowHeight() < SNOW_HEIGHT.getMaxValue();
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will increase the layers and behave as expected in vanilla and will cover grass blocks")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        Optional<BlockSnowLayer> increment = Stream.of(target, block).filter(b -> b.getId() == 78).map(BlockSnowLayer.class::cast).filter(b -> b.getSnowHeight() < SNOW_HEIGHT.getMaxValue()).findFirst();
        if (increment.isPresent()) {
            BlockSnowLayer other = increment.get();
            if (Arrays.stream(this.level.getCollidingEntities(new SimpleAxisAlignedBB(other.x, other.y, other.z, other.x + 1.0, other.y + 1.0, other.z + 1.0))).anyMatch(e -> e instanceof EntityLiving)) {
                return false;
            }
            other.setSnowHeight(other.getSnowHeight() + 1);
            return this.level.setBlock((Vector3)other, other, true);
        }
        Block down = this.down();
        if (!down.isSolid()) {
            return false;
        }
        switch (down.getId()) {
            case 217: 
            case 416: {
                return false;
            }
            case 2: {
                this.setCovered(true);
                break;
            }
            case 31: {
                if (!this.level.setBlock((Vector3)this, 0, this, true)) {
                    return false;
                }
                this.level.setBlock(block, 1, block, true, false);
                return true;
            }
        }
        return this.getLevel().setBlock((Vector3)block, this, true);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will move the block in layer 1 to layer 0 when breaking in layer 0")
    public boolean onBreak(Item item) {
        if (this.layer != 0) {
            return super.onBreak(item);
        }
        return this.getLevel().setBlock(this, 0, this.getLevelBlockAtLayer(1), true, true);
    }

    @Override
    @Since(value="1.2.1.0-PN")
    @PowerNukkitOnly
    public void afterRemoval(Block newBlock, boolean update) {
        if (this.layer != 0 || newBlock.getId() == this.getId()) {
            return;
        }
        Block layer1 = this.getLevelBlockAtLayer(1);
        if (layer1.getId() != 31) {
            return;
        }
        Level level = this.getLevel();
        level.setBlock(this, 0, layer1, true, false);
        level.setBlock(this, 1, BlockSnowLayer.get(0), true, false);
        level.setBlock(this, 0, newBlock, true, false);
        Server.getInstance().getScheduler().scheduleDelayedTask(() -> {
            Player[] target = level.getChunkPlayers(this.getChunkX(), this.getChunkZ()).values().toArray(Player.EMPTY_ARRAY);
            Vector3[] blocks = new Vector3[]{this.getLocation()};
            level.sendBlocks(target, blocks, 11, 0, false);
            level.sendBlocks(target, blocks, 11, 1, false);
        }, 10);
        Player[] target = level.getChunkPlayers(this.getChunkX(), this.getChunkZ()).values().toArray(Player.EMPTY_ARRAY);
        Vector3[] blocks = new Vector3[]{this.getLocation()};
        level.sendBlocks(target, blocks, 11, 0, false);
        level.sendBlocks(target, blocks, 11, 1, false);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will melt on dry biomes and will melt gradually and will cover grass blocks")
    public int onUpdate(int type) {
        super.onUpdate(type);
        if (type == 2) {
            Biome biome = Biome.getBiome(this.getLevel().getBiomeId(this.getFloorX(), this.getFloorZ()));
            if (biome.isDry() || this.getLevel().getBlockLightAt(this.getFloorX(), this.getFloorY(), this.getFloorZ()) >= 10) {
                this.melt();
                return 2;
            }
        } else if (type == 1) {
            boolean covered;
            boolean bl = covered = this.down().getId() == 2;
            if (this.isCovered() != covered) {
                this.setCovered(covered);
                this.level.setBlock((Vector3)this, this, true);
                return type;
            }
        }
        return 0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean melt() {
        return this.melt(2);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean melt(int layers) {
        Block up;
        Preconditions.checkArgument((layers > 0 ? 1 : 0) != 0, (String)"Layers must be positive, got {}", (int)layers);
        Block toMelt = this;
        while (toMelt.getIntValue(SNOW_HEIGHT) == SNOW_HEIGHT.getMaxValue() && (up = toMelt.up()).getId() == 78) {
            toMelt = up;
        }
        int snowHeight = toMelt.getIntValue(SNOW_HEIGHT) - layers;
        Block newState = snowHeight < 0 ? BlockSnowLayer.get(0) : this.getCurrentState().withProperty(SNOW_HEIGHT, snowHeight).getBlock(toMelt);
        BlockFadeEvent event = new BlockFadeEvent(toMelt, newState);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        return this.level.setBlock((Vector3)toMelt, event.getNewState(), true);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Returns the snow_layer but with 0 height")
    public Item toItem() {
        return Item.getBlock(78);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed the amount of snowballs that are dropped")
    public Item[] getDrops(Item item) {
        int amount;
        if (!item.isShovel() || item.getTier() < 1) {
            return Item.EMPTY_ARRAY;
        }
        switch (this.getSnowHeight()) {
            case 0: 
            case 1: 
            case 2: {
                amount = 1;
                break;
            }
            case 3: 
            case 4: {
                amount = 2;
                break;
            }
            case 5: 
            case 6: {
                amount = 3;
                break;
            }
            default: {
                amount = 4;
            }
        }
        return new Item[]{Item.get(332, 0, amount)};
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.SNOW_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public boolean canBeFlowedInto() {
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Returns false when the height is 3+")
    public boolean canPassThrough() {
        return this.getSnowHeight() < 3;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return side == BlockFace.UP && this.getSnowHeight() == SNOW_HEIGHT.getMaxValue();
    }
}

