/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockPressurePlateBase;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.BlockColor;

public class BlockWeightedPressurePlateLight
extends BlockPressurePlateBase {
    public BlockWeightedPressurePlateLight() {
        this(0);
    }

    public BlockWeightedPressurePlateLight(int meta) {
        super(meta);
        this.onPitch = 0.90000004f;
        this.offPitch = 0.75f;
    }

    @Override
    public int getId() {
        return 147;
    }

    @Override
    public String getName() {
        return "Weighted Pressure Plate (Light)";
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.GOLD_BLOCK_COLOR;
    }

    @Override
    protected int computeRedstoneStrength() {
        int count = Math.min(this.level.getCollidingEntities(this.getCollisionBoundingBox()).length, this.getMaxWeight());
        if (count > 0) {
            float f = (float)Math.min(this.getMaxWeight(), count) / (float)this.getMaxWeight();
            return NukkitMath.ceilFloat(f * 15.0f);
        }
        return 0;
    }

    public int getMaxWeight() {
        return 15;
    }
}

