/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockWood;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.item.Item;
import java.io.Serializable;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public abstract class BlockWoodStripped
extends BlockWood {
    @PowerNukkitOnly
    public BlockWoodStripped() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockWoodStripped(int meta) {
        super(meta);
    }

    @Override
    public abstract int getId();

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PILLAR_PROPERTIES;
    }

    @Override
    protected BlockState getStrippedState() {
        return this.getCurrentState();
    }

    @Override
    public String getName() {
        return "Stripped " + (Object)((Object)this.getWoodType()) + " Log";
    }

    @Override
    public void setWoodType(WoodType woodType) {
        if (!woodType.equals((Object)this.getWoodType())) {
            throw new InvalidBlockPropertyValueException(WoodType.PROPERTY, (Serializable)((Object)this.getWoodType()), (Serializable)((Object)woodType), "Only the current value is supported for this block");
        }
    }

    @Override
    public boolean canBeActivated() {
        return false;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        return false;
    }
}

