/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.blockproperty.value.NetherReactorState;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.MathHelper;
import cn.nukkit.nbt.tag.CompoundTag;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockEntityNetherReactor
extends BlockEntitySpawnable {
    private NetherReactorState reactorState;
    private int progress;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockEntityNetherReactor(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getLevelBlock().getId() == 247;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public NetherReactorState getReactorState() {
        return this.reactorState;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setReactorState(NetherReactorState reactorState) {
        this.reactorState = reactorState;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getProgress() {
        return this.progress;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setProgress(int progress) {
        this.progress = MathHelper.clamp(progress, 0, 900);
    }

    @Override
    protected void initBlockEntity() {
        this.reactorState = NetherReactorState.READY;
        if (this.namedTag.containsShort("Progress")) {
            this.progress = (short)this.namedTag.getShort("Progress");
        }
        this.reactorState = this.namedTag.containsByte("HasFinished") && this.namedTag.getBoolean("HasFinished") ? NetherReactorState.FINISHED : (this.namedTag.containsByte("IsInitialized") && this.namedTag.getBoolean("IsInitialized") ? NetherReactorState.INITIALIZED : NetherReactorState.READY);
        super.initBlockEntity();
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        NetherReactorState reactorState = this.getReactorState();
        this.namedTag.putShort("Progress", this.getProgress());
        this.namedTag.putBoolean("HasFinished", reactorState == NetherReactorState.FINISHED);
        this.namedTag.putBoolean("IsInitialized", reactorState == NetherReactorState.INITIALIZED);
    }

    @Override
    public CompoundTag getSpawnCompound() {
        NetherReactorState reactorState = this.getReactorState();
        return new CompoundTag().putString("id", "NetherReactor").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("Progress", this.getProgress()).putBoolean("HasFinished", reactorState == NetherReactorState.FINISHED).putBoolean("IsInitialized", reactorState == NetherReactorState.INITIALIZED);
    }
}

