/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty.exception;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class InvalidBlockPropertyMetaException
extends InvalidBlockPropertyException {
    private static final long serialVersionUID = -8493494844859767053L;
    @Nonnull
    private final Number currentMeta;
    @Nonnull
    private final Number invalidMeta;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyMetaException(BlockProperty<?> property, Number currentMeta, Number invalidMeta) {
        super(property, InvalidBlockPropertyMetaException.buildMessage(currentMeta, invalidMeta));
        this.currentMeta = currentMeta;
        this.invalidMeta = invalidMeta;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyMetaException(BlockProperty<?> property, Number currentMeta, Number invalidMeta, String message) {
        super(property, InvalidBlockPropertyMetaException.buildMessage(currentMeta, invalidMeta) + ". " + message);
        this.currentMeta = currentMeta;
        this.invalidMeta = invalidMeta;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyMetaException(BlockProperty<?> property, Number currentMeta, Number invalidMeta, String message, Throwable cause) {
        super(property, InvalidBlockPropertyMetaException.buildMessage(currentMeta, invalidMeta) + ". " + message, cause);
        this.currentMeta = currentMeta;
        this.invalidMeta = invalidMeta;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyMetaException(BlockProperty<?> property, Number currentMeta, Number invalidMeta, Throwable cause) {
        super(property, InvalidBlockPropertyMetaException.buildMessage(currentMeta, invalidMeta), cause);
        this.currentMeta = currentMeta;
        this.invalidMeta = invalidMeta;
    }

    private static String buildMessage(Object currentValue, Object invalidValue) {
        return "Current Meta: " + currentValue + ", Invalid Meta: " + invalidValue;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Number getCurrentMeta() {
        return this.currentMeta;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Number getInvalidMeta() {
        return this.invalidMeta;
    }
}

