/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.api.Unsigned;
import cn.nukkit.block.Block;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.BlockStateRegistry;
import cn.nukkit.blockstate.BlockStateRepair;
import cn.nukkit.blockstate.Loggers;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.event.blockstate.BlockStateRepairEvent;
import cn.nukkit.event.blockstate.BlockStateRepairFinishEvent;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.PluginManager;
import cn.nukkit.utils.HumanStringComparator;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public interface IBlockState {
    @Nonnegative
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getBlockId();

    @Nonnull
    @Nonnegative
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Number getDataStorage();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isDefaultState();

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockProperties getProperties();

    @Deprecated
    @Nonnegative
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getLegacyDamage();

    @Deprecated
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    @Unsigned
    public int getBigDamage();

    @Deprecated
    @Nonnegative
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    default public int getSignedBigDamage() {
        return this.getBigDamage();
    }

    @Nonnull
    @Nonnegative
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger getHugeDamage();

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Serializable getPropertyValue(String var1);

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public <V extends Serializable> V getPropertyValue(BlockProperty<V> property) {
        return (V)((Serializable)this.getCheckedPropertyValue(property.getName(), property.getValueClass()));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public <V extends Serializable> V getUncheckedPropertyValue(BlockProperty<V> property) {
        return (V)((Serializable)this.getUncheckedPropertyValue(property.getName()));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getIntValue(String var1);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public int getIntValue(BlockProperty<?> property) {
        return this.getIntValue(property.getName());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getBooleanValue(String var1);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean getBooleanValue(BlockProperty<?> property) {
        return this.getBooleanValue(property.getName());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getPersistenceValue(String var1);

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public String getPersistenceValue(BlockProperty<?> property) {
        return this.getPersistenceValue(property.getName());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public String getPersistenceName() {
        return BlockStateRegistry.getPersistenceName(this.getBlockId());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public String getStateId() {
        BlockProperties properties = this.getProperties();
        TreeMap<String, String> propertyMap = new TreeMap<String, String>(HumanStringComparator.getInstance());
        try {
            properties.getNames().forEach(name -> propertyMap.put(properties.getBlockProperty((String)name).getPersistenceName(), this.getPersistenceValue((String)name)));
        }
        catch (InvalidBlockPropertyException e) {
            Loggers.logIBlockState.debug("Attempted to get the stateId of an invalid state {}:{}\nProperties: {}", (Object)this.getBlockId(), (Object)this.getDataStorage(), (Object)properties, (Object)e);
            return this.getLegacyStateId();
        }
        StringBuilder stateId = new StringBuilder(this.getPersistenceName());
        propertyMap.forEach((name, value) -> stateId.append(';').append((String)name).append('=').append((String)value));
        return stateId.toString();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public String getLegacyStateId() {
        return this.getPersistenceName() + ";nukkit-unknown=" + this.getDataStorage();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getCurrentState();

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlock() {
        Block block = Block.get(this.getBlockId());
        block.setState(this);
        return block;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlock(@Nullable Level level, int x, int y, int z) {
        return this.getBlock(level, x, y, z, 0, false, null);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlock(@Nullable Level level, int x, int y, int z, int layer) {
        return this.getBlock(level, x, y, z, layer, false, null);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlock(@Nullable Level level, int x, int y, int z, int layer, boolean repair) {
        return this.getBlock(level, x, y, z, layer, repair, null);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlock(@Nullable Level level, int x, int y, int z, int layer, boolean repair, @Nullable Consumer<BlockStateRepair> callback) {
        Block block = Block.get(this.getBlockId());
        block.level = level;
        block.x = x;
        block.y = y;
        block.z = z;
        block.layer = layer;
        BlockState currentState = this.getCurrentState();
        try {
            if (currentState.isCachedValidationValid()) {
                block.setState(currentState);
                return block;
            }
        }
        catch (Exception e) {
            Loggers.logIBlockState.error("Unexpected error while trying to set the cached valid state to the block. State: {}, Block: {}", (Object)currentState, (Object)block, (Object)e);
        }
        try {
            block.setDataStorage(currentState.getDataStorage(), repair, callback);
        }
        catch (InvalidBlockStateException e) {
            throw new InvalidBlockStateException(this.getCurrentState(), "Invalid block state in layer " + layer + " at: " + new Position(x, y, z, level), e);
        }
        return block;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlock(Position position) {
        return this.getBlock(position, 0);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlock(Block position) {
        return this.getBlock(position, position.layer);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlock(Position position, int layer) {
        return this.getBlock(position.getLevel(), position.getFloorX(), position.getFloorY(), position.getFloorZ(), layer);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlockRepairing(Block pos) {
        return this.getBlockRepairing(pos, pos.layer);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlockRepairing(Position position, int layer) {
        return this.getBlockRepairing(position.level, position, layer);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlockRepairing(@Nullable Level level, BlockVector3 pos, int layer) {
        return this.getBlockRepairing(level, pos.x, pos.y, pos.z, layer);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlockRepairing(@Nullable Level level, Vector3 pos) {
        return this.getBlockRepairing(level, pos, 0);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlockRepairing(@Nullable Level level, Vector3 pos, int layer) {
        return this.getBlockRepairing(level, pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlockRepairing(@Nullable Level level, int x, int y, int z) {
        return this.getBlockRepairing(level, x, y, z, 0);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlockRepairing(@Nullable Level level, int x, int y, int z, int layer) {
        return this.getBlockRepairing(level, x, y, z, layer, null);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Block getBlockRepairing(@Nullable Level level, int x, int y, int z, int layer, @Nullable Consumer<BlockStateRepair> callback) {
        ArrayList<BlockStateRepair> repairs = new ArrayList<BlockStateRepair>(0);
        Consumer<BlockStateRepair> callbackChain = repairs::add;
        if (!BlockStateRepairEvent.getHandlers().isEmpty()) {
            PluginManager manager = Server.getInstance().getPluginManager();
            callbackChain = callbackChain.andThen(repair -> manager.callEvent(new BlockStateRepairEvent((BlockStateRepair)repair)));
        }
        if (callback != null) {
            callbackChain = callbackChain.andThen(callback);
        }
        Block block = this.getBlock(level, x, y, z, layer, true, callbackChain);
        if (!BlockStateRepairFinishEvent.getHandlers().isEmpty()) {
            BlockStateRepairFinishEvent event = new BlockStateRepairFinishEvent(repairs, block);
            Server.getInstance().getPluginManager().callEvent(event);
            block = event.getResult();
        }
        if (!repairs.isEmpty() && Loggers.logIBlockState.isDebugEnabled()) {
            Loggers.logIBlockState.debug("The block that at Level:{}, X:{}, Y:{}, Z:{}, L:{} was repaired. Result: {}, Repairs: {}", (Object)level, (Object)x, (Object)y, (Object)z, (Object)layer, (Object)block, repairs, (Object)new Exception("Stacktrace"));
        }
        return block;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public int getRuntimeId() {
        return BlockStateRegistry.getRuntimeId(this.getCurrentState());
    }

    @Deprecated
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="the BlockState itself")
    default public int getFullId() {
        return this.getBlockId() << Block.DATA_BITS | this.getLegacyDamage() & Block.DATA_MASK;
    }

    @Deprecated
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="the BlockState itself")
    default public long getBigId() {
        return (long)this.getBlockId() << 32 | (long)(this.getBigDamage() & 0xFFFFFFFF);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BlockProperty getProperty(String propertyName) {
        return this.getProperties().getBlockProperty(propertyName);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public <T extends BlockProperty<?>> T getCheckedProperty(String propertyName, Class<T> tClass) {
        return this.getProperties().getBlockProperty(propertyName, tClass);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public Set<String> getPropertyNames() {
        return this.getProperties().getNames();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public <T> T getCheckedPropertyValue(String propertyName, Class<T> tClass) {
        return tClass.cast(this.getPropertyValue(propertyName));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public <T> T getUncheckedPropertyValue(String propertyName) {
        return (T)this.getPropertyValue(propertyName);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public int getBitSize() {
        return this.getProperties().getBitSize();
    }

    @Nonnegative
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getExactIntStorage();

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public ItemBlock asItemBlock() {
        return this.asItemBlock(1);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public ItemBlock asItemBlock(int count) {
        return this.getCurrentState().asItemBlock(count);
    }
}

