/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDispenser;
import cn.nukkit.block.BlockLava;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockWater;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.MinecraftItemID;
import cn.nukkit.math.BlockFace;

public class BucketDispenseBehavior
extends DefaultDispenseBehavior {
    @Override
    public Item dispense(BlockDispenser block, BlockFace face, Item item) {
        if (!(item instanceof ItemBucket)) {
            return super.dispense(block, face, item);
        }
        ItemBucket bucket = (ItemBucket)item;
        Block target = block.getSide(face);
        if (!bucket.isEmpty()) {
            Block replace;
            if ((target.canBeFlowedInto() || target.getId() == 90) && (replace = bucket.getTargetBlock()) instanceof BlockLiquid) {
                if (target.getId() == 90) {
                    target.onBreak(null);
                }
                block.level.setBlock(target, replace);
                return MinecraftItemID.BUCKET.get(1, bucket.getCompoundTag());
            }
        } else {
            if (target instanceof BlockWater && target.getDamage() == 0) {
                target.level.setBlock(target, Block.get(0));
                return MinecraftItemID.WATER_BUCKET.get(1, bucket.getCompoundTag());
            }
            if (target instanceof BlockLava && target.getDamage() == 0) {
                target.level.setBlock(target, Block.get(0));
                return MinecraftItemID.LAVA_BUCKET.get(1, bucket.getCompoundTag());
            }
        }
        return super.dispense(block, face, item);
    }
}

