/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.block.BlockEvent;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockExplosionPrimeEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private double force;
    private boolean blockBreaking;
    private double fireChance;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static HandlerList getHandlers() {
        return handlers;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockExplosionPrimeEvent(Block block, double force) {
        this(block, force, 0.0);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockExplosionPrimeEvent(Block block, double force, double fireChance) {
        super(block);
        this.force = force;
        this.blockBreaking = true;
        this.fireChance = fireChance;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public double getForce() {
        return this.force;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setForce(double force) {
        this.force = force;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isBlockBreaking() {
        return this.blockBreaking;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockBreaking(boolean blockBreaking) {
        this.blockBreaking = blockBreaking;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isIncendiary() {
        return this.fireChance > 0.0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setIncendiary(boolean incendiary) {
        if (!incendiary) {
            this.fireChance = 0.0;
        } else if (this.fireChance <= 0.0) {
            this.fireChance = 0.3333333333333333;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public double getFireChance() {
        return this.fireChance;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setFireChance(double fireChance) {
        this.fireChance = fireChance;
    }
}

