/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.MobEquipmentPacket;
import java.util.HashSet;
import java.util.Set;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class EntityEquipmentInventory
extends BaseInventory {
    private final Entity entity;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int MAIN_HAND = 0;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int OFFHAND = 1;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public EntityEquipmentInventory(Entity entity) {
        super((InventoryHolder)((Object)entity), InventoryType.ENTITY_EQUIPMENT);
        this.entity = entity;
    }

    @Override
    public String getName() {
        return "Entity Equipment";
    }

    @Override
    public int getSize() {
        return 2;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public InventoryHolder getHolder() {
        return this.holder;
    }

    @Override
    public void sendSlot(int index, Player ... players) {
        for (Player player : players) {
            this.sendSlot(index, player);
        }
    }

    @Override
    public void sendSlot(int index, Player player) {
        MobEquipmentPacket mobEquipmentPacket = new MobEquipmentPacket();
        mobEquipmentPacket.eid = this.entity.getId();
        mobEquipmentPacket.inventorySlot = mobEquipmentPacket.hotbarSlot = index;
        mobEquipmentPacket.item = this.getItem(index);
        player.dataPacket(mobEquipmentPacket);
    }

    @Override
    public Set<Player> getViewers() {
        HashSet<Player> viewers = new HashSet<Player>(this.viewers);
        viewers.addAll(this.entity.getViewers().values());
        return viewers;
    }

    @Override
    public boolean open(Player who) {
        return this.viewers.add(who);
    }

    @Override
    public void onClose(Player who) {
        this.viewers.remove(who);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getItemInHand() {
        return this.getItem(0);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getItemInOffhand() {
        return this.getItem(1);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setItemInHand(Item item, boolean send) {
        return this.setItem(0, item, send);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setItemInOffhand(Item item, boolean send) {
        return this.setItem(1, item, send);
    }

    @Override
    public void sendContents(Player target) {
        this.sendSlot(0, target);
        this.sendSlot(1, target);
    }

    @Override
    public void sendContents(Player ... target) {
        for (Player player : target) {
            this.sendContents(player);
        }
    }
}

