/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.FakeBlockUIComponent;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.inventory.SmithingRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class SmithingInventory
extends FakeBlockUIComponent {
    private static final int EQUIPMENT = 0;
    private static final int INGREDIENT = 1;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int SMITHING_EQUIPMENT_UI_SLOT = 51;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int SMITHING_INGREDIENT_UI_SLOT = 52;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public SmithingInventory(PlayerUIInventory playerUI, Position position) {
        super(playerUI, InventoryType.SMITHING_TABLE, 51, position);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public SmithingRecipe matchRecipe() {
        return Server.getInstance().getCraftingManager().matchSmithingRecipe(this.getEquipment(), this.getIngredient());
    }

    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        if (index == 0 || index == 1) {
            this.updateResult();
        }
        super.onSlotChange(index, before, send);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void updateResult() {
        SmithingRecipe recipe = this.matchRecipe();
        Item result = recipe == null ? Item.get(0) : recipe.getFinalResult(this.getEquipment());
        this.setResult(result);
    }

    private void setResult(Item result) {
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getResult() {
        SmithingRecipe recipe = this.matchRecipe();
        if (recipe == null) {
            return Item.get(0);
        }
        return recipe.getFinalResult(this.getEquipment());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getEquipment() {
        return this.getItem(0);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setEquipment(Item equipment) {
        this.setItem(0, equipment);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getIngredient() {
        return this.getItem(1);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setIngredient(Item ingredient) {
        this.setItem(1, ingredient);
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        who.craftingType = 1003;
    }

    @Override
    public void onClose(Player who) {
        super.onClose(who);
        who.craftingType = 0;
        who.giveItem(this.getItem(0), this.getItem(1));
        this.clear(0);
        this.clear(1);
        this.playerUI.clear(50);
    }
}

