/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockID;
import cn.nukkit.blockproperty.UnknownRuntimeIdException;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.BlockStateRegistry;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.entity.Entity;
import cn.nukkit.inventory.Fuel;
import cn.nukkit.item.ItemAcaciaSign;
import cn.nukkit.item.ItemApple;
import cn.nukkit.item.ItemAppleGold;
import cn.nukkit.item.ItemAppleGoldEnchanted;
import cn.nukkit.item.ItemArmorStand;
import cn.nukkit.item.ItemArrow;
import cn.nukkit.item.ItemAxeDiamond;
import cn.nukkit.item.ItemAxeGold;
import cn.nukkit.item.ItemAxeIron;
import cn.nukkit.item.ItemAxeNetherite;
import cn.nukkit.item.ItemAxeStone;
import cn.nukkit.item.ItemAxeWood;
import cn.nukkit.item.ItemBanner;
import cn.nukkit.item.ItemBannerPattern;
import cn.nukkit.item.ItemBed;
import cn.nukkit.item.ItemBeefRaw;
import cn.nukkit.item.ItemBeetroot;
import cn.nukkit.item.ItemBeetrootSoup;
import cn.nukkit.item.ItemBirchSign;
import cn.nukkit.item.ItemBlazePowder;
import cn.nukkit.item.ItemBlazeRod;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemBoat;
import cn.nukkit.item.ItemBone;
import cn.nukkit.item.ItemBook;
import cn.nukkit.item.ItemBookAndQuill;
import cn.nukkit.item.ItemBookEnchanted;
import cn.nukkit.item.ItemBookWritten;
import cn.nukkit.item.ItemBootsChain;
import cn.nukkit.item.ItemBootsDiamond;
import cn.nukkit.item.ItemBootsGold;
import cn.nukkit.item.ItemBootsIron;
import cn.nukkit.item.ItemBootsLeather;
import cn.nukkit.item.ItemBootsNetherite;
import cn.nukkit.item.ItemBow;
import cn.nukkit.item.ItemBowl;
import cn.nukkit.item.ItemBread;
import cn.nukkit.item.ItemBrewingStand;
import cn.nukkit.item.ItemBrick;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.ItemCake;
import cn.nukkit.item.ItemCampfire;
import cn.nukkit.item.ItemCampfireSoul;
import cn.nukkit.item.ItemCarrot;
import cn.nukkit.item.ItemCarrotGolden;
import cn.nukkit.item.ItemCarrotOnAStick;
import cn.nukkit.item.ItemCauldron;
import cn.nukkit.item.ItemChain;
import cn.nukkit.item.ItemChestplateChain;
import cn.nukkit.item.ItemChestplateDiamond;
import cn.nukkit.item.ItemChestplateGold;
import cn.nukkit.item.ItemChestplateIron;
import cn.nukkit.item.ItemChestplateLeather;
import cn.nukkit.item.ItemChestplateNetherite;
import cn.nukkit.item.ItemChickenCooked;
import cn.nukkit.item.ItemChickenRaw;
import cn.nukkit.item.ItemChorusFruit;
import cn.nukkit.item.ItemChorusFruitPopped;
import cn.nukkit.item.ItemClay;
import cn.nukkit.item.ItemClock;
import cn.nukkit.item.ItemClownfish;
import cn.nukkit.item.ItemCoal;
import cn.nukkit.item.ItemCompass;
import cn.nukkit.item.ItemCompassLodestone;
import cn.nukkit.item.ItemCookie;
import cn.nukkit.item.ItemCrimsonSign;
import cn.nukkit.item.ItemCrossbow;
import cn.nukkit.item.ItemDarkOakSign;
import cn.nukkit.item.ItemDiamond;
import cn.nukkit.item.ItemDoorAcacia;
import cn.nukkit.item.ItemDoorBirch;
import cn.nukkit.item.ItemDoorCrimson;
import cn.nukkit.item.ItemDoorDarkOak;
import cn.nukkit.item.ItemDoorIron;
import cn.nukkit.item.ItemDoorJungle;
import cn.nukkit.item.ItemDoorSpruce;
import cn.nukkit.item.ItemDoorWarped;
import cn.nukkit.item.ItemDoorWood;
import cn.nukkit.item.ItemDragonBreath;
import cn.nukkit.item.ItemDriedKelp;
import cn.nukkit.item.ItemDye;
import cn.nukkit.item.ItemEgg;
import cn.nukkit.item.ItemElytra;
import cn.nukkit.item.ItemEmerald;
import cn.nukkit.item.ItemEmptyMap;
import cn.nukkit.item.ItemEndCrystal;
import cn.nukkit.item.ItemEnderEye;
import cn.nukkit.item.ItemEnderPearl;
import cn.nukkit.item.ItemExpBottle;
import cn.nukkit.item.ItemFeather;
import cn.nukkit.item.ItemFireCharge;
import cn.nukkit.item.ItemFirework;
import cn.nukkit.item.ItemFish;
import cn.nukkit.item.ItemFishCooked;
import cn.nukkit.item.ItemFishingRod;
import cn.nukkit.item.ItemFlint;
import cn.nukkit.item.ItemFlintSteel;
import cn.nukkit.item.ItemFlowerPot;
import cn.nukkit.item.ItemGhastTear;
import cn.nukkit.item.ItemGlassBottle;
import cn.nukkit.item.ItemGlowstoneDust;
import cn.nukkit.item.ItemGunpowder;
import cn.nukkit.item.ItemHelmetChain;
import cn.nukkit.item.ItemHelmetDiamond;
import cn.nukkit.item.ItemHelmetGold;
import cn.nukkit.item.ItemHelmetIron;
import cn.nukkit.item.ItemHelmetLeather;
import cn.nukkit.item.ItemHelmetNetherite;
import cn.nukkit.item.ItemHoeDiamond;
import cn.nukkit.item.ItemHoeGold;
import cn.nukkit.item.ItemHoeIron;
import cn.nukkit.item.ItemHoeNetherite;
import cn.nukkit.item.ItemHoeStone;
import cn.nukkit.item.ItemHoeWood;
import cn.nukkit.item.ItemHoneyBottle;
import cn.nukkit.item.ItemHoneycomb;
import cn.nukkit.item.ItemHopper;
import cn.nukkit.item.ItemHorseArmorDiamond;
import cn.nukkit.item.ItemHorseArmorGold;
import cn.nukkit.item.ItemHorseArmorIron;
import cn.nukkit.item.ItemHorseArmorLeather;
import cn.nukkit.item.ItemID;
import cn.nukkit.item.ItemIngotGold;
import cn.nukkit.item.ItemIngotIron;
import cn.nukkit.item.ItemIngotNetherite;
import cn.nukkit.item.ItemItemFrame;
import cn.nukkit.item.ItemJungleSign;
import cn.nukkit.item.ItemKelp;
import cn.nukkit.item.ItemLead;
import cn.nukkit.item.ItemLeather;
import cn.nukkit.item.ItemLeggingsChain;
import cn.nukkit.item.ItemLeggingsDiamond;
import cn.nukkit.item.ItemLeggingsGold;
import cn.nukkit.item.ItemLeggingsIron;
import cn.nukkit.item.ItemLeggingsLeather;
import cn.nukkit.item.ItemLeggingsNetherite;
import cn.nukkit.item.ItemMagmaCream;
import cn.nukkit.item.ItemMap;
import cn.nukkit.item.ItemMelon;
import cn.nukkit.item.ItemMelonGlistering;
import cn.nukkit.item.ItemMinecart;
import cn.nukkit.item.ItemMinecartChest;
import cn.nukkit.item.ItemMinecartHopper;
import cn.nukkit.item.ItemMinecartTNT;
import cn.nukkit.item.ItemMushroomStew;
import cn.nukkit.item.ItemMuttonCooked;
import cn.nukkit.item.ItemMuttonRaw;
import cn.nukkit.item.ItemNameTag;
import cn.nukkit.item.ItemNetherBrick;
import cn.nukkit.item.ItemNetherSprouts;
import cn.nukkit.item.ItemNetherStar;
import cn.nukkit.item.ItemNetherWart;
import cn.nukkit.item.ItemNuggetGold;
import cn.nukkit.item.ItemNuggetIron;
import cn.nukkit.item.ItemPainting;
import cn.nukkit.item.ItemPaper;
import cn.nukkit.item.ItemPickaxeDiamond;
import cn.nukkit.item.ItemPickaxeGold;
import cn.nukkit.item.ItemPickaxeIron;
import cn.nukkit.item.ItemPickaxeNetherite;
import cn.nukkit.item.ItemPickaxeStone;
import cn.nukkit.item.ItemPickaxeWood;
import cn.nukkit.item.ItemPorkchopCooked;
import cn.nukkit.item.ItemPorkchopRaw;
import cn.nukkit.item.ItemPotato;
import cn.nukkit.item.ItemPotatoBaked;
import cn.nukkit.item.ItemPotatoPoisonous;
import cn.nukkit.item.ItemPotion;
import cn.nukkit.item.ItemPotionLingering;
import cn.nukkit.item.ItemPotionSplash;
import cn.nukkit.item.ItemPrismarineCrystals;
import cn.nukkit.item.ItemPrismarineShard;
import cn.nukkit.item.ItemPufferfish;
import cn.nukkit.item.ItemPumpkinPie;
import cn.nukkit.item.ItemQuartz;
import cn.nukkit.item.ItemRabbitCooked;
import cn.nukkit.item.ItemRabbitFoot;
import cn.nukkit.item.ItemRabbitHide;
import cn.nukkit.item.ItemRabbitRaw;
import cn.nukkit.item.ItemRabbitStew;
import cn.nukkit.item.ItemRecord11;
import cn.nukkit.item.ItemRecord13;
import cn.nukkit.item.ItemRecordBlocks;
import cn.nukkit.item.ItemRecordCat;
import cn.nukkit.item.ItemRecordChirp;
import cn.nukkit.item.ItemRecordFar;
import cn.nukkit.item.ItemRecordMall;
import cn.nukkit.item.ItemRecordMellohi;
import cn.nukkit.item.ItemRecordPigstep;
import cn.nukkit.item.ItemRecordStal;
import cn.nukkit.item.ItemRecordStrad;
import cn.nukkit.item.ItemRecordWait;
import cn.nukkit.item.ItemRecordWard;
import cn.nukkit.item.ItemRedstone;
import cn.nukkit.item.ItemRedstoneComparator;
import cn.nukkit.item.ItemRedstoneRepeater;
import cn.nukkit.item.ItemRottenFlesh;
import cn.nukkit.item.ItemSaddle;
import cn.nukkit.item.ItemSalmon;
import cn.nukkit.item.ItemSalmonCooked;
import cn.nukkit.item.ItemScrapNetherite;
import cn.nukkit.item.ItemSeedsBeetroot;
import cn.nukkit.item.ItemSeedsMelon;
import cn.nukkit.item.ItemSeedsPumpkin;
import cn.nukkit.item.ItemSeedsWheat;
import cn.nukkit.item.ItemShears;
import cn.nukkit.item.ItemShield;
import cn.nukkit.item.ItemShovelDiamond;
import cn.nukkit.item.ItemShovelGold;
import cn.nukkit.item.ItemShovelIron;
import cn.nukkit.item.ItemShovelNetherite;
import cn.nukkit.item.ItemShovelStone;
import cn.nukkit.item.ItemShovelWood;
import cn.nukkit.item.ItemShulkerShell;
import cn.nukkit.item.ItemSign;
import cn.nukkit.item.ItemSkull;
import cn.nukkit.item.ItemSlimeball;
import cn.nukkit.item.ItemSnowball;
import cn.nukkit.item.ItemSpawnEgg;
import cn.nukkit.item.ItemSpiderEye;
import cn.nukkit.item.ItemSpiderEyeFermented;
import cn.nukkit.item.ItemSpruceSign;
import cn.nukkit.item.ItemSteak;
import cn.nukkit.item.ItemStick;
import cn.nukkit.item.ItemString;
import cn.nukkit.item.ItemSugar;
import cn.nukkit.item.ItemSugarcane;
import cn.nukkit.item.ItemSuspiciousStew;
import cn.nukkit.item.ItemSweetBerries;
import cn.nukkit.item.ItemSwordDiamond;
import cn.nukkit.item.ItemSwordGold;
import cn.nukkit.item.ItemSwordIron;
import cn.nukkit.item.ItemSwordNetherite;
import cn.nukkit.item.ItemSwordStone;
import cn.nukkit.item.ItemSwordWood;
import cn.nukkit.item.ItemTotem;
import cn.nukkit.item.ItemTrident;
import cn.nukkit.item.ItemTurtleShell;
import cn.nukkit.item.ItemWarpedFungusOnAStick;
import cn.nukkit.item.ItemWarpedSign;
import cn.nukkit.item.ItemWheat;
import cn.nukkit.item.MinecraftItemID;
import cn.nukkit.item.RuntimeItemMapping;
import cn.nukkit.item.RuntimeItems;
import cn.nukkit.item.UnknownNetworkIdException;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.Utils;
import io.netty.util.internal.EmptyArrays;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Item
implements Cloneable,
BlockID,
ItemID {
    private static final Logger log = LogManager.getLogger(Item.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final Item[] EMPTY_ARRAY = new Item[0];
    private static final Pattern ITEM_STRING_PATTERN = Pattern.compile("^(?:(?:([a-z_]\\w*):)?([a-z._]\\w*)(?::(-?\\d+))?|(-?\\d+)(?::(-?\\d+))?)$");
    protected static String UNKNOWN_STR = "Unknown";
    public static Class[] list = null;
    private static Map<String, Integer> itemIds = Arrays.stream(ItemID.class.getDeclaredFields()).filter(field -> field.getModifiers() == 25).filter(field -> field.getType().equals(Integer.TYPE)).collect(Collectors.toMap(field -> field.getName().toLowerCase(), field -> {
        try {
            return field.getInt(null);
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e);
        }
    }, (e1, e2) -> e1, LinkedHashMap::new));
    private static Map<String, Integer> blockIds = Arrays.stream(BlockID.class.getDeclaredFields()).filter(field -> field.getModifiers() == 25).filter(field -> field.getType().equals(Integer.TYPE)).collect(Collectors.toMap(field -> field.getName().toLowerCase(), field -> {
        try {
            int blockId = field.getInt(null);
            if (blockId > 255) {
                return 255 - blockId;
            }
            return blockId;
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e);
        }
    }, (e1, e2) -> e1, LinkedHashMap::new));
    protected Block block = null;
    protected final int id;
    protected int meta;
    protected boolean hasMeta = true;
    private byte[] tags = EmptyArrays.EMPTY_BYTES;
    private transient CompoundTag cachedNBT = null;
    public int count;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Unused", replaceWith="meta or getDamage()")
    protected int durability = 0;
    protected String name;
    private static List<String> itemList;
    private static final ArrayList<Item> creative;

    public Item(int id) {
        this(id, 0, 1, UNKNOWN_STR);
    }

    public Item(int id, Integer meta) {
        this(id, meta, 1, UNKNOWN_STR);
    }

    public Item(int id, Integer meta, int count) {
        this(id, meta, count, UNKNOWN_STR);
    }

    public Item(int id, Integer meta, int count, String name) {
        this.id = id;
        if (meta != null && meta >= 0) {
            this.meta = meta & 0xFFFF;
        } else {
            this.hasMeta = false;
        }
        this.count = count;
        this.name = name != null ? name.intern() : null;
    }

    public boolean hasMeta() {
        return this.hasMeta;
    }

    public boolean canBeActivated() {
        return false;
    }

    public static void init() {
        if (list == null) {
            list = new Class[65535];
            Item.list[256] = ItemShovelIron.class;
            Item.list[257] = ItemPickaxeIron.class;
            Item.list[258] = ItemAxeIron.class;
            Item.list[259] = ItemFlintSteel.class;
            Item.list[260] = ItemApple.class;
            Item.list[261] = ItemBow.class;
            Item.list[262] = ItemArrow.class;
            Item.list[263] = ItemCoal.class;
            Item.list[264] = ItemDiamond.class;
            Item.list[265] = ItemIngotIron.class;
            Item.list[266] = ItemIngotGold.class;
            Item.list[267] = ItemSwordIron.class;
            Item.list[268] = ItemSwordWood.class;
            Item.list[269] = ItemShovelWood.class;
            Item.list[270] = ItemPickaxeWood.class;
            Item.list[271] = ItemAxeWood.class;
            Item.list[272] = ItemSwordStone.class;
            Item.list[273] = ItemShovelStone.class;
            Item.list[274] = ItemPickaxeStone.class;
            Item.list[275] = ItemAxeStone.class;
            Item.list[276] = ItemSwordDiamond.class;
            Item.list[277] = ItemShovelDiamond.class;
            Item.list[278] = ItemPickaxeDiamond.class;
            Item.list[279] = ItemAxeDiamond.class;
            Item.list[280] = ItemStick.class;
            Item.list[281] = ItemBowl.class;
            Item.list[282] = ItemMushroomStew.class;
            Item.list[283] = ItemSwordGold.class;
            Item.list[284] = ItemShovelGold.class;
            Item.list[285] = ItemPickaxeGold.class;
            Item.list[286] = ItemAxeGold.class;
            Item.list[287] = ItemString.class;
            Item.list[288] = ItemFeather.class;
            Item.list[289] = ItemGunpowder.class;
            Item.list[290] = ItemHoeWood.class;
            Item.list[291] = ItemHoeStone.class;
            Item.list[292] = ItemHoeIron.class;
            Item.list[293] = ItemHoeDiamond.class;
            Item.list[294] = ItemHoeGold.class;
            Item.list[295] = ItemSeedsWheat.class;
            Item.list[296] = ItemWheat.class;
            Item.list[297] = ItemBread.class;
            Item.list[298] = ItemHelmetLeather.class;
            Item.list[299] = ItemChestplateLeather.class;
            Item.list[300] = ItemLeggingsLeather.class;
            Item.list[301] = ItemBootsLeather.class;
            Item.list[302] = ItemHelmetChain.class;
            Item.list[303] = ItemChestplateChain.class;
            Item.list[304] = ItemLeggingsChain.class;
            Item.list[305] = ItemBootsChain.class;
            Item.list[306] = ItemHelmetIron.class;
            Item.list[307] = ItemChestplateIron.class;
            Item.list[308] = ItemLeggingsIron.class;
            Item.list[309] = ItemBootsIron.class;
            Item.list[310] = ItemHelmetDiamond.class;
            Item.list[311] = ItemChestplateDiamond.class;
            Item.list[312] = ItemLeggingsDiamond.class;
            Item.list[313] = ItemBootsDiamond.class;
            Item.list[314] = ItemHelmetGold.class;
            Item.list[315] = ItemChestplateGold.class;
            Item.list[316] = ItemLeggingsGold.class;
            Item.list[317] = ItemBootsGold.class;
            Item.list[318] = ItemFlint.class;
            Item.list[319] = ItemPorkchopRaw.class;
            Item.list[320] = ItemPorkchopCooked.class;
            Item.list[321] = ItemPainting.class;
            Item.list[322] = ItemAppleGold.class;
            Item.list[323] = ItemSign.class;
            Item.list[324] = ItemDoorWood.class;
            Item.list[325] = ItemBucket.class;
            Item.list[328] = ItemMinecart.class;
            Item.list[329] = ItemSaddle.class;
            Item.list[330] = ItemDoorIron.class;
            Item.list[331] = ItemRedstone.class;
            Item.list[332] = ItemSnowball.class;
            Item.list[333] = ItemBoat.class;
            Item.list[334] = ItemLeather.class;
            Item.list[335] = ItemKelp.class;
            Item.list[336] = ItemBrick.class;
            Item.list[337] = ItemClay.class;
            Item.list[338] = ItemSugarcane.class;
            Item.list[339] = ItemPaper.class;
            Item.list[340] = ItemBook.class;
            Item.list[341] = ItemSlimeball.class;
            Item.list[342] = ItemMinecartChest.class;
            Item.list[344] = ItemEgg.class;
            Item.list[345] = ItemCompass.class;
            Item.list[346] = ItemFishingRod.class;
            Item.list[347] = ItemClock.class;
            Item.list[348] = ItemGlowstoneDust.class;
            Item.list[349] = ItemFish.class;
            Item.list[350] = ItemFishCooked.class;
            Item.list[351] = ItemDye.class;
            Item.list[352] = ItemBone.class;
            Item.list[353] = ItemSugar.class;
            Item.list[354] = ItemCake.class;
            Item.list[355] = ItemBed.class;
            Item.list[356] = ItemRedstoneRepeater.class;
            Item.list[357] = ItemCookie.class;
            Item.list[358] = ItemMap.class;
            Item.list[359] = ItemShears.class;
            Item.list[360] = ItemMelon.class;
            Item.list[361] = ItemSeedsPumpkin.class;
            Item.list[362] = ItemSeedsMelon.class;
            Item.list[363] = ItemBeefRaw.class;
            Item.list[364] = ItemSteak.class;
            Item.list[365] = ItemChickenRaw.class;
            Item.list[366] = ItemChickenCooked.class;
            Item.list[367] = ItemRottenFlesh.class;
            Item.list[368] = ItemEnderPearl.class;
            Item.list[369] = ItemBlazeRod.class;
            Item.list[370] = ItemGhastTear.class;
            Item.list[371] = ItemNuggetGold.class;
            Item.list[372] = ItemNetherWart.class;
            Item.list[373] = ItemPotion.class;
            Item.list[374] = ItemGlassBottle.class;
            Item.list[375] = ItemSpiderEye.class;
            Item.list[376] = ItemSpiderEyeFermented.class;
            Item.list[377] = ItemBlazePowder.class;
            Item.list[378] = ItemMagmaCream.class;
            Item.list[379] = ItemBrewingStand.class;
            Item.list[380] = ItemCauldron.class;
            Item.list[381] = ItemEnderEye.class;
            Item.list[382] = ItemMelonGlistering.class;
            Item.list[383] = ItemSpawnEgg.class;
            Item.list[384] = ItemExpBottle.class;
            Item.list[385] = ItemFireCharge.class;
            Item.list[386] = ItemBookAndQuill.class;
            Item.list[387] = ItemBookWritten.class;
            Item.list[388] = ItemEmerald.class;
            Item.list[389] = ItemItemFrame.class;
            Item.list[390] = ItemFlowerPot.class;
            Item.list[391] = ItemCarrot.class;
            Item.list[392] = ItemPotato.class;
            Item.list[393] = ItemPotatoBaked.class;
            Item.list[394] = ItemPotatoPoisonous.class;
            Item.list[395] = ItemEmptyMap.class;
            Item.list[396] = ItemCarrotGolden.class;
            Item.list[397] = ItemSkull.class;
            Item.list[398] = ItemCarrotOnAStick.class;
            Item.list[399] = ItemNetherStar.class;
            Item.list[400] = ItemPumpkinPie.class;
            Item.list[401] = ItemFirework.class;
            Item.list[403] = ItemBookEnchanted.class;
            Item.list[404] = ItemRedstoneComparator.class;
            Item.list[405] = ItemNetherBrick.class;
            Item.list[406] = ItemQuartz.class;
            Item.list[407] = ItemMinecartTNT.class;
            Item.list[408] = ItemMinecartHopper.class;
            Item.list[409] = ItemPrismarineShard.class;
            Item.list[410] = ItemHopper.class;
            Item.list[411] = ItemRabbitRaw.class;
            Item.list[412] = ItemRabbitCooked.class;
            Item.list[413] = ItemRabbitStew.class;
            Item.list[414] = ItemRabbitFoot.class;
            Item.list[415] = ItemRabbitHide.class;
            Item.list[416] = ItemHorseArmorLeather.class;
            Item.list[417] = ItemHorseArmorIron.class;
            Item.list[418] = ItemHorseArmorGold.class;
            Item.list[419] = ItemHorseArmorDiamond.class;
            Item.list[420] = ItemLead.class;
            Item.list[421] = ItemNameTag.class;
            Item.list[422] = ItemPrismarineCrystals.class;
            Item.list[423] = ItemMuttonRaw.class;
            Item.list[424] = ItemMuttonCooked.class;
            Item.list[425] = ItemArmorStand.class;
            Item.list[426] = ItemEndCrystal.class;
            Item.list[427] = ItemDoorSpruce.class;
            Item.list[428] = ItemDoorBirch.class;
            Item.list[429] = ItemDoorJungle.class;
            Item.list[430] = ItemDoorAcacia.class;
            Item.list[431] = ItemDoorDarkOak.class;
            Item.list[432] = ItemChorusFruit.class;
            Item.list[433] = ItemChorusFruitPopped.class;
            Item.list[434] = ItemBannerPattern.class;
            Item.list[437] = ItemDragonBreath.class;
            Item.list[438] = ItemPotionSplash.class;
            Item.list[441] = ItemPotionLingering.class;
            Item.list[444] = ItemElytra.class;
            Item.list[445] = ItemShulkerShell.class;
            Item.list[446] = ItemBanner.class;
            Item.list[450] = ItemTotem.class;
            Item.list[452] = ItemNuggetIron.class;
            Item.list[455] = ItemTrident.class;
            Item.list[457] = ItemBeetroot.class;
            Item.list[458] = ItemSeedsBeetroot.class;
            Item.list[459] = ItemBeetrootSoup.class;
            Item.list[460] = ItemSalmon.class;
            Item.list[461] = ItemClownfish.class;
            Item.list[462] = ItemPufferfish.class;
            Item.list[463] = ItemSalmonCooked.class;
            Item.list[464] = ItemDriedKelp.class;
            Item.list[466] = ItemAppleGoldEnchanted.class;
            Item.list[469] = ItemTurtleShell.class;
            Item.list[471] = ItemCrossbow.class;
            Item.list[472] = ItemSpruceSign.class;
            Item.list[473] = ItemBirchSign.class;
            Item.list[474] = ItemJungleSign.class;
            Item.list[475] = ItemAcaciaSign.class;
            Item.list[476] = ItemDarkOakSign.class;
            Item.list[477] = ItemSweetBerries.class;
            Item.list[500] = ItemRecord13.class;
            Item.list[501] = ItemRecordCat.class;
            Item.list[502] = ItemRecordBlocks.class;
            Item.list[503] = ItemRecordChirp.class;
            Item.list[504] = ItemRecordFar.class;
            Item.list[505] = ItemRecordMall.class;
            Item.list[506] = ItemRecordMellohi.class;
            Item.list[507] = ItemRecordStal.class;
            Item.list[508] = ItemRecordStrad.class;
            Item.list[509] = ItemRecordWard.class;
            Item.list[510] = ItemRecord11.class;
            Item.list[511] = ItemRecordWait.class;
            Item.list[513] = ItemShield.class;
            Item.list[720] = ItemCampfire.class;
            Item.list[734] = ItemSuspiciousStew.class;
            Item.list[736] = ItemHoneycomb.class;
            Item.list[737] = ItemHoneyBottle.class;
            Item.list[741] = ItemCompassLodestone.class;
            Item.list[742] = ItemIngotNetherite.class;
            Item.list[743] = ItemSwordNetherite.class;
            Item.list[744] = ItemShovelNetherite.class;
            Item.list[745] = ItemPickaxeNetherite.class;
            Item.list[746] = ItemAxeNetherite.class;
            Item.list[747] = ItemHoeNetherite.class;
            Item.list[748] = ItemHelmetNetherite.class;
            Item.list[749] = ItemChestplateNetherite.class;
            Item.list[750] = ItemLeggingsNetherite.class;
            Item.list[751] = ItemBootsNetherite.class;
            Item.list[752] = ItemScrapNetherite.class;
            Item.list[753] = ItemCrimsonSign.class;
            Item.list[754] = ItemWarpedSign.class;
            Item.list[755] = ItemDoorCrimson.class;
            Item.list[756] = ItemDoorWarped.class;
            Item.list[757] = ItemWarpedFungusOnAStick.class;
            Item.list[758] = ItemChain.class;
            Item.list[759] = ItemRecordPigstep.class;
            Item.list[760] = ItemNetherSprouts.class;
            Item.list[801] = ItemCampfireSoul.class;
            for (int i = 0; i < 256; ++i) {
                if (Block.list[i] == null) continue;
                Item.list[i] = Block.list[i];
            }
        }
        Item.initCreativeItems();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static List<String> rebuildItemList() {
        itemList = Collections.unmodifiableList(Stream.of(BlockStateRegistry.getPersistenceNames().stream().map(name -> name.substring(name.indexOf(58) + 1)), itemIds.keySet().stream()).flatMap(Function.identity()).distinct().collect(Collectors.toList()));
        return itemList;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static List<String> getItemList() {
        List<String> itemList = Item.itemList;
        if (itemList == null) {
            return Item.rebuildItemList();
        }
        return itemList;
    }

    private static void initCreativeItems() {
        Item.clearCreativeItems();
        Config config = new Config(1);
        InputStream resourceAsStream = Server.class.getClassLoader().getResourceAsStream("creativeitems.json");
        Object object = null;
        try {
            config.load(resourceAsStream);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (resourceAsStream != null) {
                if (object != null) {
                    try {
                        resourceAsStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    resourceAsStream.close();
                }
            }
        }
        List<Map> list = config.getMapList("items");
        for (Map map : list) {
            try {
                Item item = Item.loadCreativeItemEntry(map);
                if (item == null) continue;
                Item.addCreativeItem(item);
            }
            catch (Exception e) {
                log.error("Error while registering a creative item", (Throwable)e);
            }
        }
    }

    private static Item loadCreativeItemEntry(Map<String, Object> data) {
        String nbt = (String)data.get("nbt_b64");
        byte[] nbtBytes = nbt != null ? Base64.getDecoder().decode(nbt) : EmptyArrays.EMPTY_BYTES;
        String id = data.get("id").toString();
        Item item = null;
        if (data.containsKey("damage")) {
            int meta = Utils.toInt(data.get("damage"));
            item = Item.fromString(id + ":" + meta);
        } else if (data.containsKey("blockRuntimeId")) {
            Integer blockId = BlockStateRegistry.getBlockId(id);
            if (blockId == null || blockId > 559) {
                return null;
            }
            int blockRuntimeId = -1;
            try {
                blockRuntimeId = ((Number)data.get("blockRuntimeId")).intValue();
                BlockState blockState = BlockStateRegistry.getBlockStateByRuntimeId(blockRuntimeId);
                if (blockState != null) {
                    item = blockState.asItemBlock();
                } else {
                    log.warn("Block state not found for the creative item {} with runtimeId {}", (Object)id, (Object)blockRuntimeId);
                }
            }
            catch (Throwable e) {
                log.error("Error loading the creative item {} with runtimeId {}", (Object)id, (Object)blockRuntimeId, (Object)e);
                return null;
            }
        }
        if (item == null) {
            item = Item.fromString(id);
        }
        item.setCompoundTag(nbtBytes);
        return item;
    }

    public static void clearCreativeItems() {
        creative.clear();
    }

    public static ArrayList<Item> getCreativeItems() {
        return new ArrayList<Item>(creative);
    }

    public static void addCreativeItem(Item item) {
        creative.add(item.clone());
    }

    public static void removeCreativeItem(Item item) {
        int index = Item.getCreativeItemIndex(item);
        if (index != -1) {
            creative.remove(index);
        }
    }

    public static boolean isCreativeItem(Item item) {
        for (Item aCreative : creative) {
            if (!item.equals(aCreative, !item.isTool())) continue;
            return true;
        }
        return false;
    }

    public static Item getCreativeItem(int index) {
        return index >= 0 && index < creative.size() ? creative.get(index) : null;
    }

    public static int getCreativeItemIndex(Item item) {
        for (int i = 0; i < creative.size(); ++i) {
            if (!item.equals(creative.get(i), !item.isTool())) continue;
            return i;
        }
        return -1;
    }

    public static Item getBlock(int id) {
        return Item.getBlock(id, 0);
    }

    public static Item getBlock(int id, Integer meta) {
        return Item.getBlock(id, meta, 1);
    }

    public static Item getBlock(int id, Integer meta, int count) {
        return Item.getBlock(id, meta, count, EmptyArrays.EMPTY_BYTES);
    }

    public static Item getBlock(int id, Integer meta, int count, byte[] tags) {
        if (id > 255) {
            id = 255 - id;
        }
        return Item.get(id, meta, count, tags);
    }

    public static Item get(int id) {
        return Item.get(id, 0);
    }

    public static Item get(int id, Integer meta) {
        return Item.get(id, meta, 1);
    }

    public static Item get(int id, Integer meta, int count) {
        return Item.get(id, meta, count, EmptyArrays.EMPTY_BYTES);
    }

    @PowerNukkitDifference(info="Prevents players from getting invalid items by limiting the return to the maximum damage defined in Block.getMaxItemDamage()", since="1.4.0.0-PN")
    public static Item get(int id, Integer meta, int count, byte[] tags) {
        try {
            Item item;
            Class<? extends Block> c = null;
            if (id < 0) {
                int blockId = 255 - id;
                c = Block.list[blockId];
            } else {
                c = list[id];
            }
            if (id < 256) {
                int blockId;
                int n = blockId = id < 0 ? 255 - id : id;
                if (meta == 0) {
                    item = new ItemBlock(Block.get(blockId), (Integer)0, count);
                } else if (meta == -1) {
                    item = new ItemBlock(Block.get(blockId), (Integer)-1);
                } else {
                    BlockState state = BlockState.of(blockId, meta);
                    try {
                        state.validate();
                        item = state.asItemBlock(count);
                    }
                    catch (InvalidBlockPropertyMetaException | InvalidBlockStateException e) {
                        log.warn("Attempted to get an ItemBlock with invalid block state in memory: {}, trying to repair the block state...", (Object)state);
                        log.catching(Level.DEBUG, (Throwable)e);
                        Block repaired = state.getBlockRepairing(null, 0, 0, 0);
                        item = repaired.asItemBlock(count);
                        log.error("Attempted to get an illegal item block {}:{} ({}), the meta was changed to {}", (Object)id, (Object)meta, (Object)blockId, (Object)item.getDamage(), (Object)e);
                    }
                    catch (UnknownRuntimeIdException e) {
                        log.warn("Attempted to get an illegal item block {}:{} ({}), the runtime id was unknown and the meta was changed to 0", (Object)id, (Object)meta, (Object)blockId, (Object)e);
                        item = BlockState.of(id).asItemBlock(count);
                    }
                }
            } else {
                item = c == null ? new Item(id, meta, count) : (meta == -1 ? ((Item)((Object)c.getConstructor(Integer.class, Integer.TYPE).newInstance(0, count))).createFuzzyCraftingRecipe() : (Item)((Object)c.getConstructor(Integer.class, Integer.TYPE).newInstance(meta, count)));
            }
            if (tags.length != 0) {
                item.setCompoundTag(tags);
            }
            return item;
        }
        catch (Exception e) {
            log.error("Error getting the item {}:{}{}! Returning an unsafe item stack!", (Object)id, (Object)meta, (Object)(id < 0 ? " (" + (255 - id) + ")" : ""), (Object)e);
            return new Item(id, meta, count).setCompoundTag(tags);
        }
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Improve namespaced name handling and allows to get custom blocks by name")
    public static Item fromString(String str) {
        String normalized = str.trim().replace(' ', '_').toLowerCase();
        Matcher matcher = ITEM_STRING_PATTERN.matcher(normalized);
        if (!matcher.matches()) {
            return Item.get(0);
        }
        String name = matcher.group(2);
        OptionalInt meta = OptionalInt.empty();
        String metaGroup = name != null ? matcher.group(3) : matcher.group(5);
        if (metaGroup != null) {
            meta = OptionalInt.of(Short.parseShort(metaGroup));
        }
        String numericIdGroup = matcher.group(4);
        if (name != null) {
            String namespaceGroup = matcher.group(1);
            String namespacedId = namespaceGroup != null ? namespaceGroup + ":" + name : "minecraft:" + name;
            MinecraftItemID minecraftItemId = MinecraftItemID.getByNamespaceId(namespacedId);
            if (minecraftItemId != null) {
                Item item = minecraftItemId.get(1);
                if (meta.isPresent()) {
                    int damage = meta.getAsInt();
                    if (damage < 0) {
                        item = item.createFuzzyCraftingRecipe();
                    } else {
                        item.setDamage(damage);
                    }
                }
                return item;
            }
            if (namespaceGroup != null && !namespaceGroup.equals("minecraft:")) {
                return Item.get(0);
            }
        } else if (numericIdGroup != null) {
            int id = Integer.parseInt(numericIdGroup);
            return Item.get(id, meta.orElse(0));
        }
        if (name == null) {
            return Item.get(0);
        }
        int id = 0;
        try {
            id = ItemID.class.getField(name.toUpperCase()).getInt(null);
        }
        catch (Exception ignore1) {
            try {
                id = BlockID.class.getField(name.toUpperCase()).getInt(null);
                if (id > 255) {
                    id = 255 - id;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Item.get(id, meta.orElse(0));
    }

    public static Item fromJson(Map<String, Object> data) {
        return Item.fromJson(data, false);
    }

    private static Item fromJson(Map<String, Object> data, boolean ignoreNegativeItemId) {
        String nbt = (String)data.get("nbt_b64");
        byte[] nbtBytes = nbt != null ? Base64.getDecoder().decode(nbt) : ((nbt = (String)data.getOrDefault("nbt_hex", null)) == null ? EmptyArrays.EMPTY_BYTES : Utils.parseHexBinary(nbt));
        int id = Utils.toInt(data.get("id"));
        if (ignoreNegativeItemId && id < 0) {
            return null;
        }
        return Item.get(id, Utils.toInt(data.getOrDefault("damage", 0)), Utils.toInt(data.getOrDefault("count", 1)), nbtBytes);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static Item fromJsonNetworkId(Map<String, Object> data) {
        OptionalInt meta;
        String nbt = (String)data.get("nbt_b64");
        byte[] nbtBytes = nbt != null ? Base64.getDecoder().decode(nbt) : ((nbt = (String)data.getOrDefault("nbt_hex", null)) == null ? EmptyArrays.EMPTY_BYTES : Utils.parseHexBinary(nbt));
        int networkId = Utils.toInt(data.get("id"));
        RuntimeItemMapping mapping = RuntimeItems.getRuntimeMapping();
        int legacyFullId = mapping.getLegacyFullId(networkId);
        int id = RuntimeItems.getId(legacyFullId);
        OptionalInt optionalInt = meta = RuntimeItems.hasData(legacyFullId) ? OptionalInt.of(RuntimeItems.getData(legacyFullId)) : OptionalInt.empty();
        if (data.containsKey("damage")) {
            int jsonMeta = Utils.toInt(data.get("damage"));
            if (jsonMeta != Short.MAX_VALUE) {
                if (meta.isPresent() && jsonMeta != meta.getAsInt()) {
                    throw new IllegalArgumentException("Conflicting damage value for " + mapping.getNamespacedIdByNetworkId(networkId) + ". From json: " + jsonMeta + ", from mapping: " + meta.getAsInt());
                }
                meta = OptionalInt.of(jsonMeta);
            } else if (!meta.isPresent()) {
                meta = OptionalInt.of(-1);
            }
        }
        return Item.get(id, meta.orElse(0), Utils.toInt(data.getOrDefault("count", 1)), nbtBytes);
    }

    public static Item[] fromStringMultiple(String str) {
        String[] b = str.split(",");
        Item[] items = new Item[b.length - 1];
        for (int i = 0; i < b.length; ++i) {
            items[i] = Item.fromString(b[i]);
        }
        return items;
    }

    public Item setCompoundTag(CompoundTag tag) {
        this.setNamedTag(tag);
        return this;
    }

    public Item setCompoundTag(byte[] tags) {
        this.tags = tags;
        this.cachedNBT = null;
        return this;
    }

    public byte[] getCompoundTag() {
        return this.tags;
    }

    public boolean hasCompoundTag() {
        return this.tags != null && this.tags.length > 0;
    }

    public boolean hasCustomBlockData() {
        if (!this.hasCompoundTag()) {
            return false;
        }
        CompoundTag tag = this.getNamedTag();
        return tag.contains("BlockEntityTag") && tag.get("BlockEntityTag") instanceof CompoundTag;
    }

    public Item clearCustomBlockData() {
        if (!this.hasCompoundTag()) {
            return this;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("BlockEntityTag") && tag.get("BlockEntityTag") instanceof CompoundTag) {
            tag.remove("BlockEntityTag");
            this.setNamedTag(tag);
        }
        return this;
    }

    public Item setCustomBlockData(CompoundTag compoundTag) {
        CompoundTag tags = compoundTag.copy();
        tags.setName("BlockEntityTag");
        CompoundTag tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag();
        tag.putCompound("BlockEntityTag", tags);
        this.setNamedTag(tag);
        return this;
    }

    public CompoundTag getCustomBlockData() {
        Tag bet;
        if (!this.hasCompoundTag()) {
            return null;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("BlockEntityTag") && (bet = tag.get("BlockEntityTag")) instanceof CompoundTag) {
            return (CompoundTag)bet;
        }
        return null;
    }

    public boolean hasEnchantments() {
        if (!this.hasCompoundTag()) {
            return false;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("ench")) {
            Tag enchTag = tag.get("ench");
            return enchTag instanceof ListTag;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean hasEnchantment(int id) {
        return this.getEnchantmentLevel(id) > 0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getEnchantmentLevel(int id) {
        if (!this.hasEnchantments()) {
            return 0;
        }
        for (CompoundTag entry : this.getNamedTag().getList("ench", CompoundTag.class).getAll()) {
            if (entry.getShort("id") != id) continue;
            return entry.getShort("lvl");
        }
        return 0;
    }

    public Enchantment getEnchantment(int id) {
        return this.getEnchantment((short)(id & 0xFFFF));
    }

    public Enchantment getEnchantment(short id) {
        if (!this.hasEnchantments()) {
            return null;
        }
        for (CompoundTag entry : this.getNamedTag().getList("ench", CompoundTag.class).getAll()) {
            Enchantment e;
            if (entry.getShort("id") != id || (e = Enchantment.getEnchantment(entry.getShort("id"))) == null) continue;
            e.setLevel(entry.getShort("lvl"), false);
            return e;
        }
        return null;
    }

    public void addEnchantment(Enchantment ... enchantments) {
        ListTag<Object> ench;
        CompoundTag tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag();
        if (!tag.contains("ench")) {
            ench = new ListTag("ench");
            tag.putList(ench);
        } else {
            ench = tag.getList("ench", CompoundTag.class);
        }
        for (Enchantment enchantment : enchantments) {
            boolean found = false;
            for (int k = 0; k < ench.size(); ++k) {
                CompoundTag entry = (CompoundTag)ench.get(k);
                if (entry.getShort("id") != enchantment.getId()) continue;
                ench.add(k, new CompoundTag().putShort("id", enchantment.getId()).putShort("lvl", enchantment.getLevel()));
                found = true;
                break;
            }
            if (found) continue;
            ench.add(new CompoundTag().putShort("id", enchantment.getId()).putShort("lvl", enchantment.getLevel()));
        }
        this.setNamedTag(tag);
    }

    public Enchantment[] getEnchantments() {
        if (!this.hasEnchantments()) {
            return Enchantment.EMPTY_ARRAY;
        }
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        ListTag<CompoundTag> ench = this.getNamedTag().getList("ench", CompoundTag.class);
        for (CompoundTag entry : ench.getAll()) {
            Enchantment e = Enchantment.getEnchantment(entry.getShort("id"));
            if (e == null) continue;
            e.setLevel(entry.getShort("lvl"), false);
            enchantments.add(e);
        }
        return enchantments.toArray(Enchantment.EMPTY_ARRAY);
    }

    @Since(value="1.4.0.0-PN")
    public int getRepairCost() {
        Tag repairCost;
        CompoundTag tag;
        if (this.hasCompoundTag() && (tag = this.getNamedTag()).contains("RepairCost") && (repairCost = tag.get("RepairCost")) instanceof IntTag) {
            return ((IntTag)repairCost).data;
        }
        return 0;
    }

    @Since(value="1.4.0.0-PN")
    public Item setRepairCost(int cost) {
        if (cost <= 0 && this.hasCompoundTag()) {
            return this.setNamedTag(this.getNamedTag().remove("RepairCost"));
        }
        CompoundTag tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag();
        return this.setNamedTag(tag.putInt("RepairCost", cost));
    }

    public boolean hasCustomName() {
        if (!this.hasCompoundTag()) {
            return false;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("display")) {
            Tag tag1 = tag.get("display");
            return tag1 instanceof CompoundTag && ((CompoundTag)tag1).contains("Name") && ((CompoundTag)tag1).get("Name") instanceof StringTag;
        }
        return false;
    }

    public String getCustomName() {
        Tag tag1;
        if (!this.hasCompoundTag()) {
            return "";
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("display") && (tag1 = tag.get("display")) instanceof CompoundTag && ((CompoundTag)tag1).contains("Name") && ((CompoundTag)tag1).get("Name") instanceof StringTag) {
            return ((CompoundTag)tag1).getString("Name");
        }
        return "";
    }

    public Item setCustomName(String name) {
        CompoundTag tag;
        if (name == null || name.equals("")) {
            this.clearCustomName();
        }
        if ((tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag()).contains("display") && tag.get("display") instanceof CompoundTag) {
            tag.getCompound("display").putString("Name", name);
        } else {
            tag.putCompound("display", new CompoundTag("display").putString("Name", name));
        }
        this.setNamedTag(tag);
        return this;
    }

    public Item clearCustomName() {
        if (!this.hasCompoundTag()) {
            return this;
        }
        CompoundTag tag = this.getNamedTag();
        if (tag.contains("display") && tag.get("display") instanceof CompoundTag) {
            tag.getCompound("display").remove("Name");
            if (tag.getCompound("display").isEmpty()) {
                tag.remove("display");
            }
            this.setNamedTag(tag);
        }
        return this;
    }

    public String[] getLore() {
        CompoundTag nbt;
        ListTag<StringTag> lore;
        Tag tag = this.getNamedTagEntry("display");
        ArrayList<String> lines = new ArrayList<String>();
        if (tag instanceof CompoundTag && (lore = (nbt = (CompoundTag)tag).getList("Lore", StringTag.class)).size() > 0) {
            for (StringTag stringTag : lore.getAll()) {
                lines.add(stringTag.data);
            }
        }
        return lines.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    public Item setLore(String ... lines) {
        CompoundTag tag = !this.hasCompoundTag() ? new CompoundTag() : this.getNamedTag();
        ListTag<StringTag> lore = new ListTag<StringTag>("Lore");
        for (String line : lines) {
            lore.add(new StringTag("", line));
        }
        if (!tag.contains("display")) {
            tag.putCompound("display", new CompoundTag("display").putList(lore));
        } else {
            tag.getCompound("display").putList(lore);
        }
        this.setNamedTag(tag);
        return this;
    }

    public Tag getNamedTagEntry(String name) {
        CompoundTag tag = this.getNamedTag();
        if (tag != null) {
            return tag.contains(name) ? tag.get(name) : null;
        }
        return null;
    }

    public CompoundTag getNamedTag() {
        if (!this.hasCompoundTag()) {
            return null;
        }
        if (this.cachedNBT == null) {
            this.cachedNBT = Item.parseCompoundTag(this.tags);
        }
        if (this.cachedNBT != null) {
            this.cachedNBT.setName("");
        }
        return this.cachedNBT;
    }

    public Item setNamedTag(CompoundTag tag) {
        if (tag.isEmpty()) {
            return this.clearNamedTag();
        }
        tag.setName(null);
        this.cachedNBT = tag;
        this.tags = this.writeCompoundTag(tag);
        return this;
    }

    public Item clearNamedTag() {
        return this.setCompoundTag(EmptyArrays.EMPTY_BYTES);
    }

    public static CompoundTag parseCompoundTag(byte[] tag) {
        try {
            return NBTIO.read(tag, ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] writeCompoundTag(CompoundTag tag) {
        try {
            tag.setName("");
            return NBTIO.write(tag, ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isNull() {
        return this.count <= 0 || this.id == 0;
    }

    public final String getName() {
        return this.hasCustomName() ? this.getCustomName() : this.name;
    }

    public final boolean canBePlaced() {
        return this.block != null && this.block.canBePlaced();
    }

    public Block getBlock() {
        if (this.block != null) {
            return this.block.clone();
        }
        return Block.get(0);
    }

    @Since(value="1.4.0.0-PN")
    public Block getBlockUnsafe() {
        return this.block;
    }

    public int getId() {
        return this.id;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final int getNetworkFullId() throws UnknownNetworkIdException {
        try {
            return RuntimeItems.getRuntimeMapping().getNetworkFullId(this);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownNetworkIdException(this, (Throwable)e);
        }
    }

    @Since(value="1.4.0.0-PN")
    public final int getNetworkId() throws UnknownNetworkIdException {
        return RuntimeItems.getNetworkId(this.getNetworkFullId());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getNamespaceId() {
        RuntimeItemMapping runtimeMapping = RuntimeItems.getRuntimeMapping();
        return runtimeMapping.getNamespacedIdByNetworkId(RuntimeItems.getNetworkId(runtimeMapping.getNetworkFullId(this)));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getBlockId() {
        if (this.block != null) {
            return this.block.getId();
        }
        return -1;
    }

    public int getDamage() {
        return this.meta;
    }

    public void setDamage(Integer meta) {
        if (meta != null) {
            this.meta = meta & 0xFFFF;
        } else {
            this.hasMeta = false;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item createFuzzyCraftingRecipe() {
        Item item = this.clone();
        item.hasMeta = false;
        return item;
    }

    public int getMaxStackSize() {
        return this.block == null ? 64 : this.block.getItemMaxStackSize();
    }

    public final Short getFuelTime() {
        if (!Fuel.duration.containsKey(this.id)) {
            return null;
        }
        if (this.id != 325 || this.meta == 10) {
            return Fuel.duration.get(this.id);
        }
        return null;
    }

    public boolean useOn(Entity entity) {
        return false;
    }

    public boolean useOn(Block block) {
        return false;
    }

    public boolean isTool() {
        return false;
    }

    public int getMaxDurability() {
        return -1;
    }

    public int getTier() {
        return 0;
    }

    public boolean isPickaxe() {
        return false;
    }

    public boolean isAxe() {
        return false;
    }

    public boolean isSword() {
        return false;
    }

    public boolean isShovel() {
        return false;
    }

    public boolean isHoe() {
        return false;
    }

    public boolean isShears() {
        return false;
    }

    public boolean isArmor() {
        return false;
    }

    public boolean isHelmet() {
        return false;
    }

    public boolean isChestplate() {
        return false;
    }

    public boolean isLeggings() {
        return false;
    }

    public boolean isBoots() {
        return false;
    }

    public int getEnchantAbility() {
        return 0;
    }

    public int getAttackDamage() {
        return 1;
    }

    public int getArmorPoints() {
        return 0;
    }

    public int getToughness() {
        return 0;
    }

    public boolean isUnbreakable() {
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isLavaResistant() {
        return false;
    }

    public boolean onUse(Player player, int ticksUsed) {
        return false;
    }

    public boolean onRelease(Player player, int ticksUsed) {
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean damageWhenBreaking() {
        return true;
    }

    public final String toString() {
        return "Item " + this.name + " (" + this.id + ":" + (!this.hasMeta ? "?" : Integer.valueOf(this.meta)) + ")x" + this.count + (this.hasCompoundTag() ? " tags:0x" + Binary.bytesToHexString(this.getCompoundTag()) : "");
    }

    public int getDestroySpeed(Block block, Player player) {
        return 1;
    }

    public boolean onActivate(cn.nukkit.level.Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final Item decrement(int amount) {
        return this.increment(-amount);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final Item increment(int amount) {
        if (this.count + amount <= 0) {
            return Item.getBlock(0);
        }
        Item cloned = this.clone();
        cloned.count += amount;
        return cloned;
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isFertilizer() {
        return false;
    }

    public boolean onClickAir(Player player, Vector3 directionVector) {
        return false;
    }

    public final boolean equals(Object item) {
        return item instanceof Item && this.equals((Item)item, true);
    }

    public final boolean equals(Item item, boolean checkDamage) {
        return this.equals(item, checkDamage, true);
    }

    public final boolean equals(Item item, boolean checkDamage, boolean checkCompound) {
        if (!(this.getId() != item.getId() || checkDamage && this.getDamage() != item.getDamage())) {
            if (checkCompound) {
                if (Arrays.equals(this.getCompoundTag(), item.getCompoundTag())) {
                    return true;
                }
                if (this.hasCompoundTag() && item.hasCompoundTag()) {
                    return this.getNamedTag().equals(item.getNamedTag());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public final boolean equalsExact(Item other) {
        return this.equals(other, true, true) && this.count == other.count;
    }

    public final boolean equalsIgnoringEnchantmentOrder(Item item, boolean checkDamage) {
        CompoundTag tag;
        int i;
        CompoundTag otherTags;
        if (!this.equals(item, checkDamage, false)) {
            return false;
        }
        if (Arrays.equals(this.getCompoundTag(), item.getCompoundTag())) {
            return true;
        }
        if (!this.hasCompoundTag() || !item.hasCompoundTag()) {
            return false;
        }
        CompoundTag thisTags = this.getNamedTag();
        if (thisTags.equals(otherTags = item.getNamedTag())) {
            return true;
        }
        if (!(thisTags.contains("ench") && otherTags.contains("ench") && thisTags.get("ench") instanceof ListTag && otherTags.get("ench") instanceof ListTag && thisTags.getList("ench").size() == otherTags.getList("ench").size())) {
            return false;
        }
        ListTag<CompoundTag> thisEnchantmentTags = thisTags.getList("ench", CompoundTag.class);
        ListTag<CompoundTag> otherEnchantmentTags = otherTags.getList("ench", CompoundTag.class);
        int size = thisEnchantmentTags.size();
        Int2IntArrayMap enchantments = new Int2IntArrayMap(size);
        enchantments.defaultReturnValue(Integer.MIN_VALUE);
        for (i = 0; i < size; ++i) {
            tag = thisEnchantmentTags.get(i);
            enchantments.put(tag.getShort("id"), tag.getShort("lvl"));
        }
        for (i = 0; i < size; ++i) {
            tag = otherEnchantmentTags.get(i);
            if (enchantments.get(tag.getShort("id")) == tag.getShort("lvl")) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public final boolean deepEquals(Item item) {
        return this.equals(item, true);
    }

    @Deprecated
    public final boolean deepEquals(Item item, boolean checkDamage) {
        return this.equals(item, checkDamage, true);
    }

    @Deprecated
    public final boolean deepEquals(Item item, boolean checkDamage, boolean checkCompound) {
        return this.equals(item, checkDamage, checkCompound);
    }

    public Item clone() {
        try {
            Item item = (Item)super.clone();
            item.tags = (byte[])this.tags.clone();
            item.cachedNBT = null;
            return item;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    static {
        creative = new ArrayList();
    }
}

