/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTNT;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityShulkerBox;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityExplosive;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.item.EntityXPOrb;
import cn.nukkit.event.block.BlockExplodeEvent;
import cn.nukkit.event.block.BlockUpdateEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityExplodeEvent;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.HugeExplodeSeedParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Hash;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class Explosion {
    private final int rays = 16;
    private final Level level;
    private final Position source;
    private final double size;
    private double fireChance;
    private Set<Block> affectedBlocks;
    private Set<Block> fireIgnitions;
    private final double stepLen = 0.3;
    private final Object what;
    private boolean doesDamage = true;

    public Explosion(Position center, double size, Entity what) {
        this(center, size, (Object)what);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Explosion(Position center, double size, Block what) {
        this(center, size, (Object)what);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected Explosion(Position center, double size, Object what) {
        this.level = center.getLevel();
        this.source = center;
        this.size = Math.max(size, 0.0);
        this.what = what;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setFireChance(double fireChance) {
        this.fireChance = fireChance;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public double getFireChance() {
        return this.fireChance;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isIncendiary() {
        return this.fireChance > 0.0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setIncendiary(boolean incendiary) {
        if (!incendiary) {
            this.fireChance = 0.0;
        } else if (this.fireChance <= 0.0) {
            this.fireChance = 0.3333333333333333;
        }
    }

    public boolean explode() {
        if (this.explodeA()) {
            return this.explodeB();
        }
        return false;
    }

    public boolean explodeA() {
        boolean incendiary;
        Entity entity;
        int block;
        if (this.what instanceof EntityExplosive && ((block = this.level.getBlockIdAt((entity = (Entity)this.what).getFloorX(), entity.getFloorY(), entity.getFloorZ())) == 8 || block == 9 || (block = this.level.getBlockIdAt(entity.getFloorX(), entity.getFloorY(), entity.getFloorZ(), 1)) == 8 || block == 9)) {
            this.doesDamage = false;
            return true;
        }
        if (this.size < 0.1) {
            return false;
        }
        if (this.affectedBlocks == null) {
            this.affectedBlocks = new LinkedHashSet<Block>();
        }
        boolean bl = incendiary = this.fireChance > 0.0;
        if (incendiary && this.fireIgnitions == null) {
            this.fireIgnitions = new LinkedHashSet<Block>();
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Vector3 vector = new Vector3(0.0, 0.0, 0.0);
        Vector3 vBlock = new Vector3(0.0, 0.0, 0.0);
        int mRays = this.rays - 1;
        for (int i = 0; i < this.rays; ++i) {
            for (int j = 0; j < this.rays; ++j) {
                block2: for (int k = 0; k < this.rays; ++k) {
                    if (i != 0 && i != mRays && j != 0 && j != mRays && k != 0 && k != mRays) continue;
                    vector.setComponents((double)i / (double)mRays * 2.0 - 1.0, (double)j / (double)mRays * 2.0 - 1.0, (double)k / (double)mRays * 2.0 - 1.0);
                    double len = vector.length();
                    vector.setComponents(vector.x / len * this.stepLen, vector.y / len * this.stepLen, vector.z / len * this.stepLen);
                    double pointerX = this.source.x;
                    double pointerY = this.source.y;
                    double pointerZ = this.source.z;
                    for (double blastForce = this.size * (double)random.nextInt(700, 1301) / 1000.0; blastForce > 0.0; blastForce -= this.stepLen * 0.75) {
                        int x = (int)pointerX;
                        int y = (int)pointerY;
                        int z = (int)pointerZ;
                        vBlock.x = pointerX >= (double)x ? (double)x : (double)(x - 1);
                        vBlock.y = pointerY >= (double)y ? (double)y : (double)(y - 1);
                        double d = vBlock.z = pointerZ >= (double)z ? (double)z : (double)(z - 1);
                        if (vBlock.y < 0.0 || vBlock.y > 255.0) continue block2;
                        Block block2 = this.level.getBlock(vBlock);
                        if (block2.getId() != 0) {
                            Block layer1 = block2.getLevelBlockAtLayer(1);
                            double resistance = Math.max(block2.getResistance(), layer1.getResistance());
                            if ((blastForce -= (resistance / 5.0 + 0.3) * this.stepLen) > 0.0 && this.affectedBlocks.add(block2)) {
                                if (incendiary && random.nextDouble() <= this.fireChance) {
                                    this.fireIgnitions.add(block2);
                                }
                                if (layer1.getId() != 0) {
                                    this.affectedBlocks.add(layer1);
                                }
                            }
                        }
                        pointerX += vector.x;
                        pointerY += vector.y;
                        pointerZ += vector.z;
                    }
                }
            }
        }
        return true;
    }

    @PowerNukkitDifference(info="Using new method to play sounds", since="1.4.0.0-PN")
    public boolean explodeB() {
        Entity[] list;
        LongArraySet updateBlocks = new LongArraySet();
        ArrayList<Vector3> send = new ArrayList<Vector3>();
        Vector3 source = new Vector3(this.source.x, this.source.y, this.source.z).floor();
        double yield = 1.0 / this.size * 100.0;
        if (this.affectedBlocks == null) {
            this.affectedBlocks = new LinkedHashSet<Block>();
        }
        if (this.what instanceof Entity) {
            ArrayList<Block> affectedBlocksList = new ArrayList<Block>(this.affectedBlocks);
            EntityExplodeEvent ev = new EntityExplodeEvent((Entity)this.what, this.source, affectedBlocksList, yield);
            ev.setIgnitions((Set<Block>)(this.fireIgnitions == null ? new LinkedHashSet(0) : this.fireIgnitions));
            this.level.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            yield = ev.getYield();
            this.affectedBlocks.clear();
            this.affectedBlocks.addAll(ev.getBlockList());
            this.fireIgnitions = ev.getIgnitions();
        } else if (this.what instanceof Block) {
            BlockExplodeEvent ev = new BlockExplodeEvent((Block)this.what, this.source, this.affectedBlocks, this.fireIgnitions == null ? new LinkedHashSet(0) : this.fireIgnitions, yield, this.fireChance);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            yield = ev.getYield();
            this.affectedBlocks = ev.getAffectedBlocks();
            this.fireIgnitions = ev.getIgnitions();
        }
        double explosionSize = this.size * 2.0;
        double minX = NukkitMath.floorDouble(this.source.x - explosionSize - 1.0);
        double maxX = NukkitMath.ceilDouble(this.source.x + explosionSize + 1.0);
        double minY = NukkitMath.floorDouble(this.source.y - explosionSize - 1.0);
        double maxY = NukkitMath.ceilDouble(this.source.y + explosionSize + 1.0);
        double minZ = NukkitMath.floorDouble(this.source.z - explosionSize - 1.0);
        double maxZ = NukkitMath.ceilDouble(this.source.z + explosionSize + 1.0);
        SimpleAxisAlignedBB explosionBB = new SimpleAxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        for (Entity entity : list = this.level.getNearbyEntities(explosionBB, this.what instanceof Entity ? (Entity)this.what : null)) {
            int damage;
            double distance = entity.distance(this.source) / explosionSize;
            if (!(distance <= 1.0)) continue;
            Vector3 motion = entity.subtract(this.source).normalize();
            boolean exposure = true;
            double impact = (1.0 - distance) * (double)exposure;
            int n = damage = this.doesDamage ? (int)((impact * impact + impact) / 2.0 * 8.0 * explosionSize + 1.0) : 0;
            if (this.what instanceof Entity) {
                entity.attack(new EntityDamageByEntityEvent((Entity)this.what, entity, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, damage));
            } else if (this.what instanceof Block) {
                entity.attack(new EntityDamageByBlockEvent((Block)this.what, entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, damage));
            } else {
                entity.attack(new EntityDamageEvent(entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, damage));
            }
            if (entity instanceof EntityItem || entity instanceof EntityXPOrb) continue;
            entity.setMotion(motion.multiply(impact));
        }
        ItemBlock air = new ItemBlock(Block.get(0));
        for (Block block : this.affectedBlocks) {
            if (block.getId() == 46) {
                ((BlockTNT)block).prime(new NukkitRandom().nextRange(10, 30), this.what instanceof Entity ? (Entity)this.what : null);
            } else {
                BlockEntity container = block.getLevel().getBlockEntity(block);
                if (container instanceof InventoryHolder) {
                    if (container instanceof BlockEntityShulkerBox) {
                        this.level.dropItem(block.add(0.5, 0.5, 0.5), block.toItem());
                        ((InventoryHolder)((Object)container)).getInventory().clearAll();
                    } else {
                        for (Item drop : ((InventoryHolder)((Object)container)).getInventory().getContents().values()) {
                            this.level.dropItem(block.add(0.5, 0.5, 0.5), drop);
                        }
                        ((InventoryHolder)((Object)container)).getInventory().clearAll();
                    }
                } else if (Math.random() * 100.0 < yield) {
                    for (Item drop : block.getDrops(air)) {
                        this.level.dropItem(block.add(0.5, 0.5, 0.5), drop);
                    }
                }
            }
            this.level.setBlockAtLayer((int)block.x, (int)block.y, (int)block.z, block.layer, 0);
            if (block.layer != 0) continue;
            Vector3 pos = new Vector3(block.x, block.y, block.z);
            for (BlockFace side : BlockFace.values()) {
                Block layer1;
                Vector3 sideBlock = pos.getSide(side);
                long index = Hash.hashBlock((int)sideBlock.x, (int)sideBlock.y, (int)sideBlock.z);
                if (this.affectedBlocks.contains(sideBlock) || updateBlocks.contains(index)) continue;
                BlockUpdateEvent ev = new BlockUpdateEvent(this.level.getBlock(sideBlock));
                this.level.getServer().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    ev.getBlock().onUpdate(1);
                }
                if ((layer1 = this.level.getBlock(sideBlock, 1)).getId() != 0) {
                    ev = new BlockUpdateEvent(layer1);
                    this.level.getServer().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        ev.getBlock().onUpdate(1);
                    }
                }
                updateBlocks.add(index);
            }
            send.add(new Vector3(block.x - source.x, block.y - source.y, block.z - source.z));
        }
        for (Vector3 vector3 : this.fireIgnitions) {
            Block toIgnite = this.level.getBlock(vector3);
            if (toIgnite.getId() != 0 || !toIgnite.down().isSolid(BlockFace.UP)) continue;
            this.level.setBlock(toIgnite, Block.get(51));
        }
        this.level.addParticle(new HugeExplodeSeedParticle(this.source));
        this.level.addSound(source, Sound.RANDOM_EXPLODE);
        return true;
    }
}

