/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.impl.extremehills;

import cn.nukkit.api.NewRakNetOnly;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.biome.impl.extremehills.ExtremeHillsPlusBiome;
import cn.nukkit.level.generator.noise.nukkit.f.SimplexF;
import cn.nukkit.math.NukkitRandom;

public class ExtremeHillsMBiome
extends ExtremeHillsPlusBiome {
    private static final BlockState STATE_GRAVEL = BlockState.of(13);
    private static final BlockState STATE_GRASS = BlockState.of(2);
    private static final SimplexF gravelNoise = new SimplexF(new NukkitRandom(0L), 1.0f, 0.25f, 0.015625f);

    public ExtremeHillsMBiome() {
        this(true);
    }

    public ExtremeHillsMBiome(boolean tree) {
        super(tree);
        this.setBaseHeight(1.0f);
        this.setHeightVariation(0.5f);
    }

    @Override
    public String getName() {
        return "Extreme Hills M";
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getSurfaceState(int x, int y, int z) {
        return gravelNoise.noise2D(x, z, true) < -0.75f ? STATE_GRAVEL : STATE_GRASS;
    }

    @Override
    @NewRakNetOnly
    public int getSurfaceDepth(int x, int y, int z) {
        return gravelNoise.noise2D(x, z, true) < -0.75f ? 4 : 1;
    }

    @Override
    @NewRakNetOnly
    public int getGroundDepth(int x, int y, int z) {
        return gravelNoise.noise2D(x, z, true) < -0.75f ? 0 : 4;
    }

    @Override
    public boolean doesOverhang() {
        return false;
    }
}

