/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BinaryStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface ChunkSection {
    public int getY();

    public int getBlockId(int var1, int var2, int var3);

    @PowerNukkitOnly
    public int getBlockId(int var1, int var2, int var3, int var4);

    public void setBlockId(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    public int getBlockData(int var1, int var2, int var3);

    @PowerNukkitOnly
    public int getBlockData(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    public void setBlockData(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockData(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public int getFullBlock(int var1, int var2, int var3);

    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public int getFullBlock(int var1, int var2, int var3, int var4);

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BlockState getBlockState(int x, int y, int z) {
        return this.getBlockState(x, y, z, 0);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BlockState getBlockState(int x, int y, int z, int layer) {
        return BlockState.of(this.getBlockId(x, y, z, layer), this.getBlockData(x, y, z, layer));
    }

    @Deprecated
    @Nonnull
    @DeprecationDetails(since="1.4.0.0-PN", reason="If the stored state is invalid, returns a BlockUnknown", replaceWith="getAndSetBlockState")
    @PowerNukkitOnly
    public Block getAndSetBlock(int var1, int var2, int var3, int var4, Block var5);

    @Deprecated
    @Nonnull
    @DeprecationDetails(since="1.4.0.0-PN", reason="If the stored state is invalid, returns a BlockUnknown", replaceWith="getAndSetBlockState")
    public Block getAndSetBlock(int var1, int var2, int var3, Block var4);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getAndSetBlockState(int var1, int var2, int var3, int var4, BlockState var5);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BlockState getAndSetBlockState(int x, int y, int z, BlockState state) {
        return this.getAndSetBlockState(x, y, z, 0, state);
    }

    @PowerNukkitOnly
    public void setBlockId(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN", replaceWith="setBlockState(int x, int y, int z, BlockState state)")
    public boolean setFullBlockId(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN", replaceWith="setBlockStateAtLayer(int x, int y, int z, int layer, BlockState state)")
    public boolean setFullBlockId(int var1, int var2, int var3, int var4, int var5);

    @PowerNukkitOnly
    public boolean setBlockAtLayer(int var1, int var2, int var3, int var4, int var5);

    public boolean setBlock(int var1, int var2, int var3, int var4);

    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    public boolean setBlock(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @DeprecationDetails(reason="The data is limited to 32 bits", replaceWith="getBlockState", since="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean setBlockAtLayer(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getBlockSkyLight(int var1, int var2, int var3);

    public void setBlockSkyLight(int var1, int var2, int var3, int var4);

    public int getBlockLight(int var1, int var2, int var3);

    public void setBlockLight(int var1, int var2, int var3, int var4);

    public byte[] getSkyLightArray();

    public byte[] getLightArray();

    public boolean isEmpty();

    @Since(value="1.4.0.0-PN")
    public void writeTo(BinaryStream var1);

    @PowerNukkitOnly
    public int getMaximumLayer();

    @Nonnull
    @PowerNukkitOnly
    public CompoundTag toNBT();

    @Nonnull
    public ChunkSection copy();

    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.0.0-PN")
    default public int getContentVersion() {
        return 0;
    }

    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.1.0-PN")
    default public void setContentVersion(int contentVersion) {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean hasBlocks() {
        return !this.isEmpty();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setBlockStateAtLayer(int var1, int var2, int var3, int var4, BlockState var5);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean setBlockState(int x, int y, int z, BlockState state) {
        return this.setBlockStateAtLayer(x, y, z, 0, state);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getBlockChangeStateAbove(int var1, int var2, int var3);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void delayPaletteUpdates() {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public List<Block> scanBlocks(LevelProvider provider, int offsetX, int offsetZ, BlockVector3 min, BlockVector3 max, BiPredicate<BlockVector3, BlockState> condition) {
        int offsetY = this.getY() << 4;
        ArrayList<Block> results = new ArrayList<Block>();
        BlockVector3 current = new BlockVector3();
        int minX = Math.max(0, min.x - offsetX);
        int minY = Math.max(0, min.y - offsetY);
        int minZ = Math.max(0, min.z - offsetZ);
        for (int x = Math.min(max.x - offsetX, 15); x >= minX; --x) {
            current.x = offsetX + x;
            for (int z = Math.min(max.z - offsetZ, 15); z >= minZ; --z) {
                current.z = offsetZ + z;
                for (int y = Math.min(max.y - offsetY, 15); y >= minY; --y) {
                    current.y = offsetY + y;
                    BlockState state = this.getBlockState(x, y, z);
                    if (!condition.test(current, state)) continue;
                    results.add(state.getBlockRepairing(provider.getLevel(), current, 0));
                }
            }
        }
        return results;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void compressStorageLayers() {
    }
}

