/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.anvil.Chunk;
import cn.nukkit.level.format.anvil.RegionLoader;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.BaseLevelProvider;
import cn.nukkit.level.format.generic.BaseRegionLoader;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.ThreadCache;
import cn.nukkit.utils.Utils;
import io.netty.util.internal.EmptyArrays;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Anvil
extends BaseLevelProvider {
    private static final Logger log = LogManager.getLogger(Anvil.class);
    public static final int VERSION = 19133;
    private static final byte[] PAD_256 = new byte[256];
    private int lastPosition = 0;

    public Anvil(Level level, String path) throws IOException {
        super(level, path);
    }

    public static String getProviderName() {
        return "anvil";
    }

    public static byte getProviderOrder() {
        return 0;
    }

    public static boolean usesChunkSection() {
        return true;
    }

    public static boolean isValid(String path) {
        boolean isValid;
        boolean bl = isValid = new File(path + "/level.dat").exists() && new File(path + "/region/").isDirectory();
        if (isValid) {
            for (File file : new File(path + "/region/").listFiles((dir, name) -> Pattern.matches("^.+\\.mc[r|a]$", name))) {
                if (file.getName().endsWith(".mca")) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    public static void generate(String path, String name, long seed, Class<? extends Generator> generator) throws IOException {
        Anvil.generate(path, name, seed, generator, new HashMap<String, String>());
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed resource leak")
    public static void generate(String path, String name, long seed, Class<? extends Generator> generator, Map<String, String> options) throws IOException {
        File regionDir = new File(path + "/region");
        if (!regionDir.exists() && !regionDir.mkdirs()) {
            throw new IOException("Could not create the directory " + regionDir);
        }
        CompoundTag levelData = new CompoundTag("Data").putCompound("GameRules", new CompoundTag()).putLong("DayTime", 0L).putInt("GameType", 0).putString("generatorName", Generator.getGeneratorName(generator)).putString("generatorOptions", options.getOrDefault("preset", "")).putInt("generatorVersion", 1).putBoolean("hardcore", false).putBoolean("initialized", true).putLong("LastPlayed", System.currentTimeMillis() / 1000L).putString("LevelName", name).putBoolean("raining", false).putInt("rainTime", 0).putLong("RandomSeed", seed).putInt("SpawnX", 128).putInt("SpawnY", 70).putInt("SpawnZ", 128).putBoolean("thundering", false).putInt("thunderTime", 0).putInt("version", 19133).putLong("Time", 0L).putLong("SizeOnDisk", 0L);
        Utils.safeWrite(new File(path, "level.dat"), file -> {
            try (FileOutputStream fos = new FileOutputStream((File)file);
                 BufferedOutputStream out = new BufferedOutputStream(fos);){
                NBTIO.writeGZIPCompressed(new CompoundTag().putCompound("Data", levelData), out, ByteOrder.BIG_ENDIAN);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public Chunk getEmptyChunk(int chunkX, int chunkZ) {
        return Chunk.getEmptyChunk(chunkX, chunkZ, this);
    }

    @Override
    public AsyncTask requestChunkTask(int x, int z) throws ChunkException {
        int i;
        Chunk chunk = (Chunk)this.getChunk(x, z, false);
        if (chunk == null) {
            throw new ChunkException("Invalid Chunk Set");
        }
        long timestamp = chunk.getChanges();
        byte[] blockEntities = EmptyArrays.EMPTY_BYTES;
        if (!chunk.getBlockEntities().isEmpty()) {
            ArrayList<CompoundTag> tagList = new ArrayList<CompoundTag>();
            for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                if (!(blockEntity instanceof BlockEntitySpawnable)) continue;
                tagList.add(((BlockEntitySpawnable)blockEntity).getSpawnCompound());
            }
            try {
                blockEntities = NBTIO.write(tagList, ByteOrder.LITTLE_ENDIAN, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        BinaryStream stream = ((BinaryStream)ThreadCache.binaryStream.get()).reset();
        int count = 0;
        ChunkSection[] sections = chunk.getSections();
        for (i = sections.length - 1; i >= 0; --i) {
            if (sections[i].isEmpty()) continue;
            count = i + 1;
            break;
        }
        for (i = 0; i < count; ++i) {
            sections[i].writeTo(stream);
        }
        stream.put(chunk.getBiomeIdArray());
        stream.putByte((byte)0);
        stream.put(blockEntities);
        this.getLevel().chunkRequestCallback(timestamp, x, z, count, stream.getBuffer());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGarbageCollection(long time) {
        int i;
        long start = System.currentTimeMillis();
        int maxIterations = this.size();
        if (this.lastPosition > maxIterations) {
            this.lastPosition = 0;
        }
        Long2ObjectMap long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            ObjectIterator iter = this.chunks.values().iterator();
            if (this.lastPosition != 0) {
                iter.skip(this.lastPosition);
            }
            for (i = 0; i < maxIterations; ++i) {
                if (!iter.hasNext()) {
                    iter = this.chunks.values().iterator();
                }
                if (!iter.hasNext()) break;
                BaseFullChunk chunk = (BaseFullChunk)iter.next();
                if (chunk == null || !chunk.isGenerated() || !chunk.isPopulated() || !(chunk instanceof Chunk)) continue;
                Chunk anvilChunk = (Chunk)chunk;
                chunk.compress();
                if (System.currentTimeMillis() - start >= time) break;
            }
        }
        this.lastPosition += i;
    }

    @Override
    public synchronized BaseFullChunk loadChunk(long index, int chunkX, int chunkZ, boolean create) {
        BaseFullChunk chunk;
        int regionX = Anvil.getRegionIndexX(chunkX);
        int regionZ = Anvil.getRegionIndexZ(chunkZ);
        BaseRegionLoader region = this.loadRegion(regionX, regionZ);
        this.level.timings.syncChunkLoadDataTimer.startTiming();
        try {
            chunk = region.readChunk(chunkX - regionX * 32, chunkZ - regionZ * 32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (chunk == null) {
            if (create) {
                chunk = this.getEmptyChunk(chunkX, chunkZ);
                this.putChunk(index, chunk);
            }
        } else {
            this.putChunk(index, chunk);
        }
        this.level.timings.syncChunkLoadDataTimer.stopTiming();
        return chunk;
    }

    @Override
    public synchronized void saveChunk(int X, int Z) {
        BaseFullChunk chunk = this.getChunk(X, Z);
        if (chunk != null) {
            try {
                this.loadRegion(X >> 5, Z >> 5).writeChunk(chunk);
            }
            catch (Exception e) {
                throw new ChunkException("Error saving chunk (" + X + ", " + Z + ")", e);
            }
        }
    }

    @Override
    public synchronized void saveChunk(int x, int z, FullChunk chunk) {
        if (!(chunk instanceof Chunk)) {
            throw new ChunkException("Invalid Chunk class");
        }
        int regionX = x >> 5;
        int regionZ = z >> 5;
        this.loadRegion(regionX, regionZ);
        chunk.setX(x);
        chunk.setZ(z);
        try {
            this.getRegion(regionX, regionZ).writeChunk(chunk);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static cn.nukkit.level.format.anvil.ChunkSection createChunkSection(int y) {
        cn.nukkit.level.format.anvil.ChunkSection cs = new cn.nukkit.level.format.anvil.ChunkSection(y);
        cs.hasSkyLight = true;
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized BaseRegionLoader loadRegion(int x, int z) {
        BaseRegionLoader tmp = (BaseRegionLoader)this.lastRegion.get();
        if (tmp != null && x == tmp.getX() && z == tmp.getZ()) {
            return tmp;
        }
        long index = Level.chunkHash(x, z);
        Long2ObjectMap long2ObjectMap = this.regions;
        synchronized (long2ObjectMap) {
            BaseRegionLoader region = (BaseRegionLoader)this.regions.get(index);
            if (region == null) {
                try {
                    region = new RegionLoader(this, x, z);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.regions.put(index, (Object)region);
            }
            this.lastRegion.set(region);
            return region;
        }
    }

    @Override
    public int getMaximumLayer() {
        return 1;
    }
}

