/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.palette;

import io.netty.util.internal.EmptyArrays;
import java.util.Arrays;

public class CharPalette {
    private char[] keys = EmptyArrays.EMPTY_CHARS;
    private char lastIndex = (char)65535;

    public void add(char key) {
        this.keys = this.insert(key);
        this.lastIndex = (char)65535;
    }

    protected void set(char[] keys) {
        this.keys = keys;
        this.lastIndex = (char)65535;
    }

    private char[] insert(char val) {
        this.lastIndex = (char)65535;
        if (this.keys.length == 0) {
            return new char[]{val};
        }
        if (val < this.keys[0]) {
            char[] s = new char[this.keys.length + 1];
            System.arraycopy(this.keys, 0, s, 1, this.keys.length);
            s[0] = val;
            return s;
        }
        if (val > this.keys[this.keys.length - 1]) {
            char[] s = Arrays.copyOf(this.keys, this.keys.length + 1);
            s[this.keys.length] = val;
            return s;
        }
        char[] s = Arrays.copyOf(this.keys, this.keys.length + 1);
        for (int i = 0; i < s.length; ++i) {
            if (this.keys[i] < val) continue;
            System.arraycopy(this.keys, i, s, i + 1, s.length - i - 1);
            s[i] = val;
            break;
        }
        return s;
    }

    public char getKey(int index) {
        return this.keys[index];
    }

    public char getValue(char key) {
        int index;
        boolean hasLast;
        char lastTmp = this.lastIndex;
        boolean bl = hasLast = lastTmp != '\uffff';
        if (hasLast) {
            char lastKey = this.keys[lastTmp];
            if (lastKey == key) {
                return lastTmp;
            }
            index = lastKey > key ? this.binarySearch0(0, lastTmp, key) : this.binarySearch0(lastTmp + '\u0001', this.keys.length, key);
        } else {
            index = this.binarySearch0(0, this.keys.length, key);
        }
        if (index >= this.keys.length || index < 0) {
            this.lastIndex = '\uffff';
            return '\uffff';
        }
        this.lastIndex = (char)index;
        return this.lastIndex;
    }

    private int binarySearch0(int fromIndex, int toIndex, char key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char midVal = this.keys[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

