/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.generic;

import cn.nukkit.Nukkit;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.level.GameRules;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.format.generic.BaseRegionLoader;
import cn.nukkit.level.generator.Generator;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.utils.ChunkException;
import cn.nukkit.utils.LevelException;
import cn.nukkit.utils.Utils;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLevelProvider
implements LevelProvider {
    private static final Logger log = LogManager.getLogger(BaseLevelProvider.class);
    protected Level level;
    protected final String path;
    protected CompoundTag levelData;
    private Vector3 spawn;
    protected final AtomicReference<BaseRegionLoader> lastRegion = new AtomicReference();
    protected final Long2ObjectMap<BaseRegionLoader> regions = new Long2ObjectOpenHashMap();
    protected final Long2ObjectMap<BaseFullChunk> chunks = new Long2ObjectOpenHashMap();
    private final AtomicReference<BaseFullChunk> lastChunk = new AtomicReference();

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed resource leak")
    public BaseLevelProvider(Level level, String path) throws IOException {
        CompoundTag levelData;
        this.level = level;
        this.path = path;
        File filePath = new File(this.path);
        if (!filePath.exists() && !filePath.mkdirs()) {
            throw new LevelException("Could not create the directory " + filePath);
        }
        File levelDatFile = new File(this.getPath(), "level.dat");
        try (FileInputStream fos = new FileInputStream(levelDatFile);
             BufferedInputStream input = new BufferedInputStream(fos);){
            levelData = NBTIO.readCompressed(input, ByteOrder.BIG_ENDIAN);
        }
        catch (Exception e) {
            log.fatal("Failed to load the level.dat file at {}, attempting to load level.dat_old instead!", (Object)levelDatFile.getAbsolutePath(), (Object)e);
            try {
                File old = new File(this.getPath(), "level.dat_old");
                if (!old.isFile()) {
                    log.fatal("The file {} does not exists!", (Object)old.getAbsolutePath());
                    FileNotFoundException ex = new FileNotFoundException("The file " + old.getAbsolutePath() + " does not exists!");
                    ex.addSuppressed(e);
                    throw ex;
                }
                try (FileInputStream fos2 = new FileInputStream(old);
                     BufferedInputStream input2 = new BufferedInputStream(fos2);){
                    levelData = NBTIO.readCompressed(input2, ByteOrder.BIG_ENDIAN);
                }
                catch (Exception e2) {
                    log.fatal("Failed to load the level.dat_old file at {}", (Object)levelDatFile.getAbsolutePath());
                    e2.addSuppressed(e);
                    throw e2;
                }
            }
            catch (Exception e2) {
                LevelException ex = new LevelException("Could not load the level.dat and the level.dat_old files. You might need to restore them from a backup!", e);
                ex.addSuppressed(e2);
                throw ex;
            }
        }
        if (!(levelData.get("Data") instanceof CompoundTag)) {
            throw new LevelException("Invalid level.dat");
        }
        this.levelData = levelData.getCompound("Data");
        if (!this.levelData.contains("generatorName")) {
            this.levelData.putString("generatorName", Generator.getGenerator("DEFAULT").getSimpleName().toLowerCase());
        }
        if (!this.levelData.contains("generatorOptions")) {
            this.levelData.putString("generatorOptions", "");
        }
        this.levelData.putList(new ListTag<StringTag>("ServerBrand").add(new StringTag("", Nukkit.CODENAME)));
        this.spawn = new Vector3(this.levelData.getInt("SpawnX"), this.levelData.getInt("SpawnY"), this.levelData.getInt("SpawnZ"));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BaseLevelProvider(Level level, String path, CompoundTag levelData, Vector3 spawn) {
        this.level = level;
        this.path = path;
        this.levelData = levelData;
        this.spawn = spawn;
    }

    public abstract BaseFullChunk loadChunk(long var1, int var3, int var4, boolean var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            return this.chunks.size();
        }
    }

    @Override
    public void unloadChunks() {
        ObjectIterator iter = this.chunks.values().iterator();
        while (iter.hasNext()) {
            ((BaseFullChunk)iter.next()).unload(true, false);
            iter.remove();
        }
    }

    @Override
    public String getGenerator() {
        return this.levelData.getString("generatorName");
    }

    @Override
    public Map<String, Object> getGeneratorOptions() {
        return new HashMap<String, Object>(){
            {
                this.put("preset", BaseLevelProvider.this.levelData.getString("generatorOptions"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, BaseFullChunk> getLoadedChunks() {
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            return ImmutableMap.copyOf(this.chunks);
        }
    }

    @Override
    public boolean isChunkLoaded(int X, int Z) {
        return this.isChunkLoaded(Level.chunkHash(X, Z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putChunk(long index, BaseFullChunk chunk) {
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            this.chunks.put(index, (Object)chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunkLoaded(long hash) {
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            return this.chunks.containsKey(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseRegionLoader getRegion(int x, int z) {
        long index = Level.chunkHash(x, z);
        Long2ObjectMap<BaseRegionLoader> long2ObjectMap = this.regions;
        synchronized (long2ObjectMap) {
            return (BaseRegionLoader)this.regions.get(index);
        }
    }

    protected static int getRegionIndexX(int chunkX) {
        return chunkX >> 5;
    }

    protected static int getRegionIndexZ(int chunkZ) {
        return chunkZ >> 5;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public Server getServer() {
        return this.level.getServer();
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getName() {
        return this.levelData.getString("LevelName");
    }

    @Override
    public boolean isRaining() {
        return this.levelData.getBoolean("raining");
    }

    @Override
    public void setRaining(boolean raining) {
        this.levelData.putBoolean("raining", raining);
    }

    @Override
    public int getRainTime() {
        return this.levelData.getInt("rainTime");
    }

    @Override
    public void setRainTime(int rainTime) {
        this.levelData.putInt("rainTime", rainTime);
    }

    @Override
    public boolean isThundering() {
        return this.levelData.getBoolean("thundering");
    }

    @Override
    public void setThundering(boolean thundering) {
        this.levelData.putBoolean("thundering", thundering);
    }

    @Override
    public int getThunderTime() {
        return this.levelData.getInt("thunderTime");
    }

    @Override
    public void setThunderTime(int thunderTime) {
        this.levelData.putInt("thunderTime", thunderTime);
    }

    @Override
    public long getCurrentTick() {
        return this.levelData.getLong("Time");
    }

    @Override
    public void setCurrentTick(long currentTick) {
        this.levelData.putLong("Time", currentTick);
    }

    @Override
    public long getTime() {
        return this.levelData.getLong("DayTime");
    }

    @Override
    public void setTime(long value) {
        this.levelData.putLong("DayTime", value);
    }

    @Override
    public long getSeed() {
        return this.levelData.getLong("RandomSeed");
    }

    @Override
    public void setSeed(long value) {
        this.levelData.putLong("RandomSeed", value);
    }

    @Override
    public Vector3 getSpawn() {
        return this.spawn;
    }

    @Override
    public void setSpawn(Vector3 pos) {
        this.levelData.putInt("SpawnX", (int)pos.x);
        this.levelData.putInt("SpawnY", (int)pos.y);
        this.levelData.putInt("SpawnZ", (int)pos.z);
        this.spawn = pos;
    }

    @Override
    public GameRules getGamerules() {
        GameRules rules = GameRules.getDefault();
        if (this.levelData.contains("GameRules")) {
            rules.readNBT(this.levelData.getCompound("GameRules"));
        }
        return rules;
    }

    @Override
    public void setGameRules(GameRules rules) {
        this.levelData.putCompound("GameRules", rules.writeNBT());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGarbageCollection() {
        int limit = (int)(System.currentTimeMillis() - 50L);
        Long2ObjectMap<BaseRegionLoader> long2ObjectMap = this.regions;
        synchronized (long2ObjectMap) {
            if (this.regions.isEmpty()) {
                return;
            }
            ObjectIterator iter = this.regions.values().iterator();
            while (iter.hasNext()) {
                BaseRegionLoader loader = (BaseRegionLoader)iter.next();
                if (loader.lastUsed > (long)limit) continue;
                try {
                    loader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close RegionLoader", e);
                }
                this.lastRegion.set(null);
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveChunks() {
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            for (BaseFullChunk chunk : this.chunks.values()) {
                if (chunk.getChanges() == 0L) continue;
                chunk.setChanged(false);
                this.saveChunk(chunk.getX(), chunk.getZ());
            }
        }
    }

    public CompoundTag getLevelData() {
        return this.levelData;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed resource leak")
    public void saveLevelData() {
        File levelDataFile = new File(this.getPath(), "level.dat");
        try {
            Utils.safeWrite(levelDataFile, file -> {
                try (FileOutputStream fos = new FileOutputStream((File)file);
                     BufferedOutputStream out = new BufferedOutputStream(fos);){
                    NBTIO.writeGZIPCompressed(new CompoundTag().putCompound("Data", this.levelData), out);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            log.fatal("Failed to save the level.dat file at {}", (Object)levelDataFile.getAbsolutePath(), (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void updateLevelName(String name) {
        if (!this.getName().equals(name)) {
            this.levelData.putString("LevelName", name);
        }
    }

    @Override
    public boolean loadChunk(int chunkX, int chunkZ) {
        return this.loadChunk(chunkX, chunkZ, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadChunk(int chunkX, int chunkZ, boolean create) {
        long index = Level.chunkHash(chunkX, chunkZ);
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            if (this.chunks.containsKey(index)) {
                return true;
            }
        }
        return this.loadChunk(index, chunkX, chunkZ, create) != null;
    }

    @Override
    public boolean unloadChunk(int X, int Z) {
        return this.unloadChunk(X, Z, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unloadChunk(int X, int Z, boolean safe) {
        long index = Level.chunkHash(X, Z);
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            BaseFullChunk chunk = (BaseFullChunk)this.chunks.get(index);
            if (chunk != null && chunk.unload(false, safe)) {
                this.lastChunk.set(null);
                this.chunks.remove(index, (Object)chunk);
                return true;
            }
        }
        return false;
    }

    @Override
    public BaseFullChunk getChunk(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFullChunk getLoadedChunk(int chunkX, int chunkZ) {
        BaseFullChunk tmp = this.lastChunk.get();
        if (tmp != null && tmp.getX() == chunkX && tmp.getZ() == chunkZ) {
            return tmp;
        }
        long index = Level.chunkHash(chunkX, chunkZ);
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            tmp = (BaseFullChunk)this.chunks.get(index);
            this.lastChunk.set(tmp);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFullChunk getLoadedChunk(long hash) {
        BaseFullChunk tmp = this.lastChunk.get();
        if (tmp != null && tmp.getIndex() == hash) {
            return tmp;
        }
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            tmp = (BaseFullChunk)this.chunks.get(hash);
            this.lastChunk.set(tmp);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFullChunk getChunk(int chunkX, int chunkZ, boolean create) {
        BaseFullChunk tmp = this.lastChunk.get();
        if (tmp != null && tmp.getX() == chunkX && tmp.getZ() == chunkZ) {
            return tmp;
        }
        long index = Level.chunkHash(chunkX, chunkZ);
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            tmp = (BaseFullChunk)this.chunks.get(index);
            this.lastChunk.set(tmp);
        }
        if (tmp != null) {
            return tmp;
        }
        tmp = this.loadChunk(index, chunkX, chunkZ, create);
        this.lastChunk.set(tmp);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChunk(int chunkX, int chunkZ, FullChunk chunk) {
        if (!(chunk instanceof BaseFullChunk)) {
            throw new ChunkException("Invalid Chunk class");
        }
        chunk.setProvider(this);
        chunk.setPosition(chunkX, chunkZ);
        long index = Level.chunkHash(chunkX, chunkZ);
        Long2ObjectMap<BaseFullChunk> long2ObjectMap = this.chunks;
        synchronized (long2ObjectMap) {
            if (this.chunks.containsKey(index) && !((BaseFullChunk)this.chunks.get(index)).equals(chunk)) {
                this.unloadChunk(chunkX, chunkZ, false);
            }
            this.chunks.put(index, (Object)((BaseFullChunk)chunk));
        }
    }

    @Override
    public boolean isChunkPopulated(int chunkX, int chunkZ) {
        BaseFullChunk chunk = this.getChunk(chunkX, chunkZ);
        return chunk != null && chunk.isPopulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        this.unloadChunks();
        Long2ObjectMap<BaseRegionLoader> long2ObjectMap = this.regions;
        synchronized (long2ObjectMap) {
            ObjectIterator iter = this.regions.values().iterator();
            while (iter.hasNext()) {
                try {
                    ((BaseRegionLoader)iter.next()).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close RegionLoader", e);
                }
                this.lastRegion.set(null);
                iter.remove();
            }
        }
        this.level = null;
    }

    @Override
    public boolean isChunkGenerated(int chunkX, int chunkZ) {
        BaseRegionLoader region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        return region != null && region.chunkExists(chunkX - region.getX() * 32, chunkZ - region.getZ() * 32) && this.getChunk(chunkX - region.getX() * 32, chunkZ - region.getZ() * 32, true).isGenerated();
    }
}

