/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockDoor;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.BlockStateRegistry;
import cn.nukkit.blockstate.MutableBlockState;
import cn.nukkit.level.format.Chunk;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.updater.Updater;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class DoorUpdater
implements Updater {
    private static final int DOOR_OPEN_BIT = 4;
    private static final int DOOR_TOP_BIT = 8;
    private static final int DOOR_HINGE_BIT = 1;
    private final Chunk chunk;
    private final ChunkSection section;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public DoorUpdater(Chunk chunk, ChunkSection section) {
        this.chunk = chunk;
        this.section = section;
    }

    @Override
    public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, BlockState state) {
        switch (state.getBlockId()) {
            case 64: 
            case 71: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: {
                break;
            }
            default: {
                return false;
            }
        }
        int legacy = state.getLegacyDamage();
        MutableBlockState mutableState = BlockStateRegistry.createMutableState(state.getBlockId());
        if ((legacy & 8) > 0) {
            BlockState underState;
            mutableState.setBooleanValue(CommonBlockProperties.UPPER_BLOCK, true);
            mutableState.setBooleanValue(BlockDoor.DOOR_HINGE, (legacy & 1) > 0);
            int underY = offsetY + y - 1;
            if (underY >= 0 && (underState = this.chunk.getBlockState(x, underY, z)).getBlockId() == state.getBlockId()) {
                mutableState.setPropertyValue(BlockDoor.DOOR_DIRECTION, underState.getPropertyValue(BlockDoor.DOOR_DIRECTION));
                mutableState.setBooleanValue(CommonBlockProperties.OPEN, (boolean)underState.getPropertyValue(CommonBlockProperties.OPEN));
            }
        } else {
            mutableState.setBooleanValue(CommonBlockProperties.UPPER_BLOCK, false);
            mutableState.setPropertyValue(BlockDoor.DOOR_DIRECTION, BlockDoor.DOOR_DIRECTION.getValueForMeta(legacy & 3));
            mutableState.setBooleanValue(CommonBlockProperties.OPEN, (legacy & 4) > 0);
        }
        return this.section.setBlockState(x, y, z, mutableState.getCurrentState());
    }
}

