/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.particle;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.utils.Utils;
import java.lang.reflect.Field;

public abstract class Particle
extends Vector3 {
    public static final int TYPE_BUBBLE = Utils.dynamic(1);
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_BUBBLE_MANUAL = Utils.dynamic(2);
    public static final int TYPE_CRITICAL = Utils.dynamic(3);
    public static final int TYPE_BLOCK_FORCE_FIELD = Utils.dynamic(4);
    public static final int TYPE_SMOKE = Utils.dynamic(5);
    public static final int TYPE_EXPLODE = Utils.dynamic(6);
    public static final int TYPE_EVAPORATION = Utils.dynamic(7);
    public static final int TYPE_FLAME = Utils.dynamic(8);
    public static final int TYPE_LAVA = Utils.dynamic(9);
    public static final int TYPE_LARGE_SMOKE = Utils.dynamic(10);
    public static final int TYPE_REDSTONE = Utils.dynamic(11);
    public static final int TYPE_RISING_RED_DUST = Utils.dynamic(12);
    public static final int TYPE_ITEM_BREAK = Utils.dynamic(13);
    public static final int TYPE_SNOWBALL_POOF = Utils.dynamic(14);
    public static final int TYPE_HUGE_EXPLODE = Utils.dynamic(15);
    public static final int TYPE_HUGE_EXPLODE_SEED = Utils.dynamic(16);
    public static final int TYPE_MOB_FLAME = Utils.dynamic(17);
    public static final int TYPE_HEART = Utils.dynamic(18);
    public static final int TYPE_TERRAIN = Utils.dynamic(19);
    public static final int TYPE_SUSPENDED_TOWN;
    public static final int TYPE_TOWN_AURA;
    public static final int TYPE_PORTAL;
    public static final int TYPE_SPLASH;
    public static final int TYPE_WATER_SPLASH;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_WATER_SPLASH_MANUAL;
    public static final int TYPE_WATER_WAKE;
    public static final int TYPE_DRIP_WATER;
    public static final int TYPE_DRIP_LAVA;
    public static final int TYPE_DRIP_HONEY;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_STALACTITE_DRIP_WATER;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_STALACTITE_DRIP_LAVA;
    public static final int TYPE_FALLING_DUST;
    public static final int TYPE_DUST;
    public static final int TYPE_MOB_SPELL;
    public static final int TYPE_MOB_SPELL_AMBIENT;
    public static final int TYPE_MOB_SPELL_INSTANTANEOUS;
    public static final int TYPE_INK;
    public static final int TYPE_SLIME;
    public static final int TYPE_RAIN_SPLASH;
    public static final int TYPE_VILLAGER_ANGRY;
    public static final int TYPE_VILLAGER_HAPPY;
    public static final int TYPE_ENCHANTMENT_TABLE;
    public static final int TYPE_TRACKING_EMITTER;
    public static final int TYPE_NOTE;
    @Deprecated
    @PowerNukkitOnly(value="Backward compatibility")
    @DeprecationDetails(since="1.4.0.0-PN", by="NukkitX", reason="Removed from Nukkit")
    public static final int TYPE_NOTE_AND_DUST;
    public static final int TYPE_WITCH_SPELL;
    public static final int TYPE_CARROT;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_MOB_APPEARANCE;
    public static final int TYPE_END_ROD;
    public static final int TYPE_RISING_DRAGONS_BREATH;
    public static final int TYPE_SPIT;
    public static final int TYPE_TOTEM;
    public static final int TYPE_FOOD;
    public static final int TYPE_FIREWORKS_STARTER;
    public static final int TYPE_FIREWORKS_SPARK;
    public static final int TYPE_FIREWORKS_OVERLAY;
    public static final int TYPE_BALLOON_GAS;
    public static final int TYPE_COLORED_FLAME;
    public static final int TYPE_SPARKLER;
    public static final int TYPE_CONDUIT;
    public static final int TYPE_BUBBLE_COLUMN_UP;
    public static final int TYPE_BUBBLE_COLUMN_DOWN;
    public static final int TYPE_SNEEZE;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_SHULKER_BULLET;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_BLEACH;
    public static final int TYPE_LARGE_EXPLOSION;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_MYCELIUM_DUST;
    public static final int TYPE_FALLING_RED_DUST;
    public static final int TYPE_CAMPFIRE_SMOKE;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_TALL_CAMPFIRE_SMOKE;
    public static final int TYPE_FALLING_DRAGONS_BREATH;
    public static final int TYPE_DRAGONS_BREATH;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_BLUE_FLAME;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_SOUL;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_OBSIDIAN_TEAR;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_PORTAL_REVERSE;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_SNOWFLAKE;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_VIBRATION_SIGNAL;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_SCULK_SENSOR_REDSTONE;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_SPORE_BLOSSOM_SHOWER;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_SPORE_BLOSSOM_AMBIENT;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_WAX;
    @Since(value="1.4.0.0-PN")
    public static final int TYPE_ELECTRIC_SPARK;

    @Since(value="1.4.0.0-PN")
    public static Integer getParticleIdByName(String name) {
        name = name.toUpperCase();
        try {
            Field field = Particle.class.getDeclaredField(name.startsWith("TYPE_") ? name : "TYPE_" + name);
            Class<?> type = field.getType();
            if (type == Integer.TYPE) {
                return field.getInt(null);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    @Since(value="1.4.0.0-PN")
    public static boolean particleExists(String name) {
        return Particle.getParticleIdByName(name) != null;
    }

    public Particle() {
        super(0.0, 0.0, 0.0);
    }

    public Particle(double x) {
        super(x, 0.0, 0.0);
    }

    public Particle(double x, double y) {
        super(x, y, 0.0);
    }

    public Particle(double x, double y, double z) {
        super(x, y, z);
    }

    public abstract DataPacket[] encode();

    static {
        TYPE_TOWN_AURA = TYPE_SUSPENDED_TOWN = Utils.dynamic(20);
        TYPE_PORTAL = Utils.dynamic(21);
        TYPE_WATER_SPLASH = TYPE_SPLASH = Utils.dynamic(23);
        TYPE_WATER_SPLASH_MANUAL = Utils.dynamic(24);
        TYPE_WATER_WAKE = Utils.dynamic(25);
        TYPE_DRIP_WATER = Utils.dynamic(26);
        TYPE_DRIP_LAVA = Utils.dynamic(27);
        TYPE_DRIP_HONEY = Utils.dynamic(28);
        TYPE_STALACTITE_DRIP_WATER = Utils.dynamic(29);
        TYPE_STALACTITE_DRIP_LAVA = Utils.dynamic(30);
        TYPE_DUST = TYPE_FALLING_DUST = Utils.dynamic(31);
        TYPE_MOB_SPELL = Utils.dynamic(32);
        TYPE_MOB_SPELL_AMBIENT = Utils.dynamic(33);
        TYPE_MOB_SPELL_INSTANTANEOUS = Utils.dynamic(34);
        TYPE_INK = Utils.dynamic(35);
        TYPE_SLIME = Utils.dynamic(36);
        TYPE_RAIN_SPLASH = Utils.dynamic(37);
        TYPE_VILLAGER_ANGRY = Utils.dynamic(38);
        TYPE_VILLAGER_HAPPY = Utils.dynamic(39);
        TYPE_ENCHANTMENT_TABLE = Utils.dynamic(40);
        TYPE_TRACKING_EMITTER = Utils.dynamic(41);
        TYPE_NOTE_AND_DUST = TYPE_NOTE = Utils.dynamic(42);
        TYPE_WITCH_SPELL = Utils.dynamic(43);
        TYPE_CARROT = Utils.dynamic(44);
        TYPE_MOB_APPEARANCE = Utils.dynamic(45);
        TYPE_END_ROD = Utils.dynamic(46);
        TYPE_RISING_DRAGONS_BREATH = Utils.dynamic(47);
        TYPE_SPIT = Utils.dynamic(48);
        TYPE_TOTEM = Utils.dynamic(49);
        TYPE_FOOD = Utils.dynamic(50);
        TYPE_FIREWORKS_STARTER = Utils.dynamic(51);
        TYPE_FIREWORKS_SPARK = Utils.dynamic(52);
        TYPE_FIREWORKS_OVERLAY = Utils.dynamic(53);
        TYPE_BALLOON_GAS = Utils.dynamic(54);
        TYPE_COLORED_FLAME = Utils.dynamic(55);
        TYPE_SPARKLER = Utils.dynamic(56);
        TYPE_CONDUIT = Utils.dynamic(57);
        TYPE_BUBBLE_COLUMN_UP = Utils.dynamic(58);
        TYPE_BUBBLE_COLUMN_DOWN = Utils.dynamic(59);
        TYPE_SNEEZE = Utils.dynamic(60);
        TYPE_SHULKER_BULLET = Utils.dynamic(61);
        TYPE_BLEACH = Utils.dynamic(62);
        TYPE_LARGE_EXPLOSION = Utils.dynamic(63);
        TYPE_MYCELIUM_DUST = Utils.dynamic(64);
        TYPE_FALLING_RED_DUST = Utils.dynamic(65);
        TYPE_CAMPFIRE_SMOKE = Utils.dynamic(66);
        TYPE_TALL_CAMPFIRE_SMOKE = Utils.dynamic(67);
        TYPE_FALLING_DRAGONS_BREATH = Utils.dynamic(68);
        TYPE_DRAGONS_BREATH = Utils.dynamic(69);
        TYPE_BLUE_FLAME = Utils.dynamic(70);
        TYPE_SOUL = Utils.dynamic(71);
        TYPE_OBSIDIAN_TEAR = Utils.dynamic(72);
        TYPE_PORTAL_REVERSE = Utils.dynamic(73);
        TYPE_SNOWFLAKE = Utils.dynamic(74);
        TYPE_VIBRATION_SIGNAL = Utils.dynamic(75);
        TYPE_SCULK_SENSOR_REDSTONE = Utils.dynamic(76);
        TYPE_SPORE_BLOSSOM_SHOWER = Utils.dynamic(77);
        TYPE_SPORE_BLOSSOM_AMBIENT = Utils.dynamic(78);
        TYPE_WAX = Utils.dynamic(79);
        TYPE_ELECTRIC_SPARK = Utils.dynamic(80);
    }
}

