/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.nbt.tag;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.nbt.stream.NBTInputStream;
import cn.nukkit.nbt.stream.NBTOutputStream;
import cn.nukkit.nbt.tag.Tag;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class StringTag
extends Tag {
    public String data;

    public StringTag(String name) {
        super(name);
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Throws NullPointerException instead of IllegalArgumentException if data is null")
    public StringTag(String name, @Nonnull String data) {
        super(name);
        this.data = (String)Preconditions.checkNotNull((Object)data, (Object)"Empty string not allowed");
    }

    @Override
    void write(NBTOutputStream dos) throws IOException {
        dos.writeUTF(this.data);
    }

    @Override
    void load(NBTInputStream dis) throws IOException {
        this.data = dis.readUTF();
    }

    @Override
    public String parseValue() {
        return this.data;
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public String toString() {
        return "StringTag " + this.getName() + " (data: " + this.data + ")";
    }

    @Override
    public Tag copy() {
        return new StringTag(this.getName(), this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            StringTag o = (StringTag)obj;
            return this.data == null && o.data == null || this.data != null && this.data.equals(o.data);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data);
    }
}

