/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.resourcepacks.ResourcePack;
import java.util.Arrays;

public class ResourcePacksInfoPacket
extends DataPacket {
    public static final byte NETWORK_ID = 6;
    public boolean mustAccept;
    public boolean scripting;
    public ResourcePack[] behaviourPackEntries = ResourcePack.EMPTY_ARRAY;
    public ResourcePack[] resourcePackEntries = ResourcePack.EMPTY_ARRAY;

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        this.putBoolean(this.mustAccept);
        this.putBoolean(this.scripting);
        this.encodePacks(this.behaviourPackEntries);
        this.encodePacks(this.resourcePackEntries);
    }

    private void encodePacks(ResourcePack[] packs) {
        this.putLShort(packs.length);
        for (ResourcePack entry : packs) {
            this.putString(entry.getPackId().toString());
            this.putString(entry.getPackVersion());
            this.putLLong(entry.getPackSize());
            this.putString("");
            this.putString("");
            this.putString("");
            this.putBoolean(false);
            this.putBoolean(false);
        }
    }

    @Override
    public byte pid() {
        return 6;
    }

    public String toString() {
        return "ResourcePacksInfoPacket(mustAccept=" + this.mustAccept + ", scripting=" + this.scripting + ", behaviourPackEntries=" + Arrays.deepToString(this.behaviourPackEntries) + ", resourcePackEntries=" + Arrays.deepToString(this.resourcePackEntries) + ")";
    }
}

