/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol.types;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.inventory.BeaconInventory;
import cn.nukkit.inventory.EnchantInventory;
import cn.nukkit.inventory.GrindstoneInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.SmithingInventory;
import cn.nukkit.inventory.transaction.action.CraftingTakeResultAction;
import cn.nukkit.inventory.transaction.action.CraftingTransferMaterialAction;
import cn.nukkit.inventory.transaction.action.CreativeInventoryAction;
import cn.nukkit.inventory.transaction.action.DropItemAction;
import cn.nukkit.inventory.transaction.action.EnchantingAction;
import cn.nukkit.inventory.transaction.action.GrindstoneItemAction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.RepairItemAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.inventory.transaction.action.SmithingItemAction;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.InventoryTransactionPacket;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkInventoryAction {
    private static final Logger log = LogManager.getLogger(NetworkInventoryAction.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final NetworkInventoryAction[] EMPTY_ARRAY = new NetworkInventoryAction[0];
    public static final int SOURCE_CONTAINER = 0;
    public static final int SOURCE_WORLD = 2;
    public static final int SOURCE_CREATIVE = 3;
    public static final int SOURCE_TODO = 99999;
    public static final int SOURCE_CRAFT_SLOT = 100;
    public static final int SOURCE_TYPE_CRAFTING_ADD_INGREDIENT = -2;
    public static final int SOURCE_TYPE_CRAFTING_REMOVE_INGREDIENT = -3;
    public static final int SOURCE_TYPE_CRAFTING_RESULT = -4;
    public static final int SOURCE_TYPE_CRAFTING_USE_INGREDIENT = -5;
    public static final int SOURCE_TYPE_ANVIL_INPUT = -10;
    public static final int SOURCE_TYPE_ANVIL_MATERIAL = -11;
    public static final int SOURCE_TYPE_ANVIL_RESULT = -12;
    public static final int SOURCE_TYPE_ANVIL_OUTPUT = -13;
    public static final int SOURCE_TYPE_ENCHANT_INPUT = -15;
    public static final int SOURCE_TYPE_ENCHANT_MATERIAL = -16;
    public static final int SOURCE_TYPE_ENCHANT_OUTPUT = -17;
    public static final int SOURCE_TYPE_TRADING_INPUT_1 = -20;
    public static final int SOURCE_TYPE_TRADING_INPUT_2 = -21;
    public static final int SOURCE_TYPE_TRADING_USE_INPUTS = -22;
    public static final int SOURCE_TYPE_TRADING_OUTPUT = -23;
    public static final int SOURCE_TYPE_BEACON = -24;
    public static final int SOURCE_TYPE_CONTAINER_DROP_CONTENTS = -100;
    public int sourceType;
    public int windowId;
    public long unknown;
    public int inventorySlot;
    public Item oldItem;
    public Item newItem;
    @Since(value="1.3.0.0-PN")
    public int stackNetworkId;

    public NetworkInventoryAction read(InventoryTransactionPacket packet) {
        this.sourceType = (int)packet.getUnsignedVarInt();
        block0 : switch (this.sourceType) {
            case 0: {
                this.windowId = packet.getVarInt();
                break;
            }
            case 2: {
                this.unknown = packet.getUnsignedVarInt();
                break;
            }
            case 3: {
                break;
            }
            case 100: 
            case 99999: {
                this.windowId = packet.getVarInt();
                switch (this.windowId) {
                    case -5: 
                    case -4: {
                        packet.isCraftingPart = true;
                        break block0;
                    }
                    case -17: 
                    case -16: 
                    case -15: {
                        packet.isEnchantingPart = true;
                        break block0;
                    }
                    case -12: 
                    case -11: 
                    case -10: {
                        packet.isRepairItemPart = true;
                    }
                }
            }
        }
        this.inventorySlot = (int)packet.getUnsignedVarInt();
        this.oldItem = packet.getSlot();
        this.newItem = packet.getSlot();
        return this;
    }

    public void write(InventoryTransactionPacket packet) {
        packet.putUnsignedVarInt(this.sourceType);
        switch (this.sourceType) {
            case 0: 
            case 100: 
            case 99999: {
                packet.putVarInt(this.windowId);
                break;
            }
            case 2: {
                packet.putUnsignedVarInt(this.unknown);
                break;
            }
        }
        packet.putUnsignedVarInt(this.inventorySlot);
        packet.putSlot(this.oldItem);
        packet.putSlot(this.newItem);
    }

    public InventoryAction createInventoryAction(Player player) {
        switch (this.sourceType) {
            case 0: {
                Inventory window;
                if (this.windowId == 120) {
                    this.inventorySlot += 36;
                    this.windowId = 0;
                }
                if (this.windowId == 124) {
                    switch (this.inventorySlot) {
                        case 50: {
                            if (player.getWindowById(2) == null) break;
                            this.windowId = 2;
                            this.inventorySlot = 2;
                            break;
                        }
                        case 14: {
                            if (player.getWindowById(3) == null) {
                                log.error("Player {} does not have enchant window open", (Object)player.getName());
                                return null;
                            }
                            this.windowId = 3;
                            this.inventorySlot = 0;
                            break;
                        }
                        case 15: {
                            if (player.getWindowById(3) == null) {
                                log.error("Player {} does not have enchant window open", (Object)player.getName());
                                return null;
                            }
                            this.windowId = 3;
                            this.inventorySlot = 1;
                            break;
                        }
                        case 1: {
                            if (player.getWindowById(2) == null) {
                                log.error("Player {} does not have anvil window open", (Object)player.getName());
                                return null;
                            }
                            this.windowId = 2;
                            this.inventorySlot = 0;
                            break;
                        }
                        case 2: {
                            if (player.getWindowById(2) == null) {
                                log.error("Player {} does not have anvil window open", (Object)player.getName());
                                return null;
                            }
                            this.windowId = 2;
                            this.inventorySlot = 1;
                            break;
                        }
                        case 51: {
                            if (player.getWindowById(Player.SMITHING_WINDOW_ID) == null) {
                                log.error("Player {} does not have smithing table window open", (Object)player.getName());
                                return null;
                            }
                            this.windowId = Player.SMITHING_WINDOW_ID;
                            this.inventorySlot = 0;
                            break;
                        }
                        case 52: {
                            if (player.getWindowById(Player.SMITHING_WINDOW_ID) == null) {
                                log.error("Player {} does not have smithing table window open", (Object)player.getName());
                                return null;
                            }
                            this.windowId = Player.SMITHING_WINDOW_ID;
                            this.inventorySlot = 1;
                            break;
                        }
                        case 16: {
                            if (player.getWindowById(Player.GRINDSTONE_WINDOW_ID) == null) {
                                log.error("Player {} does not have grindstone window open", (Object)player.getName());
                                return null;
                            }
                            this.windowId = Player.GRINDSTONE_WINDOW_ID;
                            this.inventorySlot = 0;
                            break;
                        }
                        case 17: {
                            if (player.getWindowById(Player.GRINDSTONE_WINDOW_ID) == null) {
                                log.error("Player {} does not have grindstone window open", (Object)player.getName());
                                return null;
                            }
                            this.windowId = Player.GRINDSTONE_WINDOW_ID;
                            this.inventorySlot = 1;
                        }
                    }
                }
                if ((window = player.getWindowById(this.windowId)) != null) {
                    return new SlotChangeAction(window, this.inventorySlot, this.oldItem, this.newItem);
                }
                log.debug("Player {} has no open container with window ID {}", (Object)player.getName(), (Object)this.windowId);
                return null;
            }
            case 2: {
                if (this.inventorySlot != 0) {
                    log.debug("Only expecting drop-item world actions from the client!");
                    return null;
                }
                return new DropItemAction(this.oldItem, this.newItem);
            }
            case 3: {
                int type;
                switch (this.inventorySlot) {
                    case 0: {
                        type = 0;
                        break;
                    }
                    case 1: {
                        type = 1;
                        break;
                    }
                    default: {
                        log.debug("Unexpected creative action type {}", (Object)this.inventorySlot);
                        return null;
                    }
                }
                return new CreativeInventoryAction(this.oldItem, this.newItem, type);
            }
            case 100: 
            case 99999: {
                Inventory inv;
                switch (this.windowId) {
                    case -3: 
                    case -2: {
                        return new SlotChangeAction(player.getCraftingGrid(), this.inventorySlot, this.oldItem, this.newItem);
                    }
                    case -100: {
                        Optional<Inventory> inventory = player.getTopWindow();
                        if (!inventory.isPresent()) {
                            return null;
                        }
                        return new SlotChangeAction(inventory.get(), this.inventorySlot, this.oldItem, this.newItem);
                    }
                    case -4: {
                        return new CraftingTakeResultAction(this.oldItem, this.newItem);
                    }
                    case -5: {
                        return new CraftingTransferMaterialAction(this.oldItem, this.newItem, this.inventorySlot);
                    }
                }
                if (this.windowId >= -13 && this.windowId <= -10) {
                    inv = player.getWindowById(2);
                    if (inv instanceof AnvilInventory) {
                        AnvilInventory anvil = (AnvilInventory)inv;
                        switch (this.windowId) {
                            case -12: 
                            case -11: 
                            case -10: {
                                return new RepairItemAction(this.oldItem, this.newItem, this.windowId);
                            }
                        }
                        return new SlotChangeAction(anvil, this.inventorySlot, this.oldItem, this.newItem);
                    }
                    inv = player.getWindowById(Player.GRINDSTONE_WINDOW_ID);
                    if (inv instanceof GrindstoneInventory) {
                        switch (this.windowId) {
                            case -12: 
                            case -11: 
                            case -10: {
                                return new GrindstoneItemAction(this.oldItem, this.newItem, this.windowId, this.windowId != -12 ? 0 : ((GrindstoneInventory)inv).getResultExperience());
                            }
                        }
                        return new SlotChangeAction(inv, this.inventorySlot, this.oldItem, this.newItem);
                    }
                    if (player.getWindowById(Player.SMITHING_WINDOW_ID) instanceof SmithingInventory) {
                        switch (this.windowId) {
                            case -13: 
                            case -12: 
                            case -11: 
                            case -10: {
                                return new SmithingItemAction(this.oldItem, this.newItem, this.inventorySlot);
                            }
                        }
                    } else {
                        log.debug("Player {} has no open anvil or grindstone inventory", (Object)player.getName());
                        return null;
                    }
                }
                if (this.windowId >= -17 && this.windowId <= -15) {
                    inv = player.getWindowById(3);
                    if (!(inv instanceof EnchantInventory)) {
                        log.debug("Player {} has no open enchant inventory", (Object)player.getName());
                        return null;
                    }
                    EnchantInventory enchant = (EnchantInventory)inv;
                    switch (this.windowId) {
                        case -15: {
                            return new EnchantingAction(this.oldItem, this.newItem, -15);
                        }
                        case -16: {
                            return new EnchantingAction(this.newItem, this.oldItem, -16);
                        }
                        case -17: {
                            return new EnchantingAction(this.oldItem, this.newItem, -17);
                        }
                    }
                    return new SlotChangeAction(enchant, this.inventorySlot, this.oldItem, this.newItem);
                }
                if (this.windowId == -24) {
                    inv = player.getWindowById(4);
                    if (!(inv instanceof BeaconInventory)) {
                        log.debug("Player {} has no open beacon inventory", (Object)player.getName());
                        return null;
                    }
                    BeaconInventory beacon = (BeaconInventory)inv;
                    this.inventorySlot = 0;
                    return new SlotChangeAction(beacon, this.inventorySlot, this.oldItem, this.newItem);
                }
                log.debug("Player {} has no open container with window ID {}", (Object)player.getName(), (Object)this.windowId);
                return null;
            }
        }
        log.debug("Unknown inventory source type {}", (Object)this.sourceType);
        return null;
    }

    public String toString() {
        return "NetworkInventoryAction(sourceType=" + this.sourceType + ", windowId=" + this.windowId + ", unknown=" + this.unknown + ", inventorySlot=" + this.inventorySlot + ", oldItem=" + this.oldItem + ", newItem=" + this.newItem + ", stackNetworkId=" + this.stackNetworkId + ")";
    }
}

