/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.utils.ZlibOriginal;
import cn.nukkit.utils.ZlibProvider;
import cn.nukkit.utils.ZlibSingleThreadLowMem;
import cn.nukkit.utils.ZlibThreadLocal;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Zlib {
    private static final Logger log = LogManager.getLogger(Zlib.class);
    private static ZlibProvider[] providers = new ZlibProvider[3];
    private static ZlibProvider provider;

    public static void setProvider(int providerIndex) {
        log.info("Selected Zlib Provider: {} ({})", (Object)providerIndex, (Object)provider.getClass().getCanonicalName());
        switch (providerIndex) {
            case 0: {
                if (providers[providerIndex] != null) break;
                Zlib.providers[providerIndex] = new ZlibOriginal();
                break;
            }
            case 1: {
                if (providers[providerIndex] != null) break;
                Zlib.providers[providerIndex] = new ZlibSingleThreadLowMem();
                break;
            }
            case 2: {
                if (providers[providerIndex] != null) break;
                Zlib.providers[providerIndex] = new ZlibThreadLocal();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid provider: " + providerIndex);
            }
        }
        if (providerIndex != 2) {
            log.warn(" - This Zlib will negatively affect performance");
        }
        provider = providers[providerIndex];
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Throws IOException instead of Exception")
    public static byte[] deflate(byte[] data) throws IOException {
        return Zlib.deflate(data, -1);
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Throws IOException instead of Exception")
    public static byte[] deflate(byte[] data, int level) throws IOException {
        return provider.deflate(data, level);
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Throws IOException instead of Exception")
    public static byte[] deflate(byte[][] data, int level) throws IOException {
        return provider.deflate(data, level);
    }

    public static byte[] inflate(byte[] data) throws IOException {
        return Zlib.inflate(data, -1);
    }

    public static byte[] inflate(byte[] data, int maxSize) throws IOException {
        return provider.inflate(data, maxSize);
    }

    static {
        Zlib.providers[2] = new ZlibThreadLocal();
        provider = providers[2];
    }
}

