/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.ConsoleCommandSender;
import cn.nukkit.command.RemoteConsoleCommandSender;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.nbt.stream.PGZIPOutputStream;
import cn.nukkit.timings.JsonUtil;
import cn.nukkit.utils.TextFormat;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsHistory;
import co.aikar.timings.TimingsManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimingsExport
extends Thread {
    private static final Logger log = LogManager.getLogger(TimingsExport.class);
    private final CommandSender sender;
    private final JsonObject out;
    private final TimingsHistory[] history;

    private TimingsExport(CommandSender sender, JsonObject out, TimingsHistory[] history) {
        super("Timings paste thread");
        this.sender = sender;
        this.out = out;
        this.history = history;
    }

    public static void reportTimings(CommandSender sender) {
        JsonObject out = new JsonObject();
        out.addProperty("version", Server.getInstance().getVersion());
        out.addProperty("maxplayers", (Number)Server.getInstance().getMaxPlayers());
        out.addProperty("start", (Number)(TimingsManager.timingStart / 1000L));
        out.addProperty("end", (Number)(System.currentTimeMillis() / 1000L));
        out.addProperty("sampletime", (Number)((System.currentTimeMillis() - TimingsManager.timingStart) / 1000L));
        if (!Timings.isPrivacy()) {
            out.addProperty("server", Server.getInstance().getName());
            out.addProperty("motd", Server.getInstance().getMotd());
            out.addProperty("online-mode", Boolean.valueOf(false));
            out.addProperty("icon", "");
        }
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        JsonObject system = new JsonObject();
        system.addProperty("timingcost", (Number)TimingsExport.getCost());
        system.addProperty("name", System.getProperty("os.name"));
        system.addProperty("version", System.getProperty("os.version"));
        system.addProperty("jvmversion", System.getProperty("java.version"));
        system.addProperty("arch", System.getProperty("os.arch"));
        system.addProperty("maxmem", (Number)runtime.maxMemory());
        system.addProperty("cpu", (Number)runtime.availableProcessors());
        system.addProperty("runtime", (Number)ManagementFactory.getRuntimeMXBean().getUptime());
        system.addProperty("flags", String.join((CharSequence)" ", runtimeBean.getInputArguments()));
        system.add("gc", (JsonElement)JsonUtil.mapToObject(ManagementFactory.getGarbageCollectorMXBeans(), input -> new JsonUtil.JSONPair(input.getName(), (Object)JsonUtil.toArray(input.getCollectionCount(), input.getCollectionTime()))));
        out.add("system", (JsonElement)system);
        TimingsHistory[] history = TimingsManager.HISTORY.toArray(new TimingsHistory[TimingsManager.HISTORY.size() + 1]);
        history[TimingsManager.HISTORY.size()] = new TimingsHistory();
        JsonObject timings = new JsonObject();
        for (TimingIdentifier.TimingGroup group2 : TimingIdentifier.GROUP_MAP.values()) {
            for (Timing id : group2.timings) {
                if (!id.timed && !id.isSpecial()) continue;
                timings.add(String.valueOf(id.id), (JsonElement)JsonUtil.toArray(group2.id, id.name));
            }
        }
        JsonObject idmap = new JsonObject();
        idmap.add("groups", (JsonElement)JsonUtil.mapToObject(TimingIdentifier.GROUP_MAP.values(), group -> new JsonUtil.JSONPair(group.id, (Object)group.name)));
        idmap.add("handlers", (JsonElement)timings);
        idmap.add("worlds", (JsonElement)JsonUtil.mapToObject(TimingsHistory.levelMap.entrySet(), entry -> new JsonUtil.JSONPair((Integer)entry.getValue(), entry.getKey())));
        idmap.add("tileentity", (JsonElement)JsonUtil.mapToObject(TimingsHistory.blockEntityMap.entrySet(), entry -> new JsonUtil.JSONPair((Integer)entry.getKey(), entry.getValue())));
        idmap.add("entity", (JsonElement)JsonUtil.mapToObject(TimingsHistory.entityMap.entrySet(), entry -> new JsonUtil.JSONPair((Integer)entry.getKey(), entry.getValue())));
        out.add("idmap", (JsonElement)idmap);
        out.add("plugins", (JsonElement)JsonUtil.mapToObject(Server.getInstance().getPluginManager().getPlugins().values(), plugin -> {
            JsonObject jsonPlugin = new JsonObject();
            jsonPlugin.addProperty("version", plugin.getDescription().getVersion());
            jsonPlugin.addProperty("description", plugin.getDescription().getDescription());
            jsonPlugin.addProperty("website", plugin.getDescription().getWebsite());
            jsonPlugin.addProperty("authors", String.join((CharSequence)", ", plugin.getDescription().getAuthors()));
            return new JsonUtil.JSONPair(plugin.getName(), (Object)jsonPlugin);
        }));
        JsonObject config = new JsonObject();
        if (!Timings.getIgnoredConfigSections().contains("all")) {
            JsonObject nukkit = JsonUtil.toObject(Server.getInstance().getConfig().getRootSection());
            Timings.getIgnoredConfigSections().forEach(arg_0 -> ((JsonObject)nukkit).remove(arg_0));
            config.add("nukkit", (JsonElement)nukkit);
        } else {
            config.add("nukkit", null);
        }
        out.add("config", (JsonElement)config);
        new TimingsExport(sender, out, history).start();
    }

    private static long getCost() {
        int passes = 200;
        Timing SAMPLER1 = TimingsManager.getTiming(null, "Timings sampler 1", null);
        Timing SAMPLER2 = TimingsManager.getTiming(null, "Timings sampler 2", null);
        Timing SAMPLER3 = TimingsManager.getTiming(null, "Timings sampler 3", null);
        Timing SAMPLER4 = TimingsManager.getTiming(null, "Timings sampler 4", null);
        Timing SAMPLER5 = TimingsManager.getTiming(null, "Timings sampler 5", null);
        Timing SAMPLER6 = TimingsManager.getTiming(null, "Timings sampler 6", null);
        long start = System.nanoTime();
        for (int i = 0; i < passes; ++i) {
            SAMPLER1.startTiming();
            SAMPLER2.startTiming();
            SAMPLER3.startTiming();
            SAMPLER4.startTiming();
            SAMPLER5.startTiming();
            SAMPLER6.startTiming();
            SAMPLER6.stopTiming();
            SAMPLER5.stopTiming();
            SAMPLER4.stopTiming();
            SAMPLER3.stopTiming();
            SAMPLER2.stopTiming();
            SAMPLER1.stopTiming();
        }
        long timingsCost = (System.nanoTime() - start) / (long)passes / 6L;
        SAMPLER1.reset(true);
        SAMPLER2.reset(true);
        SAMPLER3.reset(true);
        SAMPLER4.reset(true);
        SAMPLER5.reset(true);
        SAMPLER6.reset(true);
        return timingsCost;
    }

    @Override
    public synchronized void start() {
        if (this.sender instanceof RemoteConsoleCommandSender) {
            this.sender.sendMessage(new TranslationContainer("nukkit.command.timings.rcon"));
            this.run();
        } else {
            super.start();
        }
    }

    @Override
    public void run() {
        this.sender.sendMessage(new TranslationContainer("nukkit.command.timings.uploadStart"));
        this.out.add("data", (JsonElement)JsonUtil.mapToArray(this.history, TimingsHistory::export));
        String response = null;
        try {
            HttpURLConnection con = (HttpURLConnection)new URL("http://timings.aikar.co/post").openConnection();
            con.setDoOutput(true);
            con.setRequestProperty("User-Agent", "Nukkit/" + Server.getInstance().getName() + "/" + InetAddress.getLocalHost().getHostName());
            con.setRequestMethod("POST");
            con.setInstanceFollowRedirects(false);
            PGZIPOutputStream request = new PGZIPOutputStream(con.getOutputStream());
            request.setLevel(9);
            request.write(new Gson().toJson((JsonElement)this.out).getBytes(StandardCharsets.UTF_8));
            request.close();
            response = this.getResponse(con);
            if (con.getResponseCode() != 302) {
                this.sender.sendMessage(new TranslationContainer("nukkit.command.timings.uploadError", String.valueOf(con.getResponseCode()), con.getResponseMessage()));
                if (response != null) {
                    log.warn(response);
                }
                return;
            }
            String location = con.getHeaderField("Location");
            this.sender.sendMessage(new TranslationContainer("nukkit.command.timings.timingsLocation", location));
            if (!(this.sender instanceof ConsoleCommandSender)) {
                log.info(Server.getInstance().getLanguage().translateString("nukkit.command.timings.timingsLocation", location));
            }
            if (response != null && !response.isEmpty()) {
                log.info(Server.getInstance().getLanguage().translateString("nukkit.command.timings.timingsResponse", response));
            }
            File timingFolder = new File(Server.getInstance().getDataPath() + File.separator + "timings");
            timingFolder.mkdirs();
            String fileName = timingFolder + File.separator + new SimpleDateFormat("'timings-'yyyy-MM-dd-hh-mm'.txt'").format(new Date());
            FileWriter writer = new FileWriter(fileName);
            writer.write(Server.getInstance().getLanguage().translateString("nukkit.command.timings.timingsLocation", location) + "\n\n");
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.out));
            writer.close();
            log.info(Server.getInstance().getLanguage().translateString("nukkit.command.timings.timingsWrite", fileName));
        }
        catch (IOException exception) {
            this.sender.sendMessage((Object)((Object)TextFormat.RED) + "" + new TranslationContainer("nukkit.command.timings.reportError"));
            if (response != null) {
                log.warn(response);
            }
            log.error("An error has occurred while exporting the timings report", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResponse(HttpURLConnection con) throws IOException {
        try (InputStream is = con.getInputStream();){
            int bytesRead;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((bytesRead = is.read(b)) != -1) {
                bos.write(b, 0, bytesRead);
            }
            String string = bos.toString();
            return string;
        }
        catch (IOException exception) {
            this.sender.sendMessage((Object)((Object)TextFormat.RED) + "" + new TranslationContainer("nukkit.command.timings.reportError"));
            log.error("An error has occurred while getting the timings response", (Throwable)exception);
            return null;
        }
    }
}

