/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFallableMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.value.AnvilDamage;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.util.Collection;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Extends BlockFallableMeta instead of BlockFallable", since="1.4.0.0-PN")
public class BlockAnvil
extends BlockFallableMeta
implements Faceable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<AnvilDamage> DAMAGE = new ArrayBlockProperty<AnvilDamage>("damage", false, AnvilDamage.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION.exportingToItems(true), DAMAGE.exportingToItems(true));

    public BlockAnvil() {
    }

    public BlockAnvil(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 145;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public AnvilDamage getAnvilDamage() {
        return this.getPropertyValue(DAMAGE);
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setAnvilDamage(AnvilDamage anvilDamage) {
        this.setPropertyValue(DAMAGE, anvilDamage);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean isTransparent() {
        return true;
    }

    @Override
    public double getHardness() {
        return 5.0;
    }

    @Override
    public double getResistance() {
        return 6000.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        return this.getAnvilDamage().getEnglishName();
    }

    @Override
    @PowerNukkitDifference(info="Just like sand, it can now be placed anywhere and removed the sound for the player who placed, was duplicated", since="1.3.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        this.setBlockFace(player != null ? player.getDirection().rotateY() : BlockFace.SOUTH);
        this.getLevel().setBlock((Vector3)this, this, true);
        if (player == null) {
            this.getLevel().addSound(this, Sound.RANDOM_ANVIL_LAND, 1.0f, 0.8f);
        } else {
            Collection<Player> players = this.getLevel().getChunkPlayers(this.getChunkX(), this.getChunkZ()).values();
            players.remove(player);
            if (!players.isEmpty()) {
                this.getLevel().addSound((Vector3)this, Sound.RANDOM_ANVIL_LAND, 1.0f, 0.8f, players);
            }
        }
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (player != null) {
            player.addWindow(new AnvilInventory(player.getUIInventory(), this), 2);
        }
        return true;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.IRON_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.DIRECTION, face);
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.DIRECTION);
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed the returned bounding box")
    protected AxisAlignedBB recalculateBoundingBox() {
        BlockFace face = this.getBlockFace().rotateY();
        double xOffset = (double)Math.abs(face.getXOffset()) * 0.125;
        double zOffset = (double)Math.abs(face.getZOffset()) * 0.125;
        return new SimpleAxisAlignedBB(this.x + xOffset, this.y, this.z + zOffset, this.x + 1.0 - xOffset, this.y + 1.0, this.z + 1.0 - zOffset);
    }
}

