/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntityBarrel;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.util.Map;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockBarrel
extends BlockSolidMeta
implements Faceable,
BlockEntityHolder<BlockEntityBarrel> {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.FACING_DIRECTION, CommonBlockProperties.OPEN);

    @PowerNukkitOnly
    public BlockBarrel() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockBarrel(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Barrel";
    }

    @Override
    public int getId() {
        return 458;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Barrel";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityBarrel> getBlockEntityClass() {
        return BlockEntityBarrel.class;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (Math.abs(player.x - this.x) < 2.0 && Math.abs(player.z - this.z) < 2.0) {
            double y = player.y + (double)player.getEyeHeight();
            if (y - this.y > 2.0) {
                this.setDamage(BlockFace.UP.getIndex());
            } else if (this.y - y > 0.0) {
                this.setDamage(BlockFace.DOWN.getIndex());
            } else {
                this.setDamage(player.getHorizontalFacing().getOpposite().getIndex());
            }
        } else {
            this.setDamage(player.getHorizontalFacing().getOpposite().getIndex());
        }
        CompoundTag nbt = new CompoundTag().putList(new ListTag("Items"));
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt, new Object[0]) != null;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (player == null) {
            return false;
        }
        BlockEntityBarrel barrel = (BlockEntityBarrel)this.getOrCreateBlockEntity();
        if (barrel.namedTag.contains("Lock") && barrel.namedTag.get("Lock") instanceof StringTag && !barrel.namedTag.getString("Lock").equals(item.getCustomName())) {
            return false;
        }
        player.addWindow(barrel.getInventory());
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 2.5;
    }

    @Override
    public double getResistance() {
        return 12.5;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockBarrel());
    }

    @Override
    public BlockFace getBlockFace() {
        int index = this.getDamage() & 7;
        return BlockFace.fromIndex(index);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setDamage(this.getDamage() & 8 | face.getIndex() & 7);
    }

    @PowerNukkitOnly
    public boolean isOpen() {
        return (this.getDamage() & 8) == 8;
    }

    @PowerNukkitOnly
    public void setOpen(boolean open) {
        this.setDamage(this.getDamage() & 7 | (open ? 8 : 0));
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntityBarrel blockEntity = (BlockEntityBarrel)this.getBlockEntity();
        if (blockEntity != null) {
            return ContainerInventory.calculateRedstone(blockEntity.getInventory());
        }
        return super.getComparatorInputOverride();
    }
}

