/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.value.StoneBrickType;
import cn.nukkit.item.Item;
import javax.annotation.Nonnull;

public class BlockBricksStone
extends BlockSolidMeta {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperty<StoneBrickType> STONE_BRICK_TYPE = new ArrayBlockProperty<StoneBrickType>("stone_brick_type", true, StoneBrickType.class);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(STONE_BRICK_TYPE);
    @Deprecated
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getStoneBrickType()", reason="Use the BlockProperty API instead")
    public static final int NORMAL = 0;
    @Deprecated
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getStoneBrickType()", reason="Use the BlockProperty API instead")
    public static final int MOSSY = 1;
    @Deprecated
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getStoneBrickType()", reason="Use the BlockProperty API instead")
    public static final int CRACKED = 2;
    @Deprecated
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getStoneBrickType()", reason="Use the BlockProperty API instead")
    public static final int CHISELED = 3;

    public BlockBricksStone() {
        this(0);
    }

    public BlockBricksStone(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 98;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 1.5;
    }

    @Override
    public double getResistance() {
        return 30.0;
    }

    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public void setBrickStoneType(StoneBrickType stoneBrickType) {
        this.setPropertyValue(STONE_BRICK_TYPE, stoneBrickType);
    }

    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public StoneBrickType getStoneBrickType() {
        return this.getPropertyValue(STONE_BRICK_TYPE);
    }

    @Override
    public String getName() {
        return this.getStoneBrickType().getEnglishName();
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return Item.EMPTY_ARRAY;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

