/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockCauldronLava;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntityCauldron;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.blockproperty.value.CauldronLiquid;
import cn.nukkit.event.player.PlayerBucketEmptyEvent;
import cn.nukkit.event.player.PlayerBucketFillEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBanner;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.item.ItemCauldron;
import cn.nukkit.item.ItemDye;
import cn.nukkit.item.ItemGlassBottle;
import cn.nukkit.item.ItemPotion;
import cn.nukkit.item.ItemPotionLingering;
import cn.nukkit.item.ItemPotionSplash;
import cn.nukkit.item.MinecraftItemID;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.SmokeParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import java.util.Map;
import javax.annotation.Nonnull;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockCauldron
extends BlockSolidMeta
implements BlockEntityHolder<BlockEntityCauldron> {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final IntBlockProperty FILL_LEVEL = new IntBlockProperty("fill_level", false, 6);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final ArrayBlockProperty<CauldronLiquid> LIQUID = new ArrayBlockProperty<CauldronLiquid>("cauldron_liquid", false, CauldronLiquid.class);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(FILL_LEVEL, LIQUID);

    public BlockCauldron() {
        super(0);
    }

    public BlockCauldron(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 118;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Cauldron";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityCauldron> getBlockEntityClass() {
        return BlockEntityCauldron.class;
    }

    @Override
    public String getName() {
        return "Cauldron Block";
    }

    @Override
    public double getResistance() {
        return 10.0;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    public boolean isFull() {
        return this.getFillLevel() == FILL_LEVEL.getMaxValue();
    }

    public boolean isEmpty() {
        return this.getFillLevel() == FILL_LEVEL.getMinValue();
    }

    public int getFillLevel() {
        return this.getIntValue(FILL_LEVEL);
    }

    public void setFillLevel(int fillLevel) {
        this.setIntValue(FILL_LEVEL, fillLevel);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        BlockEntityCauldron cauldron = (BlockEntityCauldron)this.getBlockEntity();
        if (cauldron == null) {
            return false;
        }
        switch (item.getId()) {
            case 325: {
                ItemBucket bucket = (ItemBucket)item;
                if (bucket.getFishEntityId() != null) break;
                if (bucket.isEmpty()) {
                    if (!this.isFull() || cauldron.isCustomColor() || cauldron.hasPotion()) break;
                    PlayerBucketFillEvent ev = new PlayerBucketFillEvent(player, this, null, this, item, MinecraftItemID.WATER_BUCKET.get(1, bucket.getCompoundTag()));
                    this.level.getServer().getPluginManager().callEvent(ev);
                    if (ev.isCancelled()) break;
                    this.replaceBucket(bucket, player, ev.getItem());
                    this.setFillLevel(FILL_LEVEL.getMinValue());
                    this.level.setBlock((Vector3)this, this, true);
                    cauldron.clearCustomColor();
                    this.getLevel().addLevelEvent(this.add(0.5, 0.375 + (double)this.getFillLevel() * 0.125, 0.5), 3507);
                    break;
                }
                if (!bucket.isWater() && !bucket.isLava() || this.isFull() && !cauldron.isCustomColor() && !cauldron.hasPotion() && item.getDamage() == 8) break;
                PlayerBucketEmptyEvent ev = new PlayerBucketEmptyEvent(player, this, null, this, item, MinecraftItemID.BUCKET.get(1, bucket.getCompoundTag()));
                this.level.getServer().getPluginManager().callEvent(ev);
                if (ev.isCancelled()) break;
                if (player.isSurvival() || player.isAdventure()) {
                    this.replaceBucket(bucket, player, ev.getItem());
                }
                if (cauldron.hasPotion()) {
                    this.clearWithFizz(cauldron);
                    break;
                }
                if (bucket.isWater()) {
                    this.setFillLevel(FILL_LEVEL.getMaxValue());
                    cauldron.clearCustomColor();
                    this.level.setBlock((Vector3)this, this, true);
                    this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.CAULDRON_FILLWATER);
                    break;
                }
                if (this.isEmpty()) {
                    BlockCauldronLava cauldronLava = new BlockCauldronLava(14);
                    cauldronLava.setFillLevel(FILL_LEVEL.getMaxValue());
                    this.level.setBlock((Vector3)this, cauldronLava, true, true);
                    cauldron.clearCustomColor();
                    cauldron.setType(BlockEntityCauldron.PotionType.LAVA);
                    this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.BUCKET_EMPTY_LAVA);
                    break;
                }
                this.clearWithFizz(cauldron);
                break;
            }
            case 351: {
                if (this.isEmpty() || cauldron.hasPotion()) break;
                if (player.isSurvival() || player.isAdventure()) {
                    item.setCount(item.getCount() - 1);
                    player.getInventory().setItemInHand(item);
                }
                BlockColor color = new ItemDye((Integer)item.getDamage()).getDyeColor().getLeatherColor();
                if (!cauldron.isCustomColor()) {
                    cauldron.setCustomColor(color);
                } else {
                    BlockColor current = cauldron.getCustomColor();
                    BlockColor mixed = new BlockColor((int)Math.round(Math.sqrt(color.getRed() * current.getRed()) * 0.965), (int)Math.round(Math.sqrt(color.getGreen() * current.getGreen()) * 0.965), (int)Math.round(Math.sqrt(color.getBlue() * current.getBlue()) * 0.965));
                    cauldron.setCustomColor(mixed);
                }
                this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.CAULDRON_ADDDYE);
                break;
            }
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 416: {
                CompoundTag compoundTag;
                if (this.isEmpty() || cauldron.hasPotion()) break;
                if (cauldron.isCustomColor()) {
                    CompoundTag compoundTag2 = item.hasCompoundTag() ? item.getNamedTag() : new CompoundTag();
                    compoundTag2.putInt("customColor", cauldron.getCustomColor().getRGB());
                    item.setCompoundTag(compoundTag2);
                    player.getInventory().setItemInHand(item);
                    this.setFillLevel(FILL_LEVEL.clamp(this.getFillLevel() - 2));
                    this.level.setBlock((Vector3)this, this, true, true);
                    this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.CAULDRON_DYEARMOR);
                    break;
                }
                if (!item.hasCompoundTag() || !(compoundTag = item.getNamedTag()).exist("customColor")) break;
                compoundTag.remove("customColor");
                item.setCompoundTag(compoundTag);
                player.getInventory().setItemInHand(item);
                this.setFillLevel(FILL_LEVEL.clamp(this.getFillLevel() - 2));
                this.level.setBlock((Vector3)this, this, true, true);
                this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.CAULDRON_TAKEWATER);
                break;
            }
            case 373: 
            case 438: 
            case 441: {
                if (!this.isEmpty() && (cauldron.hasPotion() ? cauldron.getPotionId() != item.getDamage() : item.getDamage() != 0)) {
                    this.clearWithFizz(cauldron);
                    this.consumePotion(item, player);
                    break;
                }
                if (this.isFull()) break;
                if (item.getDamage() != 0 && this.isEmpty()) {
                    cauldron.setPotionId(item.getDamage());
                }
                cauldron.setType(item.getId() == 373 ? BlockEntityCauldron.PotionType.NORMAL : (item.getId() == 438 ? BlockEntityCauldron.PotionType.SPLASH : BlockEntityCauldron.PotionType.LINGERING));
                cauldron.spawnToAll();
                this.setFillLevel(FILL_LEVEL.clamp(this.getFillLevel() + 2));
                this.level.setBlock((Vector3)this, this, true);
                this.consumePotion(item, player);
                this.level.addLevelEvent(this.add(0.5, 0.375 + (double)this.getFillLevel() * 0.125, 0.5), 3504);
                break;
            }
            case 374: {
                boolean consumeBottle;
                Item potion;
                int meta;
                if (this.isEmpty()) break;
                int n = meta = cauldron.hasPotion() ? cauldron.getPotionId() : 0;
                if (meta == 0) {
                    potion = new ItemPotion();
                } else {
                    switch (cauldron.getType()) {
                        case SPLASH: {
                            potion = new ItemPotionSplash((Integer)meta);
                            break;
                        }
                        case LINGERING: {
                            potion = new ItemPotionLingering((Integer)meta);
                            break;
                        }
                        default: {
                            potion = new ItemPotion((Integer)meta);
                        }
                    }
                }
                this.setFillLevel(FILL_LEVEL.clamp(this.getFillLevel() - 2));
                if (this.isEmpty()) {
                    cauldron.setPotionId(-1);
                    cauldron.clearCustomColor();
                }
                this.level.setBlock((Vector3)this, this, true);
                boolean bl = consumeBottle = player.isSurvival() || player.isAdventure();
                if (consumeBottle && item.getCount() == 1) {
                    player.getInventory().setItemInHand(potion);
                } else if (item.getCount() > 1) {
                    if (consumeBottle) {
                        item.setCount(item.getCount() - 1);
                        player.getInventory().setItemInHand(item);
                    }
                    if (player.getInventory().canAddItem(potion)) {
                        player.getInventory().addItem(potion);
                    } else {
                        player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), potion, player.getDirectionVector().multiply(0.4));
                    }
                }
                this.level.addLevelEvent(this.add(0.5, 0.375 + (double)this.getFillLevel() * 0.125, 0.5), 3505);
                break;
            }
            case 446: {
                boolean consumeBanner;
                ItemBanner banner;
                if (this.isEmpty() || cauldron.isCustomColor() || cauldron.hasPotion() || !(banner = (ItemBanner)item).hasPattern()) break;
                banner.removePattern(banner.getPatternsSize() - 1);
                boolean bl = consumeBanner = player.isSurvival() || player.isAdventure();
                if (consumeBanner && item.getCount() < item.getMaxStackSize()) {
                    player.getInventory().setItemInHand(banner);
                } else {
                    if (consumeBanner) {
                        item.setCount(item.getCount() - 1);
                        player.getInventory().setItemInHand(item);
                    }
                    if (player.getInventory().canAddItem(banner)) {
                        player.getInventory().addItem(banner);
                    } else {
                        player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), banner, player.getDirectionVector().multiply(0.4));
                    }
                }
                this.setFillLevel(FILL_LEVEL.clamp(this.getFillLevel() - 2));
                this.level.setBlock((Vector3)this, this, true, true);
                this.getLevel().addSound(this.add(0.5, 1.0, 0.5), Sound.CAULDRON_TAKEWATER);
                break;
            }
            default: {
                if (item instanceof ItemDye) {
                    if (this.isEmpty() || cauldron.hasPotion()) break;
                    if (player.isSurvival() || player.isAdventure()) {
                        item.setCount(item.getCount() - 1);
                        player.getInventory().setItemInHand(item);
                    }
                    BlockColor color = ((ItemDye)item).getDyeColor().getColor();
                    if (!cauldron.isCustomColor()) {
                        cauldron.setCustomColor(color);
                    } else {
                        BlockColor current = cauldron.getCustomColor();
                        BlockColor mixed = new BlockColor(current.getRed() + (color.getRed() - current.getRed()) / 2, current.getGreen() + (color.getGreen() - current.getGreen()) / 2, current.getBlue() + (color.getBlue() - current.getBlue()) / 2);
                        cauldron.setCustomColor(mixed);
                    }
                    this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.CAULDRON_ADDDYE);
                    break;
                }
                return true;
            }
        }
        this.level.updateComparatorOutputLevel(this);
        return true;
    }

    protected void replaceBucket(Item oldBucket, Player player, Item newBucket) {
        if (player.isSurvival() || player.isAdventure()) {
            if (oldBucket.getCount() == 1) {
                player.getInventory().setItemInHand(newBucket);
            } else {
                oldBucket.setCount(oldBucket.getCount() - 1);
                if (player.getInventory().canAddItem(newBucket)) {
                    player.getInventory().addItem(newBucket);
                } else {
                    player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), newBucket, player.getDirectionVector().multiply(0.4));
                }
            }
        }
    }

    private void consumePotion(Item item, Player player) {
        if (player.isSurvival() || player.isAdventure()) {
            if (item.getCount() == 1) {
                player.getInventory().setItemInHand(new ItemBlock(new BlockAir()));
            } else if (item.getCount() > 1) {
                item.setCount(item.getCount() - 1);
                player.getInventory().setItemInHand(item);
                ItemGlassBottle bottle = new ItemGlassBottle();
                if (player.getInventory().canAddItem(bottle)) {
                    player.getInventory().addItem(bottle);
                } else {
                    player.getLevel().dropItem(player.add(0.0, 1.3, 0.0), bottle, player.getDirectionVector().multiply(0.4));
                }
            }
        }
    }

    @PowerNukkitOnly
    public void clearWithFizz(BlockEntityCauldron cauldron) {
        this.setFillLevel(FILL_LEVEL.getMinValue());
        cauldron.setPotionId(-1);
        cauldron.setType(BlockEntityCauldron.PotionType.NORMAL);
        cauldron.clearCustomColor();
        this.level.setBlock((Vector3)this, new BlockCauldron(0), true);
        this.level.addSound(this.add(0.5, 0.0, 0.5), Sound.RANDOM_FIZZ);
        for (int i = 0; i < 8; ++i) {
            this.getLevel().addParticle(new SmokeParticle(this.add(Math.random(), 1.2, Math.random())));
        }
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        CompoundTag nbt = new CompoundTag().putShort("PotionId", -1).putByte("SplashPotion", 0);
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt, new Object[0]) != null;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public Item toItem() {
        return new ItemCauldron();
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.getFillLevel();
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will return true")
    public boolean isTransparent() {
        return true;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getLightFilter() {
        return 3;
    }
}

