/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntityDispenser;
import cn.nukkit.blockentity.BlockEntityEjectable;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.dispenser.DispenseBehavior;
import cn.nukkit.dispenser.DispenseBehaviorRegister;
import cn.nukkit.dispenser.DropperDispenseBehavior;
import cn.nukkit.dispenser.FlintAndSteelDispenseBehavior;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

@PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit"), @PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")})
public class BlockDispenser
extends BlockSolidMeta
implements RedstoneComponent,
Faceable,
BlockEntityHolder<BlockEntityEjectable> {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BooleanBlockProperty TRIGGERED = new BooleanBlockProperty("triggered_bit", false);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.FACING_DIRECTION, TRIGGERED);

    public BlockDispenser() {
        this(0);
    }

    public BlockDispenser(int meta) {
        super(meta);
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public String getName() {
        return "Dispenser";
    }

    @Override
    public int getId() {
        return 23;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Dispenser";
    }

    @Override
    public double getHardness() {
        return 3.5;
    }

    @Override
    public double getResistance() {
        return 3.5;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityEjectable> getBlockEntityClass() {
        return BlockEntityDispenser.class;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public int getComparatorInputOverride() {
        InventoryHolder blockEntity = (InventoryHolder)this.getBlockEntity();
        if (blockEntity != null) {
            return ContainerInventory.calculateRedstone(blockEntity.getInventory());
        }
        return 0;
    }

    public boolean isTriggered() {
        return (this.getDamage() & 8) > 0;
    }

    public void setTriggered(boolean value) {
        int i = 0;
        i |= this.getBlockFace().getIndex();
        if (value) {
            i |= 8;
        }
        this.setDamage(i);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (player == null) {
            return false;
        }
        InventoryHolder blockEntity = (InventoryHolder)this.getBlockEntity();
        if (blockEntity == null) {
            return false;
        }
        player.addWindow(blockEntity.getInventory());
        return true;
    }

    @Override
    @PowerNukkitDifference(info="BlockData is implemented.", since="1.4.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (player != null) {
            if (Math.abs(player.x - this.x) < 2.0 && Math.abs(player.z - this.z) < 2.0) {
                double y = player.y + (double)player.getEyeHeight();
                if (y - this.y > 2.0) {
                    this.setDamage(BlockFace.UP.getIndex());
                } else if (this.y - y > 0.0) {
                    this.setDamage(BlockFace.DOWN.getIndex());
                } else {
                    this.setDamage(player.getHorizontalFacing().getOpposite().getIndex());
                }
            } else {
                this.setDamage(player.getHorizontalFacing().getOpposite().getIndex());
            }
        }
        CompoundTag nbt = new CompoundTag().putList(new ListTag("Items"));
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt, new Object[0]) != null;
    }

    @Override
    @PowerNukkitDifference(info="Disables the triggered state, when the block is no longer powered + use #isGettingPower() method.", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        if (type == 3) {
            this.dispense();
            return type;
        }
        if (type == 6 || type == 1) {
            boolean triggered = this.isTriggered();
            if (this.isGettingPower() && !triggered) {
                this.setTriggered(true);
                this.level.setBlock((Vector3)this, this, false, false);
                this.level.scheduleUpdate(this, this, 4);
            } else if (!this.isGettingPower() && triggered) {
                this.setTriggered(false);
                this.level.setBlock((Vector3)this, this, false, false);
            }
            return type;
        }
        return 0;
    }

    @PowerNukkitDifference(info="Trigger observer on dispense fail (with #setDirty()).", since="1.4.0.0-PN")
    public void dispense() {
        InventoryHolder blockEntity = (InventoryHolder)this.getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int r = 1;
        int slot = -1;
        Item target = null;
        Inventory inv = blockEntity.getInventory();
        for (Map.Entry<Integer, Item> entry : inv.getContents().entrySet()) {
            Item item = entry.getValue();
            if (item.isNull() || ((Random)rand).nextInt(r++) != 0) continue;
            target = item;
            slot = entry.getKey();
        }
        LevelEventPacket pk = new LevelEventPacket();
        BlockFace facing = this.getBlockFace();
        pk.x = 0.5f + (float)facing.getXOffset() * 0.7f;
        pk.y = 0.5f + (float)facing.getYOffset() * 0.7f;
        pk.z = 0.5f + (float)facing.getZOffset() * 0.7f;
        if (target == null) {
            this.level.addSound(this, Sound.RANDOM_CLICK, 1.0f, 1.2f);
            ((BlockEntityEjectable)this.getBlockEntity()).setDirty();
            return;
        }
        if (!(this.getDispenseBehavior(target) instanceof DropperDispenseBehavior) && !(this.getDispenseBehavior(target) instanceof FlintAndSteelDispenseBehavior)) {
            this.level.addSound(this, Sound.RANDOM_CLICK, 1.0f, 1.0f);
        }
        pk.evid = 2000;
        pk.data = 7;
        this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), pk);
        Item origin = target;
        target = target.clone();
        DispenseBehavior behavior = this.getDispenseBehavior(target);
        Item result = behavior.dispense(this, facing, target);
        --target.count;
        inv.setItem(slot, target);
        if (result != null) {
            if (result.getId() != origin.getId() || result.getDamage() != origin.getDamage()) {
                Item[] fit = inv.addItem(result);
                if (fit.length > 0) {
                    for (Item drop : fit) {
                        this.level.dropItem(this, drop);
                    }
                }
            } else {
                inv.setItem(slot, result);
            }
        }
    }

    protected DispenseBehavior getDispenseBehavior(Item item) {
        return DispenseBehaviorRegister.getBehavior(item.getId());
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    public Vector3 getDispensePosition() {
        BlockFace facing = this.getBlockFace();
        return this.add(0.5 + 0.7 * (double)facing.getXOffset(), 0.5 + 0.7 * (double)facing.getYOffset(), 0.5 + 0.7 * (double)facing.getZOffset());
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getDamage() & 7);
    }
}

