/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.blockproperty.value.SmallFlowerType;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class BlockFlower
extends BlockFlowable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<SmallFlowerType> RED_FLOWER_TYPE = new ArrayBlockProperty("flower_type", true, (Serializable[])new SmallFlowerType[]{SmallFlowerType.POPPY, SmallFlowerType.ORCHID, SmallFlowerType.ALLIUM, SmallFlowerType.HOUSTONIA, SmallFlowerType.TULIP_RED, SmallFlowerType.TULIP_ORANGE, SmallFlowerType.TULIP_WHITE, SmallFlowerType.TULIP_PINK, SmallFlowerType.OXEYE, SmallFlowerType.CORNFLOWER, SmallFlowerType.LILY_OF_THE_VALLEY});
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(RED_FLOWER_TYPE);
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_POPPY = 0;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_BLUE_ORCHID = 1;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_ALLIUM = 2;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_AZURE_BLUET = 3;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_RED_TULIP = 4;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_ORANGE_TULIP = 5;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_WHITE_TULIP = 6;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_PINK_TULIP = 7;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="Magic value. Use FlowerType instead")
    public static final int TYPE_OXEYE_DAISY = 8;

    public BlockFlower() {
        this(0);
    }

    public BlockFlower(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 38;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return this.getFlowerType().getEnglishName();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public SmallFlowerType getFlowerType() {
        return this.getPropertyValue(RED_FLOWER_TYPE);
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    protected void setOnSingleFlowerType(SmallFlowerType acceptsOnly, SmallFlowerType attemptedToSet) {
        if (attemptedToSet == null || attemptedToSet == acceptsOnly) {
            return;
        }
        String persistenceName = this.getPersistenceName();
        throw new InvalidBlockPropertyValueException(new ArrayBlockProperty(persistenceName + "_type", false, (Serializable[])new SmallFlowerType[]{acceptsOnly}), (Serializable)((Object)acceptsOnly), (Serializable)((Object)attemptedToSet), persistenceName + " only accepts " + acceptsOnly.name().toLowerCase());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setFlowerType(SmallFlowerType flowerType) {
        this.setPropertyValue(RED_FLOWER_TYPE, flowerType);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static boolean isSupportValid(Block block) {
        switch (block.getId()) {
            case 2: 
            case 3: 
            case 60: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean canPlantOn(Block block) {
        return BlockFlower.isSupportValid(block);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (this.canPlantOn(down)) {
            this.getLevel().setBlock((Vector3)block, this, true);
            return true;
        }
        return false;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will break on normal update if the supporting block is invalid")
    public int onUpdate(int type) {
        if (type == 1 && !this.canPlantOn(this.down())) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isFertilizer()) {
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            for (int i = 0; i < 8; ++i) {
                Position vec = this.add(ThreadLocalRandom.current().nextInt(-3, 4), ThreadLocalRandom.current().nextInt(-1, 2), ThreadLocalRandom.current().nextInt(-3, 4));
                if (this.level.getBlock(vec).getId() != 0 || this.level.getBlock(vec.down()).getId() != 2 || !(vec.getY() >= 0.0) || !(vec.getY() < 256.0)) continue;
                if (ThreadLocalRandom.current().nextInt(10) == 0) {
                    this.level.setBlock((Vector3)vec, this.getUncommonFlower(), true);
                    continue;
                }
                this.level.setBlock((Vector3)vec, BlockFlower.get(this.getId()), true);
            }
            return true;
        }
        return false;
    }

    protected Block getUncommonFlower() {
        return BlockFlower.get(37);
    }
}

