/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntityLectern;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.LecternDropBookEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
public class BlockLectern
extends BlockTransparentMeta
implements RedstoneComponent,
Faceable,
BlockEntityHolder<BlockEntityLectern> {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, CommonBlockProperties.POWERED);

    @PowerNukkitOnly
    public BlockLectern() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockLectern(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Lectern";
    }

    @Override
    public int getId() {
        return 449;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityLectern> getBlockEntityClass() {
        return BlockEntityLectern.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Lectern";
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 12.5;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.89999;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        int power = 0;
        int page = 0;
        int maxPage = 0;
        BlockEntityLectern lectern = (BlockEntityLectern)this.getBlockEntity();
        if (lectern != null && lectern.hasBook()) {
            maxPage = lectern.getTotalPages();
            page = lectern.getLeftPage() + 1;
            power = (int)((float)page / (float)maxPage * 16.0f);
        }
        return power;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 3);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlockFace(BlockFace face) {
        int horizontalIndex = face.getHorizontalIndex();
        if (horizontalIndex >= 0) {
            this.setDamage(this.getDamage() & (DATA_MASK ^ 3) | horizontalIndex & 3);
        }
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        this.setBlockFace(player != null ? player.getDirection().getOpposite() : BlockFace.SOUTH);
        return BlockEntityHolder.setBlockAndCreateEntity(this) != null;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int onTouch(@Nullable Player player, PlayerInteractEvent.Action action) {
        if (action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (player == null || !player.isCreative() && !player.isSpectator())) {
            this.dropBook(player);
        }
        return super.onTouch(player, action);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        BlockEntityLectern lectern = (BlockEntityLectern)this.getOrCreateBlockEntity();
        Item currentBook = lectern.getBook();
        if (!currentBook.isNull()) {
            return false;
        }
        if (item.getId() != 387 && item.getId() != 386) {
            return false;
        }
        if (player == null || !player.isCreative()) {
            --item.count;
        }
        Item newBook = item.clone();
        newBook.setCount(1);
        lectern.setBook(newBook);
        lectern.spawnToAll();
        this.getLevel().addSound(this.add(0.5, 0.5, 0.5), Sound.ITEM_BOOK_PUT);
        return true;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @PowerNukkitOnly
    public boolean isActivated() {
        return (this.getDamage() & 4) == 4;
    }

    @PowerNukkitOnly
    public void setActivated(boolean activated) {
        if (activated) {
            this.setDamage(this.getDamage() | 4);
        } else {
            this.setDamage(this.getDamage() ^ 4);
        }
    }

    @PowerNukkitDifference(info="Down side is strongly powered.", since="1.4.0.0-PN")
    public void executeRedstonePulse() {
        if (this.isActivated()) {
            this.level.cancelSheduledUpdate(this, this);
        } else {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
        }
        this.level.scheduleUpdate(this, this, 4);
        this.setActivated(true);
        this.level.setBlock((Vector3)this, this, true, false);
        this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.ITEM_BOOK_PAGE_TURN);
        this.updateAroundRedstone(new BlockFace[0]);
        RedstoneComponent.updateAroundRedstone((Position)this.getSide(BlockFace.DOWN), BlockFace.UP);
    }

    @Override
    public int getWeakPower(BlockFace face) {
        return this.isActivated() ? 15 : 0;
    }

    @Override
    @PowerNukkitDifference(info="Down side is strongly powered.", since="1.4.0.0-PN")
    public int getStrongPower(BlockFace face) {
        return face == BlockFace.DOWN ? this.getWeakPower(face) : 0;
    }

    @Override
    @PowerNukkitDifference(info="Down side is strongly powered.", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type == 3) {
            if (this.isActivated()) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
                this.setActivated(false);
                this.level.setBlock((Vector3)this, this, true, false);
                this.updateAroundRedstone(new BlockFace[0]);
                RedstoneComponent.updateAroundRedstone((Position)this.getSide(BlockFace.DOWN), BlockFace.UP);
            }
            return 3;
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @PowerNukkitOnly
    public void dropBook(Player player) {
        BlockEntityLectern lectern = (BlockEntityLectern)this.getBlockEntity();
        if (lectern == null) {
            return;
        }
        Item book = lectern.getBook();
        if (book.isNull()) {
            return;
        }
        LecternDropBookEvent dropBookEvent = new LecternDropBookEvent(player, lectern, book);
        this.getLevel().getServer().getPluginManager().callEvent(dropBookEvent);
        if (dropBookEvent.isCancelled()) {
            return;
        }
        lectern.setBook(Item.getBlock(0));
        lectern.spawnToAll();
        this.level.dropItem(lectern.add(0.5, 0.6f, 0.5), dropBookEvent.getBook());
    }
}

